/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;

public abstract class AbstractWeighting
implements Weighting {
    protected final FlagEncoder flagEncoder;
    protected final DecimalEncodedValue avSpeedEnc;
    protected final BooleanEncodedValue accessEnc;
    private final TurnCostProvider turnCostProvider;

    protected AbstractWeighting(FlagEncoder encoder) {
        this(encoder, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    protected AbstractWeighting(FlagEncoder encoder, TurnCostProvider turnCostProvider) {
        this.flagEncoder = encoder;
        if (!this.flagEncoder.isRegistered()) {
            throw new IllegalStateException("Make sure you add the FlagEncoder " + this.flagEncoder + " to an EncodingManager before using it elsewhere");
        }
        if (!AbstractWeighting.isValidName(this.getName())) {
            throw new IllegalStateException("Not a valid name for a Weighting: " + this.getName());
        }
        this.avSpeedEnc = encoder.getAverageSpeedEnc();
        this.accessEnc = encoder.getAccessEnc();
        this.turnCostProvider = turnCostProvider;
    }

    @Override
    public abstract double calcEdgeWeight(EdgeIteratorState var1, boolean var2);

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        double speed;
        if (edgeState.getBaseNode() == edgeState.getAdjNode()) {
            reverse = false;
        }
        if (reverse && !edgeState.getReverse(this.accessEnc) || !reverse && !edgeState.get(this.accessEnc)) {
            throw new IllegalStateException("Calculating time should not require to read speed from edge in wrong direction. (" + edgeState.getBaseNode() + " - " + edgeState.getAdjNode() + ") " + edgeState.fetchWayGeometry(FetchMode.ALL) + ", dist: " + edgeState.getDistance() + " Reverse:" + reverse + ", fwd:" + edgeState.get(this.accessEnc) + ", bwd:" + edgeState.getReverse(this.accessEnc) + ", fwd-speed: " + edgeState.get(this.avSpeedEnc) + ", bwd-speed: " + edgeState.getReverse(this.avSpeedEnc));
        }
        double d = speed = reverse ? edgeState.getReverse(this.avSpeedEnc) : edgeState.get(this.avSpeedEnc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid speed stored in edge! " + speed);
        }
        if (speed == 0.0) {
            throw new IllegalStateException("Speed cannot be 0 for unblocked edge, use access properties to mark edge blocked! Should only occur for shortest path calculation. See #242.");
        }
        return (long)(edgeState.getDistance() * 3600.0 / speed);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnMillis(inEdge, viaNode, outEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.turnCostProvider != TurnCostProvider.NO_TURN_COST_PROVIDER;
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.flagEncoder;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Weighting other = (Weighting)obj;
        return this.toString().equals(other.toString());
    }

    static boolean isValidName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.matches("[\\|_a-z]+");
    }

    public String toString() {
        return this.getName() + "|" + this.flagEncoder;
    }
}

