/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.gpx;

import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.gpx.GPXEntry;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class GpxFromInstructions {
    private static final AngleCalc AC = AngleCalc.ANGLE_CALC;

    static String simpleXMLEscape(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("[\\<\\>]", "_");
    }

    public static List<GPXEntry> createGPXList(InstructionList instructions) {
        ArrayList<GPXEntry> gpxList = new ArrayList<GPXEntry>();
        long timeOffset = 0L;
        for (Instruction instruction : instructions) {
            int i = 0;
            for (GHPoint3D point : instruction.getPoints()) {
                GPXEntry gpxEntry = i == 0 ? new GPXEntry((GHPoint)point, timeOffset) : new GPXEntry((GHPoint)point);
                gpxList.add(gpxEntry);
                ++i;
            }
            timeOffset += instruction.getTime();
        }
        return gpxList;
    }

    private static void createWayPointBlock(StringBuilder output, Instruction instruction, DecimalFormat decimalFormat, Translation tr) {
        output.append("\n<wpt ");
        output.append("lat=\"").append(decimalFormat.format(instruction.getPoints().getLatitude(0)));
        output.append("\" lon=\"").append(decimalFormat.format(instruction.getPoints().getLongitude(0))).append("\">");
        String name = instruction.getName().isEmpty() ? instruction.getTurnDescription(tr) : instruction.getName();
        output.append(" <name>").append(GpxFromInstructions.simpleXMLEscape(name)).append("</name>");
        output.append("</wpt>");
    }

    public static String createGPX(InstructionList instructions, String trackName, long startTimeMillis, boolean includeElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version, Translation tr) {
        DateFormat formatter = Helper.createFormatter();
        DecimalFormat decimalFormat = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumIntegerDigits(1);
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" creator=\"Graphhopper version " + version + "\" version=\"1.1\" xmlns:gh=\"https://graphhopper.com/public/schema/gpx/1.1\">\n<metadata><copyright author=\"OpenStreetMap contributors\"/><link href=\"http://graphhopper.com\"><text>GraphHopper GPX</text></link><time>" + formatter.format(startTimeMillis) + "</time></metadata>";
        StringBuilder gpxOutput = new StringBuilder(header);
        if (!instructions.isEmpty()) {
            if (withWayPoints) {
                GpxFromInstructions.createWayPointBlock(gpxOutput, instructions.get(0), decimalFormat, tr);
                for (Iterator currInstr : instructions) {
                    if (currInstr.getSign() != 5 && currInstr.getSign() != 4) continue;
                    GpxFromInstructions.createWayPointBlock(gpxOutput, (Instruction)currInstr, decimalFormat, tr);
                }
            }
            if (withRoute) {
                gpxOutput.append("\n<rte>");
                Instruction nextInstr = null;
                for (Instruction currInstr : instructions) {
                    if (null != nextInstr) {
                        GpxFromInstructions.createRteptBlock(gpxOutput, nextInstr, currInstr, decimalFormat, tr);
                    }
                    nextInstr = currInstr;
                }
                GpxFromInstructions.createRteptBlock(gpxOutput, nextInstr, null, decimalFormat, tr);
                gpxOutput.append("\n</rte>");
            }
        }
        if (withTrack) {
            gpxOutput.append("\n<trk><name>").append(trackName).append("</name>");
            gpxOutput.append("<trkseg>");
            for (GPXEntry entry : GpxFromInstructions.createGPXList(instructions)) {
                gpxOutput.append("\n<trkpt lat=\"").append(decimalFormat.format(entry.getPoint().getLat()));
                gpxOutput.append("\" lon=\"").append(decimalFormat.format(entry.getPoint().getLon())).append("\">");
                if (includeElevation) {
                    gpxOutput.append("<ele>").append(Helper.round2((double)((GHPoint3D)entry.getPoint()).getEle())).append("</ele>");
                }
                if (entry.getTime() != null) {
                    gpxOutput.append("<time>").append(formatter.format(startTimeMillis + entry.getTime())).append("</time>");
                }
                gpxOutput.append("</trkpt>");
            }
            gpxOutput.append("\n</trkseg>");
            gpxOutput.append("\n</trk>");
        }
        gpxOutput.append("\n</gpx>");
        return gpxOutput.toString();
    }

    private static void createRteptBlock(StringBuilder output, Instruction instruction, Instruction nextI, DecimalFormat decimalFormat, Translation tr) {
        double azimuth;
        output.append("\n<rtept lat=\"").append(decimalFormat.format(instruction.getPoints().getLatitude(0))).append("\" lon=\"").append(decimalFormat.format(instruction.getPoints().getLongitude(0))).append("\">");
        if (!instruction.getName().isEmpty()) {
            output.append("<desc>").append(GpxFromInstructions.simpleXMLEscape(instruction.getTurnDescription(tr))).append("</desc>");
        }
        output.append("<extensions>");
        output.append("<gh:distance>").append(Helper.round((double)instruction.getDistance(), (int)1)).append("</gh:distance>");
        output.append("<gh:time>").append(instruction.getTime()).append("</gh:time>");
        String direction = GpxFromInstructions.calcDirection(instruction, nextI);
        if (!direction.isEmpty()) {
            output.append("<gh:direction>").append(direction).append("</gh:direction>");
        }
        if (!Double.isNaN(azimuth = GpxFromInstructions.calcAzimuth(instruction, nextI))) {
            output.append("<gh:azimuth>").append(Helper.round2((double)azimuth)).append("</gh:azimuth>");
        }
        if (instruction instanceof RoundaboutInstruction) {
            RoundaboutInstruction ri = (RoundaboutInstruction)instruction;
            output.append("<gh:exit_number>").append(ri.getExitNumber()).append("</gh:exit_number>");
        }
        output.append("<gh:sign>").append(instruction.getSign()).append("</gh:sign>");
        output.append("</extensions>");
        output.append("</rtept>");
    }

    public static String calcDirection(Instruction instruction, Instruction nextI) {
        double azimuth = GpxFromInstructions.calcAzimuth(instruction, nextI);
        if (Double.isNaN(azimuth)) {
            return "";
        }
        return AC.azimuth2compassPoint(azimuth);
    }

    public static double calcAzimuth(Instruction instruction, Instruction nextI) {
        double nextLon;
        double nextLat;
        if (instruction.getPoints().getSize() >= 2) {
            nextLat = instruction.getPoints().getLatitude(1);
            nextLon = instruction.getPoints().getLongitude(1);
        } else if (nextI != null && instruction.getPoints().getSize() == 1) {
            nextLat = nextI.getPoints().getLatitude(0);
            nextLon = nextI.getPoints().getLongitude(0);
        } else {
            return Double.NaN;
        }
        double lat = instruction.getPoints().getLatitude(0);
        double lon = instruction.getPoints().getLongitude(0);
        return AC.calcAzimuth(lat, lon, nextLat, nextLon);
    }
}

