/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractSRTMElevationProvider;
import com.graphhopper.util.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class SkadiProvider
extends AbstractSRTMElevationProvider {
    public SkadiProvider() {
        this("");
    }

    public SkadiProvider(String cacheDir) {
        super("https://elevation-tiles-prod.s3.amazonaws.com/skadi/", cacheDir.isEmpty() ? "/tmp/srtm" : cacheDir, "GraphHopper SRTMReader", -90, 90, 3601);
    }

    public static void main(String[] args) throws IOException {
        SkadiProvider provider = new SkadiProvider();
        System.out.println(provider.getEle(49.949784, 11.57517));
        System.out.println(provider.getEle(49.968668, 11.575127));
        System.out.println(provider.getEle(49.968682, 11.574842));
        System.out.println(provider.getEle(-22.532854, -65.110474));
        System.out.println(provider.getEle(38.065392, -87.099609));
        System.out.println(provider.getEle(40.0, -105.2277023));
        System.out.println(provider.getEle(39.99999999, -105.2277023));
        System.out.println(provider.getEle(39.9999999, -105.2277023));
        System.out.println(provider.getEle(39.999999, -105.2277023));
        System.out.println(provider.getEle(47.468668, 14.575127));
        System.out.println(provider.getEle(47.467753, 14.573911));
        System.out.println(provider.getEle(46.468835, 12.578777));
        System.out.println(provider.getEle(48.469123, 9.576393));
    }

    @Override
    byte[] readFile(File file) throws IOException {
        int len;
        FileInputStream is = new FileInputStream(file);
        GZIPInputStream gzis = new GZIPInputStream(is);
        BufferedInputStream buff = new BufferedInputStream(gzis);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((len = buff.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.flush();
        Helper.close((Closeable)buff);
        return os.toByteArray();
    }

    private String getLatString(double lat) {
        int minLat = (int)Math.floor(lat);
        return (minLat < 0 ? "S" : "N") + this.getPaddedLatString(minLat);
    }

    private String getLonString(double lon) {
        int minLon = (int)Math.floor(lon);
        return (minLon < 0 ? "W" : "E") + this.getPaddedLonString(minLon);
    }

    @Override
    String getFileName(double lat, double lon) {
        String latStr = this.getLatString(lat);
        String lonStr = this.getLonString(lon);
        return Helper.toLowerCase((String)(latStr + lonStr));
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        String latStr = this.getLatString(lat);
        String lonStr = this.getLonString(lon);
        return latStr + "/" + latStr + lonStr + ".hgt.gz";
    }

    public String toString() {
        return "skadi";
    }
}

