/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.coll.GHLongIntBTree;
import com.graphhopper.coll.LongIntMap;
import com.graphhopper.reader.PillarInfo;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.osm.SegmentNode;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;

class OSMNodeData {
    static final int JUNCTION_NODE = -2;
    static final int EMPTY_NODE = -1;
    static final int END_NODE = 0;
    static final int INTERMEDIATE_NODE = 1;
    static final int CONNECTION_NODE = 2;
    private final LongIntMap idsByOsmNodeIds = new GHLongIntBTree(200);
    private final PillarInfo pillarNodes;
    private final PointAccess towerNodes;
    private final LongIntMap nodeTagIndicesByOsmNodeIds;
    private final List<Map<String, Object>> nodeTags;
    private int nextTowerId = 0;
    private int nextPillarId = 0;
    private long nextArtificialOSMNodeId = -9223372036854775807L;

    public OSMNodeData(PointAccess nodeAccess, Directory directory) {
        this.towerNodes = nodeAccess;
        this.pillarNodes = new PillarInfo(this.towerNodes.is3D(), directory);
        this.nodeTagIndicesByOsmNodeIds = new GHLongIntBTree(200);
        this.nodeTags = new ArrayList<Map<String, Object>>();
    }

    public boolean is3D() {
        return this.towerNodes.is3D();
    }

    public int getId(long osmNodeId) {
        return this.idsByOsmNodeIds.get(osmNodeId);
    }

    public static boolean isTowerNode(int id) {
        return id < -2;
    }

    public static boolean isPillarNode(int id) {
        return id > 2;
    }

    public static boolean isNodeId(int id) {
        return id > 2 || id < -2;
    }

    public void setOrUpdateNodeType(long osmNodeId, int newNodeType, IntUnaryOperator nodeTypeUpdate) {
        int curr = this.idsByOsmNodeIds.get(osmNodeId);
        if (curr == -1) {
            this.idsByOsmNodeIds.put(osmNodeId, newNodeType);
        } else {
            this.idsByOsmNodeIds.put(osmNodeId, nodeTypeUpdate.applyAsInt(curr));
        }
    }

    public long getNodeCount() {
        return this.idsByOsmNodeIds.getSize();
    }

    public long getTaggedNodeCount() {
        return this.nodeTags.size();
    }

    public int addCoordinatesIfMapped(long osmNodeId, double lat, double lon, double ele) {
        int nodeType = this.idsByOsmNodeIds.get(osmNodeId);
        if (nodeType == -1) {
            return nodeType;
        }
        if (nodeType == -2 || nodeType == 2) {
            this.addTowerNode(osmNodeId, lat, lon, ele);
        } else if (nodeType == 1 || nodeType == 0) {
            this.addPillarNode(osmNodeId, lat, lon, ele);
        } else {
            throw new IllegalStateException("Unknown node type: " + nodeType + ", or coordinates already set. Possibly duplicate OSM node ID: " + osmNodeId);
        }
        return nodeType;
    }

    private int addTowerNode(long osmId, double lat, double lon, double ele) {
        this.towerNodes.setNode(this.nextTowerId, lat, lon, ele);
        int id = this.towerNodeToId(this.nextTowerId);
        this.idsByOsmNodeIds.put(osmId, id);
        ++this.nextTowerId;
        return id;
    }

    private int addPillarNode(long osmId, double lat, double lon, double ele) {
        this.pillarNodes.setNode(this.nextPillarId, lat, lon, ele);
        int id = this.pillarNodeToId(this.nextPillarId);
        this.idsByOsmNodeIds.put(osmId, id);
        ++this.nextPillarId;
        return id;
    }

    SegmentNode addCopyOfNode(SegmentNode node) {
        long newOsmId;
        GHPoint3D point = this.getCoordinates(node.id);
        if (point == null) {
            throw new IllegalStateException("Cannot copy node : " + node.osmNodeId + ", because it is missing");
        }
        if (this.idsByOsmNodeIds.put(newOsmId = this.nextArtificialOSMNodeId++, 1) != -1) {
            throw new IllegalStateException("Artificial osm node id already exists: " + newOsmId);
        }
        int id = this.addPillarNode(newOsmId, point.getLat(), point.getLon(), point.getEle());
        return new SegmentNode(newOsmId, id);
    }

    int convertPillarToTowerNode(int id, long osmNodeId) {
        if (!OSMNodeData.isPillarNode(id)) {
            throw new IllegalArgumentException("Not a pillar node: " + id);
        }
        int pillar = this.idToPillarNode(id);
        double lat = this.pillarNodes.getLat(pillar);
        double lon = this.pillarNodes.getLon(pillar);
        double ele = this.pillarNodes.getEle(pillar);
        if (lat == Double.MAX_VALUE || lon == Double.MAX_VALUE) {
            throw new IllegalStateException("Pillar node was already converted to tower node: " + id);
        }
        this.pillarNodes.setNode(pillar, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        return this.addTowerNode(osmNodeId, lat, lon, ele);
    }

    public GHPoint3D getCoordinates(int id) {
        if (OSMNodeData.isTowerNode(id)) {
            int tower = this.idToTowerNode(id);
            return this.towerNodes.is3D() ? new GHPoint3D(this.towerNodes.getLat(tower), this.towerNodes.getLon(tower), this.towerNodes.getEle(tower)) : new GHPoint3D(this.towerNodes.getLat(tower), this.towerNodes.getLon(tower), Double.NaN);
        }
        if (OSMNodeData.isPillarNode(id)) {
            int pillar = this.idToPillarNode(id);
            return this.pillarNodes.is3D() ? new GHPoint3D(this.pillarNodes.getLat(pillar), this.pillarNodes.getLon(pillar), this.pillarNodes.getEle(pillar)) : new GHPoint3D(this.pillarNodes.getLat(pillar), this.pillarNodes.getLon(pillar), Double.NaN);
        }
        return null;
    }

    public void addCoordinatesToPointList(int id, PointList pointList) {
        double lon;
        double lat;
        double ele = Double.NaN;
        if (OSMNodeData.isTowerNode(id)) {
            int tower = this.idToTowerNode(id);
            lat = this.towerNodes.getLat(tower);
            lon = this.towerNodes.getLon(tower);
            if (this.towerNodes.is3D()) {
                ele = this.towerNodes.getEle(tower);
            }
        } else if (OSMNodeData.isPillarNode(id)) {
            int pillar = this.idToPillarNode(id);
            lat = this.pillarNodes.getLat(pillar);
            lon = this.pillarNodes.getLon(pillar);
            if (this.pillarNodes.is3D()) {
                ele = this.pillarNodes.getEle(pillar);
            }
        } else {
            throw new IllegalArgumentException();
        }
        pointList.add(lat, lon, ele);
    }

    public void setTags(ReaderNode node) {
        int tagIndex = this.nodeTagIndicesByOsmNodeIds.get(node.getId());
        if (tagIndex == -2) {
            throw new IllegalStateException("Cannot add tags after they were removed");
        }
        if (tagIndex != -1) {
            throw new IllegalStateException("Cannot add tags twice, duplicate node OSM ID: " + node.getId());
        }
        this.nodeTagIndicesByOsmNodeIds.put(node.getId(), this.nodeTags.size());
        this.nodeTags.add(node.getTags());
    }

    public Map<String, Object> getTags(long osmNodeId) {
        int tagIndex = this.nodeTagIndicesByOsmNodeIds.get(osmNodeId);
        if (tagIndex < 0) {
            return Collections.emptyMap();
        }
        return this.nodeTags.get(tagIndex);
    }

    public void removeTags(long osmNodeId) {
        int prev = this.nodeTagIndicesByOsmNodeIds.put(osmNodeId, -2);
        this.nodeTags.set(prev, Collections.emptyMap());
    }

    public void release() {
        this.pillarNodes.clear();
    }

    public int towerNodeToId(int towerId) {
        return -towerId - 3;
    }

    public int idToTowerNode(int id) {
        return -id - 3;
    }

    public int pillarNodeToId(int pillarId) {
        return pillarId + 3;
    }

    public int idToPillarNode(int id) {
        return id - 3;
    }
}

