/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.LongArrayList;
import com.graphhopper.coll.GHIntLongHashMap;
import com.graphhopper.coll.GHLongHashSet;
import com.graphhopper.coll.GHLongLongHashMap;
import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.EdgeSampling;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GraphElevationSmoothing;
import com.graphhopper.reader.osm.OSMReaderUtility;
import com.graphhopper.reader.osm.WaySegmentParser;
import com.graphhopper.routing.OSMReaderConfig;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.LongToIntFunction;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMReader.class);
    private static final Pattern WAY_NAME_PATTERN = Pattern.compile("; *");
    private final OSMReaderConfig config;
    private final GraphHopperStorage ghStorage;
    private final NodeAccess nodeAccess;
    private final TurnCostStorage turnCostStorage;
    private final EncodingManager encodingManager;
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private AreaIndex<CustomArea> areaIndex;
    private CountryRuleFactory countryRuleFactory = null;
    private File osmFile;
    private final DouglasPeucker simplifyAlgo = new DouglasPeucker();
    private final IntsRef tempRelFlags;
    private Date osmDataDate;
    private long zeroCounter = 0L;
    private GHLongLongHashMap osmWayIdToRelationFlagsMap = new GHLongLongHashMap(200, 0.5);
    private GHLongHashSet osmWayIdSet = new GHLongHashSet();
    private IntLongMap edgeIdToOsmWayIdMap;

    public OSMReader(GraphHopperStorage ghStorage, OSMReaderConfig config) {
        this.ghStorage = ghStorage;
        this.config = config;
        this.nodeAccess = ghStorage.getNodeAccess();
        this.encodingManager = ghStorage.getEncodingManager();
        this.simplifyAlgo.setMaxDistance(config.getMaxWayPointDistance());
        this.simplifyAlgo.setElevationMaxDistance(config.getElevationMaxWayPointDistance());
        this.turnCostStorage = ghStorage.getTurnCostStorage();
        this.tempRelFlags = this.encodingManager.createRelationFlags();
        if (this.tempRelFlags.length != 2) {
            throw new IllegalArgumentException("Cannot use relation flags with != 2 integers");
        }
    }

    public OSMReader setFile(File osmFile) {
        this.osmFile = osmFile;
        return this;
    }

    public OSMReader setAreaIndex(AreaIndex<CustomArea> areaIndex) {
        this.areaIndex = areaIndex;
        return this;
    }

    public OSMReader setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null) {
            throw new IllegalStateException("Use the NOOP elevation provider instead of null or don't call setElevationProvider");
        }
        if (!this.nodeAccess.is3D() && ElevationProvider.NOOP != eleProvider) {
            throw new IllegalStateException("Make sure you graph accepts 3D data");
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public OSMReader setCountryRuleFactory(CountryRuleFactory countryRuleFactory) {
        this.countryRuleFactory = countryRuleFactory;
        return this;
    }

    public void readGraph() throws IOException {
        if (this.encodingManager == null) {
            throw new IllegalStateException("Encoding manager was not set.");
        }
        if (this.osmFile == null) {
            throw new IllegalStateException("No OSM file specified");
        }
        if (!this.osmFile.exists()) {
            throw new IllegalStateException("Your specified OSM file does not exist:" + this.osmFile.getAbsolutePath());
        }
        WaySegmentParser waySegmentParser = new WaySegmentParser.Builder(this.ghStorage.getNodeAccess()).setDirectory(this.ghStorage.getDirectory()).setElevationProvider(this.eleProvider).setWayFilter(this::acceptWay).setSplitNodeFilter(this::isBarrierNode).setWayPreprocessor(this::preprocessWay).setRelationPreprocessor(this::preprocessRelations).setRelationProcessor(this::processRelation).setEdgeHandler(this::addEdge).setWorkerThreads(this.config.getWorkerThreads()).build();
        this.ghStorage.create(100L);
        waySegmentParser.readOSM(this.osmFile);
        this.osmDataDate = waySegmentParser.getTimeStamp();
        if (this.ghStorage.getNodes() == 0) {
            throw new RuntimeException("Graph after reading OSM must not be empty");
        }
        LOGGER.info("Finished reading OSM file: {}, nodes: {}, edges: {}, zero distance edges: {}", new Object[]{this.osmFile.getAbsolutePath(), Helper.nf((long)this.ghStorage.getNodes()), Helper.nf((long)this.ghStorage.getEdges()), Helper.nf((long)this.zeroCounter)});
        this.finishedReading();
    }

    public Date getDataDate() {
        return this.osmDataDate;
    }

    protected boolean acceptWay(ReaderWay way) {
        if (way.getNodes().size() < 2) {
            return false;
        }
        if (!way.hasTags()) {
            return false;
        }
        return this.encodingManager.acceptWay(way);
    }

    protected boolean isBarrierNode(ReaderNode node) {
        return node.getTags().containsKey("barrier") || node.getTags().containsKey("ford");
    }

    protected boolean isCalculateWayDistance(ReaderWay way) {
        return this.isFerry(way);
    }

    private boolean isFerry(ReaderWay way) {
        return way.hasTag("route", "ferry", "shuttle_train");
    }

    protected void setArtificialWayTags(PointList pointList, ReaderWay way, double distance, Map<String, Object> nodeTags) {
        CountryRule countryRule;
        List<Object> customAreas;
        way.setTag("node_tags", nodeTags);
        way.setTag("edge_distance", distance);
        way.setTag("point_list", pointList);
        way.removeTag("country");
        way.removeTag("country_rule");
        way.removeTag("custom_areas");
        if (this.areaIndex != null) {
            double middleLon;
            double middleLat;
            if (pointList.size() > 2) {
                middleLat = pointList.getLat(pointList.size() / 2);
                middleLon = pointList.getLon(pointList.size() / 2);
            } else {
                double firstLat = pointList.getLat(0);
                double firstLon = pointList.getLon(0);
                double lastLat = pointList.getLat(pointList.size() - 1);
                double lastLon = pointList.getLon(pointList.size() - 1);
                middleLat = (firstLat + lastLat) / 2.0;
                middleLon = (firstLon + lastLon) / 2.0;
            }
            customAreas = this.areaIndex.query(middleLat, middleLon);
        } else {
            customAreas = Collections.emptyList();
        }
        Country country = Country.MISSING;
        for (CustomArea customArea : customAreas) {
            Object countryCode = customArea.getProperties().get("ISO3166-1:alpha3");
            if (countryCode == null) continue;
            if (country != Country.MISSING) {
                LOGGER.warn("Multiple countries found for way {}: {}, {}", new Object[]{way.getId(), country, countryCode});
            }
            country = Country.valueOf(countryCode.toString());
        }
        way.setTag("country", (Object)country);
        if (this.countryRuleFactory != null && (countryRule = this.countryRuleFactory.getCountryRule(country)) != null) {
            way.setTag("country_rule", countryRule);
        }
        way.setTag("custom_areas", customAreas);
    }

    protected void addEdge(int fromIndex, int toIndex, PointList pointList, ReaderWay way, Map<String, Object> nodeTags) {
        double distance;
        if (fromIndex < 0 || toIndex < 0) {
            throw new AssertionError((Object)("to or from index is invalid for this edge " + fromIndex + "->" + toIndex + ", points:" + pointList));
        }
        if (pointList.getDimension() != this.nodeAccess.getDimension()) {
            throw new AssertionError((Object)("Dimension does not match for pointList vs. nodeAccess " + pointList.getDimension() + " <-> " + this.nodeAccess.getDimension()));
        }
        if (this.config.isSmoothElevation()) {
            GraphElevationSmoothing.smoothElevation(pointList);
        }
        if (this.config.getLongEdgeSamplingDistance() < Double.MAX_VALUE && pointList.is3D()) {
            pointList = EdgeSampling.sample(pointList, this.config.getLongEdgeSamplingDistance(), this.distCalc, this.eleProvider);
        }
        if (this.config.getMaxWayPointDistance() > 0.0 && pointList.size() > 2) {
            this.simplifyAlgo.simplify(pointList);
        }
        if ((distance = this.distCalc.calcDistance(pointList)) < 0.001) {
            ++this.zeroCounter;
            distance = 0.001;
        }
        double maxDistance = 2147483.646;
        if (Double.isNaN(distance)) {
            LOGGER.warn("Bug in OSM or GraphHopper. Illegal tower node distance " + distance + " reset to 1m, osm way " + way.getId());
            distance = 1.0;
        }
        if (Double.isInfinite(distance) || distance > maxDistance) {
            LOGGER.warn("Bug in OSM or GraphHopper. Too big tower node distance " + distance + " reset to large value, osm way " + way.getId());
            distance = maxDistance;
        }
        this.setArtificialWayTags(pointList, way, distance, nodeTags);
        IntsRef relationFlags = this.getRelFlagsMap(way.getId());
        IntsRef edgeFlags = this.encodingManager.handleWayTags(way, relationFlags);
        if (edgeFlags.isEmpty()) {
            return;
        }
        String name = way.getTag("way_name", "");
        EdgeIteratorState edge = this.ghStorage.edge(fromIndex, toIndex).setDistance(distance).setFlags(edgeFlags).setName(name);
        if (pointList.size() > 2) {
            this.checkCoordinates(fromIndex, (GHPoint)pointList.get(0));
            this.checkCoordinates(toIndex, (GHPoint)pointList.get(pointList.size() - 1));
            edge.setWayGeometry(pointList.shallowCopy(1, pointList.size() - 1, false));
        }
        this.encodingManager.applyWayTags(way, edge);
        this.checkDistance(edge);
        if (this.osmWayIdSet.contains(way.getId())) {
            this.getEdgeIdToOsmWayIdMap().put(edge.getEdge(), way.getId());
        }
    }

    private void checkCoordinates(int nodeIndex, GHPoint point) {
        double tolerance = 1.0E-6;
        if (Math.abs(this.nodeAccess.getLat(nodeIndex) - point.getLat()) > 1.0E-6 || Math.abs(this.nodeAccess.getLon(nodeIndex) - point.getLon()) > 1.0E-6) {
            throw new IllegalStateException("Suspicious coordinates for node " + nodeIndex + ": (" + this.nodeAccess.getLat(nodeIndex) + "," + this.nodeAccess.getLon(nodeIndex) + ") vs. (" + point + ")");
        }
    }

    private void checkDistance(EdgeIteratorState edge) {
        double tolerance = 1.0;
        double edgeDistance = edge.getDistance();
        double geometryDistance = this.distCalc.calcDistance(edge.fetchWayGeometry(FetchMode.ALL));
        if (Double.isInfinite(edgeDistance)) {
            throw new IllegalStateException("Infinite edge distance should never occur, as we are supposed to limit each distance to the maximum distance we can store, #435");
        }
        if (edgeDistance > 2000000.0) {
            LOGGER.warn("Very long edge detected: " + edge + " dist: " + edgeDistance);
        } else if (Math.abs(edgeDistance - geometryDistance) > 1.0) {
            throw new IllegalStateException("Suspicious distance for edge: " + edge + " " + edgeDistance + " vs. " + geometryDistance + ", difference: " + (edgeDistance - geometryDistance));
        }
    }

    protected void preprocessWay(ReaderWay way, WaySegmentParser.CoordinateSupplier coordinateSupplier) {
        long durationInSeconds;
        if (this.config.isParseWayNames()) {
            String refName;
            String name = "";
            if (!this.config.getPreferredLanguage().isEmpty()) {
                name = OSMReader.fixWayName(way.getTag("name:" + this.config.getPreferredLanguage()));
            }
            if (name.isEmpty()) {
                name = OSMReader.fixWayName(way.getTag("name"));
            }
            if (!(refName = OSMReader.fixWayName(way.getTag("ref"))).isEmpty()) {
                name = name.isEmpty() ? refName : name + ", " + refName;
            }
            way.setTag("way_name", name);
        }
        if (!this.isCalculateWayDistance(way)) {
            return;
        }
        double distance = this.calcDistance(way, coordinateSupplier);
        if (Double.isNaN(distance)) {
            LOGGER.warn("Could not determine distance for OSM way: " + way.getId());
            return;
        }
        way.setTag("way_distance", distance);
        String durationTag = way.getTag("duration");
        if (durationTag == null) {
            if (this.isFerry(way) && distance > 500000.0) {
                LOGGER.warn("Long ferry OSM way without duration tag: " + way.getId() + ", distance: " + Math.round(distance / 1000.0) + " km");
            }
            return;
        }
        try {
            durationInSeconds = OSMReaderUtility.parseDuration(durationTag);
        }
        catch (Exception e) {
            LOGGER.warn("Could not parse duration tag '" + durationTag + "' in OSM way: " + way.getId());
            return;
        }
        double speedInKmPerHour = distance / 1000.0 / ((double)durationInSeconds / 60.0 / 60.0);
        if (speedInKmPerHour < 0.1) {
            LOGGER.warn("Unrealistic low speed calculated from duration. Maybe the duration is too long, or it is applied to a way that only represents a part of the connection? OSM way: " + way.getId() + ". duration=" + durationTag + " (= " + Math.round((double)durationInSeconds / 60.0) + " minutes), distance=" + distance + " m");
            return;
        }
        way.setTag("speed_from_duration", speedInKmPerHour);
        way.setTag("duration:seconds", durationInSeconds);
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return WAY_NAME_PATTERN.matcher(str).replaceAll(", ");
    }

    private double calcDistance(ReaderWay way, WaySegmentParser.CoordinateSupplier coordinateSupplier) {
        LongArrayList nodes = way.getNodes();
        GHPoint3D prevPoint = coordinateSupplier.getCoordinate(nodes.get(0));
        if (prevPoint == null) {
            return Double.NaN;
        }
        boolean is3D = !Double.isNaN(prevPoint.ele);
        double distance = 0.0;
        for (int i = 1; i < nodes.size(); ++i) {
            GHPoint3D point = coordinateSupplier.getCoordinate(nodes.get(i));
            if (point == null) {
                return Double.NaN;
            }
            if (Double.isNaN(point.ele) == is3D) {
                throw new IllegalStateException("There should be elevation data for either all points or no points at all. OSM way: " + way.getId());
            }
            distance += is3D ? this.distCalc.calcDist3D(prevPoint.lat, prevPoint.lon, prevPoint.ele, point.lat, point.lon, point.ele) : this.distCalc.calcDist(prevPoint.lat, prevPoint.lon, point.lat, point.lon);
            prevPoint = point;
        }
        return distance;
    }

    protected void preprocessRelations(ReaderRelation relation) {
        if (!relation.isMetaRelation() && relation.hasTag("type", (Object)"route")) {
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (member.getType() != 1) continue;
                IntsRef oldRelationFlags = this.getRelFlagsMap(member.getRef());
                IntsRef newRelationFlags = this.encodingManager.handleRelationTags(relation, oldRelationFlags);
                this.putRelFlagsMap(member.getRef(), newRelationFlags);
            }
        }
        if (relation.hasTag("type", (Object)"restriction")) {
            List<OSMTurnRelation> turnRelations = OSMReader.createTurnRelations(relation);
            for (OSMTurnRelation turnRelation : turnRelations) {
                this.osmWayIdSet.add(turnRelation.getOsmIdFrom());
                this.osmWayIdSet.add(turnRelation.getOsmIdTo());
            }
        }
    }

    protected void processRelation(ReaderRelation relation, final LongToIntFunction getIdForOSMNodeId) {
        if (this.turnCostStorage != null && relation.hasTag("type", (Object)"restriction")) {
            TurnCostParser.ExternalInternalMap map = new TurnCostParser.ExternalInternalMap(){

                @Override
                public int getInternalNodeIdOfOsmNode(long nodeOsmId) {
                    return getIdForOSMNodeId.applyAsInt(nodeOsmId);
                }

                @Override
                public long getOsmIdOfInternalEdge(int edgeId) {
                    return OSMReader.this.getEdgeIdToOsmWayIdMap().get(edgeId);
                }
            };
            for (OSMTurnRelation turnRelation : OSMReader.createTurnRelations(relation)) {
                int viaNode = map.getInternalNodeIdOfOsmNode(turnRelation.getViaOsmNodeId());
                if (viaNode < 0) continue;
                this.encodingManager.handleTurnRelationTags(turnRelation, map, this.ghStorage);
            }
        }
    }

    private IntLongMap getEdgeIdToOsmWayIdMap() {
        if (this.edgeIdToOsmWayIdMap == null) {
            this.edgeIdToOsmWayIdMap = new GHIntLongHashMap(this.osmWayIdSet.size(), 0.5);
        }
        return this.edgeIdToOsmWayIdMap;
    }

    static List<OSMTurnRelation> createTurnRelations(ReaderRelation relation) {
        String tagExcept;
        ArrayList<OSMTurnRelation> osmTurnRelations = new ArrayList<OSMTurnRelation>();
        String vehicleTypeRestricted = "";
        ArrayList<String> vehicleTypesExcept = new ArrayList<String>();
        if (relation.hasTag("except", new String[0]) && !Helper.isEmpty((String)(tagExcept = relation.getTag("except")))) {
            ArrayList<String> vehicleTypes = new ArrayList<String>(Arrays.asList(tagExcept.split(";")));
            for (String vehicleType : vehicleTypes) {
                vehicleTypesExcept.add(vehicleType.trim());
            }
        }
        if (relation.hasTag("restriction", new String[0])) {
            OSMTurnRelation osmTurnRelation = OSMReader.createTurnRelation(relation, relation.getTag("restriction"), vehicleTypeRestricted, vehicleTypesExcept);
            if (osmTurnRelation != null) {
                osmTurnRelations.add(osmTurnRelation);
            }
            return osmTurnRelations;
        }
        if (relation.hasTagWithKeyPrefix("restriction:")) {
            List<String> vehicleTypesRestricted = relation.getKeysWithPrefix("restriction:");
            for (String vehicleType : vehicleTypesRestricted) {
                String restrictionType = relation.getTag(vehicleType);
                OSMTurnRelation osmTurnRelation = OSMReader.createTurnRelation(relation, restrictionType, vehicleTypeRestricted = vehicleType.replace("restriction:", "").trim(), vehicleTypesExcept);
                if (osmTurnRelation == null) continue;
                osmTurnRelations.add(osmTurnRelation);
            }
        }
        return osmTurnRelations;
    }

    static OSMTurnRelation createTurnRelation(ReaderRelation relation, String restrictionType, String vehicleTypeRestricted, List<String> vehicleTypesExcept) {
        OSMTurnRelation.Type type = OSMTurnRelation.Type.getRestrictionType(restrictionType);
        if (type != OSMTurnRelation.Type.UNSUPPORTED) {
            long fromWayID = -1L;
            long viaNodeID = -1L;
            long toWayID = -1L;
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (1 == member.getType()) {
                    if ("from".equals(member.getRole())) {
                        fromWayID = member.getRef();
                        continue;
                    }
                    if (!"to".equals(member.getRole())) continue;
                    toWayID = member.getRef();
                    continue;
                }
                if (0 != member.getType() || !"via".equals(member.getRole())) continue;
                viaNodeID = member.getRef();
            }
            if (fromWayID >= 0L && toWayID >= 0L && viaNodeID >= 0L) {
                OSMTurnRelation osmTurnRelation = new OSMTurnRelation(fromWayID, viaNodeID, toWayID, type);
                osmTurnRelation.setVehicleTypeRestricted(vehicleTypeRestricted);
                osmTurnRelation.setVehicleTypesExcept(vehicleTypesExcept);
                return osmTurnRelation;
            }
        }
        return null;
    }

    private void finishedReading() {
        this.encodingManager.releaseParsers();
        this.eleProvider.release();
        this.osmWayIdToRelationFlagsMap = null;
        this.osmWayIdSet = null;
        this.edgeIdToOsmWayIdMap = null;
    }

    IntsRef getRelFlagsMap(long osmId) {
        long relFlagsAsLong = this.osmWayIdToRelationFlagsMap.get(osmId);
        this.tempRelFlags.ints[0] = (int)relFlagsAsLong;
        this.tempRelFlags.ints[1] = (int)(relFlagsAsLong >> 32);
        return this.tempRelFlags;
    }

    void putRelFlagsMap(long osmId, IntsRef relFlags) {
        long relFlagsAsLong = (long)relFlags.ints[1] << 32 | (long)relFlags.ints[0] & 0xFFFFFFFFL;
        this.osmWayIdToRelationFlagsMap.put(osmId, relFlagsAsLong);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

