/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.BidirRoutingAlgorithm;
import com.graphhopper.routing.EdgeRestrictions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathCalculator;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import java.util.Collections;
import java.util.List;

public class FlexiblePathCalculator
implements PathCalculator {
    private final QueryGraph queryGraph;
    private final RoutingAlgorithmFactory algoFactory;
    private Weighting weighting;
    private final AlgorithmOptions algoOpts;
    private String debug;
    private int visitedNodes;

    public FlexiblePathCalculator(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, Weighting weighting, AlgorithmOptions algoOpts) {
        this.queryGraph = queryGraph;
        this.algoFactory = algoFactory;
        this.weighting = weighting;
        this.algoOpts = algoOpts;
    }

    @Override
    public List<Path> calcPaths(int from, int to, EdgeRestrictions edgeRestrictions) {
        RoutingAlgorithm algo = this.createAlgo();
        return this.calcPaths(from, to, edgeRestrictions, algo);
    }

    private RoutingAlgorithm createAlgo() {
        StopWatch sw = new StopWatch().start();
        RoutingAlgorithm algo = this.algoFactory.createAlgo(this.queryGraph, this.weighting, this.algoOpts);
        this.debug = ", algoInit:" + sw.stop().getNanos() / 1000L + " \u03bcs";
        return algo;
    }

    private List<Path> calcPaths(int from, int to, EdgeRestrictions edgeRestrictions, RoutingAlgorithm algo) {
        List<Path> paths;
        StopWatch sw = new StopWatch().start();
        for (IntCursor c : edgeRestrictions.getUnfavoredEdges()) {
            this.queryGraph.unfavorVirtualEdge(c.value);
        }
        if (edgeRestrictions.getSourceOutEdge() != -2 || edgeRestrictions.getTargetInEdge() != -2) {
            if (!(algo instanceof BidirRoutingAlgorithm)) {
                throw new IllegalArgumentException("To make use of the curbside parameter you need a bidirectional algorithm, got: " + algo.getName());
            }
            paths = Collections.singletonList(((BidirRoutingAlgorithm)algo).calcPath(from, to, edgeRestrictions.getSourceOutEdge(), edgeRestrictions.getTargetInEdge()));
        } else {
            paths = algo.calcPaths(from, to);
        }
        this.queryGraph.clearUnfavoredStatus();
        if (paths.isEmpty()) {
            throw new IllegalStateException("Path list was empty for " + from + " -> " + to);
        }
        if (algo.getVisitedNodes() >= this.algoOpts.getMaxVisitedNodes()) {
            throw new MaximumNodesExceededException("No path found due to maximum nodes exceeded " + this.algoOpts.getMaxVisitedNodes(), this.algoOpts.getMaxVisitedNodes());
        }
        this.visitedNodes = algo.getVisitedNodes();
        this.debug = this.debug + ", " + algo.getName() + "-routing:" + sw.stop().getMillis() + " ms";
        return paths;
    }

    @Override
    public String getDebugString() {
        return this.debug;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    public void setWeighting(Weighting weighting) {
        this.weighting = weighting;
    }
}

