/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHPreparationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHPreparationHandler.class);
    private final List<CHProfile> chProfiles = new ArrayList<CHProfile>();
    private int preparationThreads;
    private PMap pMap = new PMap();

    public CHPreparationHandler() {
        this.setPreparationThreads(1);
    }

    public void init(GraphHopperConfig ghConfig) {
        if (ghConfig.has("prepare.threads")) {
            throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
        }
        if (ghConfig.has("prepare.chWeighting") || ghConfig.has("prepare.chWeightings") || ghConfig.has("prepare.ch.weightings")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.chWeighting, prepare.chWeightings or prepare.ch.weightings, see #1922 and docs/core/profiles.md");
        }
        if (ghConfig.has("prepare.ch.edge_based")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.ch.edge_based, see #1922 and docs/core/profiles.md");
        }
        this.setPreparationThreads(ghConfig.getInt("prepare.ch.threads", this.getPreparationThreads()));
        this.setCHProfiles(ghConfig.getCHProfiles());
        this.pMap = ghConfig.asPMap();
    }

    public final boolean isEnabled() {
        return !this.chProfiles.isEmpty();
    }

    public CHPreparationHandler setCHProfiles(CHProfile ... chProfiles) {
        this.setCHProfiles(Arrays.asList(chProfiles));
        return this;
    }

    public CHPreparationHandler setCHProfiles(Collection<CHProfile> chProfiles) {
        this.chProfiles.clear();
        this.chProfiles.addAll(chProfiles);
        return this;
    }

    public List<CHProfile> getCHProfiles() {
        return this.chProfiles;
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
    }

    public Map<String, RoutingCHGraph> load(GraphHopperStorage ghStorage, List<CHConfig> chConfigs) {
        Map<String, RoutingCHGraph> loaded = Collections.synchronizedMap(new LinkedHashMap());
        List<Callable<String>> callables = chConfigs.stream().map(c -> () -> {
            CHStorage chStorage = ghStorage.loadCHStorage(c.getName(), c.isEdgeBased());
            if (chStorage != null) {
                loaded.put(c.getName(), ghStorage.createCHGraph(chStorage, (CHConfig)c));
            } else {
                ghStorage.getDirectory().remove("nodes_ch_" + c.getName());
                ghStorage.getDirectory().remove("shortcuts_" + c.getName());
            }
            return c.getName();
        }).collect(Collectors.toList());
        GHUtility.runConcurrently(callables, this.preparationThreads);
        return loaded;
    }

    public Map<String, PrepareContractionHierarchies.Result> prepare(GraphHopperStorage ghStorage, List<CHConfig> chConfigs, boolean closeEarly) {
        if (chConfigs.isEmpty()) {
            LOGGER.info("There are no CHs to prepare");
            return Collections.emptyMap();
        }
        LOGGER.info("Creating CH preparations, {}", (Object)Helper.getMemInfo());
        List preparations = chConfigs.stream().map(c -> this.createCHPreparation(ghStorage, (CHConfig)c)).collect(Collectors.toList());
        Map<String, PrepareContractionHierarchies.Result> results = Collections.synchronizedMap(new LinkedHashMap());
        ArrayList<Callable<String>> callables = new ArrayList<Callable<String>>(preparations.size());
        for (int i = 0; i < preparations.size(); ++i) {
            PrepareContractionHierarchies prepare = (PrepareContractionHierarchies)preparations.get(i);
            LOGGER.info(i + 1 + "/" + preparations.size() + " calling CH prepare.doWork for profile '" + prepare.getCHConfig().getName() + "' " + (Object)((Object)prepare.getCHConfig().getTraversalMode()) + " ... (" + Helper.getMemInfo() + ")");
            callables.add(() -> {
                String name = prepare.getCHConfig().getName();
                Thread.currentThread().setName(name);
                PrepareContractionHierarchies.Result result = prepare.doWork();
                results.put(name, result);
                prepare.flush();
                if (closeEarly) {
                    prepare.close();
                }
                ghStorage.getProperties().put("prepare.ch.date." + name, Helper.createFormatter().format(new Date()));
                return name;
            });
        }
        GHUtility.runConcurrently(callables, this.preparationThreads);
        LOGGER.info("Finished CH preparation, {}", (Object)Helper.getMemInfo());
        return results;
    }

    private PrepareContractionHierarchies createCHPreparation(GraphHopperStorage ghStorage, CHConfig chConfig) {
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraphHopperStorage(ghStorage, chConfig);
        pch.setParams(this.pMap);
        return pch;
    }
}

