/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.storage.IntsRef;

public final class DecimalEncodedValueImpl
extends IntEncodedValueImpl
implements DecimalEncodedValue {
    private final double factor;
    private final boolean defaultIsInfinity;
    private final boolean useMaximumAsInfinity;

    public DecimalEncodedValueImpl(String name, int bits, double factor, boolean storeTwoDirections) {
        this(name, bits, factor, false, storeTwoDirections);
    }

    public DecimalEncodedValueImpl(String name, int bits, double factor, boolean defaultIsInfinity, boolean storeTwoDirections) {
        this(name, bits, 0.0, factor, defaultIsInfinity, false, storeTwoDirections, false);
    }

    public DecimalEncodedValueImpl(String name, int bits, double minValue, double factor, boolean defaultIsInfinity, boolean negateReverseDirection, boolean storeTwoDirections, boolean useMaximumAsInfinity) {
        super(name, bits, (int)Math.round(minValue / factor), negateReverseDirection, storeTwoDirections);
        if (!negateReverseDirection && (double)this.minValue * factor != minValue) {
            throw new IllegalArgumentException("minValue " + minValue + " is not a multiple of the specified factor " + factor);
        }
        this.factor = factor;
        this.defaultIsInfinity = defaultIsInfinity;
        this.useMaximumAsInfinity = useMaximumAsInfinity;
        if (useMaximumAsInfinity && defaultIsInfinity) {
            throw new IllegalArgumentException("defaultIsInfinity and useMaximumAsInfinity cannot be both true");
        }
        if (defaultIsInfinity && minValue < 0.0) {
            throw new IllegalArgumentException("defaultIsInfinity cannot be true when minValue is negative");
        }
    }

    @Override
    public void setDecimal(boolean reverse, IntsRef ref, double value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Call init before usage for EncodedValue " + this.toString());
        }
        if (Double.isInfinite(value)) {
            if (this.useMaximumAsInfinity) {
                super.setInt(reverse, ref, this.maxValue);
                return;
            }
            if (this.defaultIsInfinity) {
                super.setInt(reverse, ref, 0);
                return;
            }
            throw new IllegalArgumentException("Value cannot be infinite if useMaximumAsInfinity is false");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN value for " + this.getName() + " not allowed!");
        }
        if ((value /= this.factor) > (double)this.maxValue) {
            throw new IllegalArgumentException(this.getName() + " value too large for encoding: " + value + ", maxValue:" + this.maxValue + ", factor: " + this.factor);
        }
        if (value < (double)this.minValue) {
            throw new IllegalArgumentException(this.getName() + " value too small for encoding " + value + ", minValue:" + this.minValue + ", factor: " + this.factor);
        }
        super.uncheckedSet(reverse, ref, (int)Math.round(value));
    }

    @Override
    public double getDecimal(boolean reverse, IntsRef ref) {
        int value = this.getInt(reverse, ref);
        if (this.useMaximumAsInfinity && value == this.maxValue || this.defaultIsInfinity && value == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)value * this.factor;
    }

    @Override
    public double getNextStorableValue(double value) {
        if (!this.useMaximumAsInfinity && value > this.getMaxDecimal()) {
            throw new IllegalArgumentException(this.getName() + ": There is no next storable value for " + value + ". max:" + this.getMaxDecimal());
        }
        if (this.useMaximumAsInfinity && value > this.getMaxDecimal()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.factor * (double)((int)Math.ceil(value / this.factor));
    }

    @Override
    public double getMaxDecimal() {
        return (double)this.maxValue * this.factor;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        DecimalEncodedValueImpl that = (DecimalEncodedValueImpl)o;
        return Double.compare(that.factor, this.factor) == 0 && this.useMaximumAsInfinity == that.useMaximumAsInfinity && this.defaultIsInfinity == that.defaultIsInfinity;
    }

    @Override
    public int getVersion() {
        int version = 31 * super.getVersion() + DecimalEncodedValueImpl.staticHashCode(this.factor);
        if (this.useMaximumAsInfinity) {
            return 31 * version + 13;
        }
        if (this.defaultIsInfinity) {
            return 31 * version + 17;
        }
        return version;
    }
}

