/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.Collection;
import java.util.Objects;

public class IntEncodedValueImpl
implements IntEncodedValue {
    private final String name;
    private int fwdDataIndex;
    private int bwdDataIndex;
    private final boolean storeTwoDirections;
    final int bits;
    final boolean negateReverseDirection;
    final int minValue;
    final int maxValue;
    int fwdShift = -1;
    int bwdShift = -1;
    int fwdMask;
    int bwdMask;

    public IntEncodedValueImpl(String name, int bits, boolean storeTwoDirections) {
        this(name, bits, 0, false, storeTwoDirections);
    }

    public IntEncodedValueImpl(String name, int bits, int minValue, boolean negateReverseDirection, boolean storeTwoDirections) {
        if (!EncodingManager.isValidEncodedValue(name)) {
            throw new IllegalArgumentException("EncodedValue name wasn't valid: " + name + ". Use lower case letters, underscore and numbers only.");
        }
        if (bits <= 0) {
            throw new IllegalArgumentException(name + ": bits cannot be zero or negative");
        }
        if (bits > 31) {
            throw new IllegalArgumentException(name + ": at the moment the number of reserved bits cannot be more than 31");
        }
        if (negateReverseDirection && (minValue != 0 || storeTwoDirections)) {
            throw new IllegalArgumentException(name + ": negating value for reverse direction only works for minValue == 0 and !storeTwoDirections but was minValue=" + minValue + ", storeTwoDirections=" + storeTwoDirections);
        }
        this.name = name;
        this.storeTwoDirections = storeTwoDirections;
        int max = (1 << bits) - 1;
        this.minValue = negateReverseDirection ? -max : minValue;
        this.maxValue = max + minValue;
        this.bits = negateReverseDirection ? bits + 1 : bits;
        this.negateReverseDirection = negateReverseDirection;
    }

    @Override
    public final int init(EncodedValue.InitializerConfig init) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call init multiple times");
        }
        init.next(this.bits);
        this.fwdMask = init.bitMask;
        this.fwdDataIndex = init.dataIndex;
        this.fwdShift = init.shift;
        if (this.storeTwoDirections) {
            init.next(this.bits);
            this.bwdMask = init.bitMask;
            this.bwdDataIndex = init.dataIndex;
            this.bwdShift = init.shift;
        }
        return this.storeTwoDirections ? 2 * this.bits : this.bits;
    }

    boolean isInitialized() {
        return this.fwdMask != 0;
    }

    @Override
    public final void setInt(boolean reverse, IntsRef ref, int value) {
        this.checkValue(value);
        this.uncheckedSet(reverse, ref, value);
    }

    private void checkValue(int value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("EncodedValue " + this.getName() + " not initialized");
        }
        if (value > this.maxValue) {
            throw new IllegalArgumentException(this.name + " value too large for encoding: " + value + ", maxValue:" + this.maxValue);
        }
        if (value < this.minValue) {
            throw new IllegalArgumentException(this.name + " value too small for encoding " + value + ", minValue:" + this.minValue);
        }
    }

    final void uncheckedSet(boolean reverse, IntsRef ref, int value) {
        if (this.negateReverseDirection) {
            if (reverse) {
                reverse = false;
                value = -value;
            }
        } else if (reverse && !this.storeTwoDirections) {
            throw new IllegalArgumentException(this.getName() + ": value for reverse direction would overwrite forward direction. Enable storeTwoDirections for this EncodedValue or don't use setReverse");
        }
        value -= this.minValue;
        if (reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            ref.ints[this.bwdDataIndex + ref.offset] = (flags &= ~this.bwdMask) | value << this.bwdShift;
        } else {
            int flags = ref.ints[this.fwdDataIndex + ref.offset];
            ref.ints[this.fwdDataIndex + ref.offset] = (flags &= ~this.fwdMask) | value << this.fwdShift;
        }
    }

    @Override
    public final int getInt(boolean reverse, IntsRef ref) {
        if (this.storeTwoDirections && reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            return this.minValue + (flags & this.bwdMask) >>> this.bwdShift;
        }
        int flags = ref.ints[this.fwdDataIndex + ref.offset];
        if (this.negateReverseDirection && reverse) {
            return -(this.minValue + (flags & this.fwdMask) >>> this.fwdShift);
        }
        return this.minValue + (flags & this.fwdMask) >>> this.fwdShift;
    }

    @Override
    public int getMaxInt() {
        return this.maxValue;
    }

    @Override
    public final boolean isStoreTwoDirections() {
        return this.storeTwoDirections;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName() + "|version=" + this.getVersion() + "|bits=" + this.bits + "|min_value=" + this.minValue + "|negate_reverse_direction" + this.negateReverseDirection + "|index=" + this.fwdDataIndex + "|shift=" + this.fwdShift + "|store_both_directions=" + this.storeTwoDirections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntEncodedValueImpl that = (IntEncodedValueImpl)o;
        return this.fwdDataIndex == that.fwdDataIndex && this.bwdDataIndex == that.bwdDataIndex && this.bits == that.bits && this.maxValue == that.maxValue && this.minValue == that.minValue && this.fwdShift == that.fwdShift && this.bwdShift == that.bwdShift && this.fwdMask == that.fwdMask && this.bwdMask == that.bwdMask && this.negateReverseDirection == that.negateReverseDirection && this.storeTwoDirections == that.storeTwoDirections && Objects.equals(this.name, that.name);
    }

    public final int hashCode() {
        return this.getVersion();
    }

    @Override
    public int getVersion() {
        int val = Helper.staticHashCode((String)this.name);
        val = 31 * val + (this.storeTwoDirections ? 1231 : 1237);
        val = 31 * val + (this.negateReverseDirection ? 13 : 17);
        return IntEncodedValueImpl.staticHashCode(val, this.fwdDataIndex, this.bwdDataIndex, this.bits, this.minValue, this.maxValue, this.fwdShift, this.bwdShift, this.fwdMask, this.bwdMask);
    }

    static int staticHashCode(int ... vals) {
        if (vals == null) {
            return 0;
        }
        int len = vals.length;
        int val = 1;
        for (int idx = 0; idx < len; ++idx) {
            val = 31 * val + vals[idx];
        }
        return val;
    }

    static int staticHashCode(Enum<?> ... vals) {
        if (vals == null) {
            return 0;
        }
        int len = vals.length;
        int val = 1;
        for (int idx = 0; idx < len; ++idx) {
            val = 31 * val + vals[idx].ordinal();
        }
        return val;
    }

    static int staticHashCode(Collection<String> vals) {
        if (vals == null) {
            return 0;
        }
        int val = 1;
        for (String str : vals) {
            val = 31 * val + Helper.staticHashCode((String)str);
        }
        return val;
    }

    static int staticHashCode(double val) {
        long var2 = Double.doubleToLongBits(val);
        return (int)(var2 ^ var2 >>> 32);
    }
}

