/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.storage.IntsRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class StringEncodedValue
extends IntEncodedValueImpl {
    private final int maxValues;
    private final List<String> values;
    private final ObjectIntMap<String> indexMap;

    public StringEncodedValue(String name, int expectedValueCount) {
        this(name, expectedValueCount, false);
    }

    public StringEncodedValue(String name, int expectedValueCount, boolean storeTwoDirections) {
        super(name, 32 - Integer.numberOfLeadingZeros(expectedValueCount), storeTwoDirections);
        this.maxValues = StringEncodedValue.roundUp(expectedValueCount);
        this.values = new ArrayList<String>(this.maxValues);
        this.indexMap = new ObjectIntHashMap(this.maxValues);
    }

    public StringEncodedValue(String name, int bits, List<String> values, boolean storeTwoDirections) {
        super(name, bits, storeTwoDirections);
        this.maxValues = (1 << bits) - 1;
        if (values.size() > this.maxValues) {
            throw new IllegalArgumentException("Number of values is higher than the maximum value count: " + values.size() + " > " + this.maxValues);
        }
        this.values = new ArrayList<String>(values);
        this.indexMap = new ObjectIntHashMap(values.size());
        int index = 1;
        for (String value : values) {
            this.indexMap.put((Object)value, index++);
        }
    }

    public final void setString(boolean reverse, IntsRef ref, String value) {
        if (value == null) {
            super.setInt(reverse, ref, 0);
            return;
        }
        int index = this.indexMap.get((Object)value);
        if (index == 0) {
            if (this.values.size() == this.maxValues) {
                throw new IllegalStateException("Maximum number of values reached for " + this.getName() + ": " + this.maxValues);
            }
            this.values.add(value);
            index = this.values.size();
            this.indexMap.put((Object)value, index);
        }
        super.setInt(reverse, ref, index);
    }

    public final String getString(boolean reverse, IntsRef ref) {
        int value = super.getInt(reverse, ref);
        if (value == 0) {
            return null;
        }
        return this.values.get(value - 1);
    }

    private static int roundUp(int value) {
        return -1 >>> Integer.numberOfLeadingZeros(value);
    }

    public int indexOf(String value) {
        return this.indexMap.get((Object)value);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringEncodedValue)) {
            return false;
        }
        StringEncodedValue other = (StringEncodedValue)obj;
        if (this.bits != other.bits) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }

    @Override
    public int getVersion() {
        return 31 * super.getVersion() + StringEncodedValue.staticHashCode(this.values);
    }
}

