/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.MapEntry;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.SplitArea;
import com.graphhopper.routing.subnetwork.SubnetworkStorage;
import com.graphhopper.routing.subnetwork.TarjanSCC;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkStorage {
    private static final int SHORT_INFINITY = 65535;
    private static final int SHORT_MAX = 65534;
    private static final Logger LOGGER = LoggerFactory.getLogger(LandmarkStorage.class);
    private static final int UNSET_SUBNETWORK = -1;
    private static final int UNCLEAR_SUBNETWORK = 0;
    private long LM_ROW_LENGTH;
    private int landmarks;
    private final int FROM_OFFSET;
    private final int TO_OFFSET;
    private final DataAccess landmarkWeightDA;
    private final List<int[]> landmarkIDs;
    private double factor = -1.0;
    private static final double DOUBLE_MLTPL = 1000000.0;
    private final GraphHopperStorage graph;
    private final NodeAccess na;
    private final FlagEncoder encoder;
    private final Weighting weighting;
    private final LMConfig lmConfig;
    private Weighting lmSelectionWeighting;
    private final TraversalMode traversalMode;
    private boolean initialized;
    private int minimumNodes;
    private final SubnetworkStorage subnetworkStorage;
    private List<LandmarkSuggestion> landmarkSuggestions = Collections.emptyList();
    private AreaIndex<SplitArea> areaIndex;
    private boolean logDetails = false;
    static final long PRECISION = 65536L;
    static final Comparator<Map.Entry<Integer, Integer>> SORT_BY_WEIGHT = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
            return Integer.compare(o2.getKey(), o1.getKey());
        }
    };

    public LandmarkStorage(GraphHopperStorage graph, Directory dir, LMConfig lmConfig, int landmarks) {
        this.graph = graph;
        this.na = graph.getNodeAccess();
        this.minimumNodes = Math.min(graph.getNodes() / 2, 500000);
        this.lmConfig = lmConfig;
        this.weighting = lmConfig.getWeighting();
        if (this.weighting.hasTurnCosts()) {
            throw new IllegalArgumentException("Landmark preparation cannot be used with weightings returning turn costs, because this can lead to wrong results during the (node-based) landmark calculation, see #1960");
        }
        this.encoder = this.weighting.getFlagEncoder();
        this.lmSelectionWeighting = new ShortestWeighting(this.encoder){

            @Override
            public double calcEdgeWeight(EdgeIteratorState edge, boolean reverse) {
                double res = LandmarkStorage.this.weighting.calcEdgeWeight(edge, reverse);
                if (res >= Double.MAX_VALUE) {
                    return Double.POSITIVE_INFINITY;
                }
                return 1.0;
            }

            @Override
            public String toString() {
                return "LM_BFS|" + LandmarkStorage.this.encoder;
            }
        };
        this.traversalMode = TraversalMode.NODE_BASED;
        this.landmarkWeightDA = dir.create("landmarks_" + lmConfig.getName());
        this.landmarks = landmarks;
        this.LM_ROW_LENGTH = landmarks * 4;
        this.FROM_OFFSET = 0;
        this.TO_OFFSET = 2;
        this.landmarkIDs = new ArrayList<int[]>();
        this.subnetworkStorage = new SubnetworkStorage(dir.create("landmarks_subnetwork_" + lmConfig.getName()));
    }

    public LandmarkStorage setMaximumWeight(double maxWeight) {
        if (maxWeight > 0.0) {
            this.factor = maxWeight / 65536.0;
            if (Double.isInfinite(this.factor) || Double.isNaN(this.factor)) {
                throw new IllegalStateException("Illegal factor " + this.factor + " calculated from maximum weight " + maxWeight);
            }
        }
        return this;
    }

    public void setLogDetails(boolean logDetails) {
        this.logDetails = logDetails;
    }

    public LandmarkStorage setLandmarkSuggestions(List<LandmarkSuggestion> landmarkSuggestions) {
        if (landmarkSuggestions == null) {
            throw new IllegalArgumentException("landmark suggestions cannot be null");
        }
        this.landmarkSuggestions = landmarkSuggestions;
        return this;
    }

    public void setMinimumNodes(int minimumNodes) {
        this.minimumNodes = minimumNodes;
    }

    public int getMinimumNodes() {
        return this.minimumNodes;
    }

    public void setLMSelectionWeighting(Weighting lmSelectionWeighting) {
        this.lmSelectionWeighting = lmSelectionWeighting;
    }

    public Weighting getLmSelectionWeighting() {
        return this.lmSelectionWeighting;
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    public LMConfig getLMConfig() {
        return this.lmConfig;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void createLandmarks() {
        IntHashSet blockedEdges;
        if (this.isInitialized()) {
            throw new IllegalStateException("Initialize the landmark storage only once!");
        }
        long maxBytes = (long)this.graph.getNodes() * this.LM_ROW_LENGTH;
        this.landmarkWeightDA.create(2000L);
        this.landmarkWeightDA.ensureCapacity(maxBytes);
        for (long pointer = 0L; pointer < maxBytes; pointer += 2L) {
            this.landmarkWeightDA.setShort(pointer, (short)-1);
        }
        int[] empty = new int[this.landmarks];
        Arrays.fill(empty, -1);
        this.landmarkIDs.add(empty);
        byte[] subnetworks = new byte[this.graph.getNodes()];
        Arrays.fill(subnetworks, (byte)-1);
        String snKey = Subnetwork.key(this.lmConfig.getName());
        if (!this.graph.getEncodingManager().hasEncodedValue(snKey)) {
            throw new IllegalArgumentException("EncodedValue '" + snKey + "' does not exist. For Landmarks this is currently required (also used in PrepareRoutingSubnetworks). See #2256");
        }
        BooleanEncodedValue edgeInSubnetworkEnc = this.graph.getEncodingManager().getBooleanEncodedValue(snKey);
        if (this.areaIndex != null) {
            StopWatch sw = new StopWatch().start();
            blockedEdges = this.findBorderEdgeIds(this.areaIndex);
            if (this.logDetails) {
                LOGGER.info("Made " + blockedEdges.size() + " edges inaccessible. Calculated country cut in " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
            }
        } else {
            blockedEdges = new IntHashSet();
        }
        EdgeFilter accessFilter = edge -> !edge.get(edgeInSubnetworkEnc) && !blockedEdges.contains(edge.getEdge());
        EdgeFilter tarjanFilter = edge -> accessFilter.accept(edge) && Double.isFinite(this.weighting.calcEdgeWeightWithAccess(edge, false));
        StopWatch sw = new StopWatch().start();
        TarjanSCC.ConnectedComponents graphComponents = TarjanSCC.findComponents(this.graph, tarjanFilter, true);
        if (this.logDetails) {
            LOGGER.info("Calculated " + graphComponents.getComponents().size() + " subnetworks via tarjan in " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
        }
        String additionalInfo = "";
        if (this.factor <= 0.0) {
            double maxWeight = this.estimateMaxWeight(graphComponents.getComponents(), accessFilter);
            this.setMaximumWeight(maxWeight);
            additionalInfo = ", maxWeight:" + maxWeight + " from quick estimation";
        }
        if (this.logDetails) {
            LOGGER.info("init landmarks for subnetworks with node count greater than " + this.minimumNodes + " with factor:" + this.factor + additionalInfo);
        }
        int nodes = 0;
        for (IntArrayList subnetworkIds : graphComponents.getComponents()) {
            int index;
            nodes += subnetworkIds.size();
            if (subnetworkIds.size() < this.minimumNodes) continue;
            if (this.factor <= 0.0) {
                throw new IllegalStateException("factor wasn't initialized " + this.factor + ", subnetworks:" + graphComponents.getComponents().size() + ", minimumNodes:" + this.minimumNodes + ", current size:" + subnetworkIds.size());
            }
            for (index = subnetworkIds.size() - 1; index >= 0; --index) {
                int nextStartNode = subnetworkIds.get(index);
                if (subnetworks[nextStartNode] != -1) continue;
                if (this.logDetails) {
                    GHPoint p = LandmarkStorage.createPoint(this.graph, nextStartNode);
                    LOGGER.info("start node: " + nextStartNode + " (" + p + ") subnetwork " + index + ", subnetwork size: " + subnetworkIds.size() + ", " + Helper.getMemInfo() + (this.areaIndex == null ? "" : " area:" + this.areaIndex.query(p.lat, p.lon)));
                }
                if (this.createLandmarksForSubnetwork(nextStartNode, subnetworks, accessFilter)) break;
            }
            if (index >= 0) continue;
            LOGGER.warn("next start node not found in big enough network of size " + subnetworkIds.size() + ", first element is " + subnetworkIds.get(0) + ", " + LandmarkStorage.createPoint(this.graph, subnetworkIds.get(0)));
        }
        int subnetworkCount = this.landmarkIDs.size();
        this.landmarkWeightDA.ensureCapacity(maxBytes + (long)(subnetworkCount * this.landmarks));
        long bytePos = maxBytes;
        for (int[] landmarks : this.landmarkIDs) {
            for (int lmNodeId : landmarks) {
                this.landmarkWeightDA.setInt(bytePos, lmNodeId);
                bytePos += 4L;
            }
        }
        this.landmarkWeightDA.setHeader(0, this.graph.getNodes());
        this.landmarkWeightDA.setHeader(4, this.landmarks);
        this.landmarkWeightDA.setHeader(8, subnetworkCount);
        if (this.factor * 1000000.0 > 2.147483647E9) {
            throw new UnsupportedOperationException("landmark weight factor cannot be bigger than Integer.MAX_VALUE " + this.factor * 1000000.0);
        }
        this.landmarkWeightDA.setHeader(12, (int)Math.round(this.factor * 1000000.0));
        this.subnetworkStorage.create(this.graph.getNodes());
        for (int nodeId = 0; nodeId < subnetworks.length; ++nodeId) {
            this.subnetworkStorage.setSubnetwork(nodeId, subnetworks[nodeId]);
        }
        if (this.logDetails) {
            LOGGER.info("Finished landmark creation. Subnetwork node count sum " + nodes + " vs. nodes " + this.graph.getNodes());
        }
        this.initialized = true;
    }

    private double estimateMaxWeight(List<IntArrayList> graphComponents, EdgeFilter accessFilter) {
        double maxWeight = 0.0;
        int searchedSubnetworks = 0;
        Random random = new Random(0L);
        int[] tmpLandmarkNodeIds = new int[3];
        block0: for (IntArrayList subnetworkIds : graphComponents) {
            if (subnetworkIds.size() < this.minimumNodes) continue;
            ++searchedSubnetworks;
            int maxRetries = Math.max(subnetworkIds.size(), 100);
            for (int retry = 0; retry < maxRetries; ++retry) {
                int index = random.nextInt(subnetworkIds.size());
                int nextStartNode = subnetworkIds.get(index);
                LandmarkExplorer explorer = this.findLandmarks(tmpLandmarkNodeIds, nextStartNode, accessFilter, "estimate " + index);
                if (explorer.getFromCount() < this.minimumNodes) {
                    LOGGER.error("method findLandmarks for " + LandmarkStorage.createPoint(this.graph, nextStartNode) + " (" + nextStartNode + ") resulted in too few visited nodes: " + explorer.getFromCount() + " vs expected minimum " + this.minimumNodes + ", see #2256");
                    continue;
                }
                for (int lmIdx = 0; lmIdx < tmpLandmarkNodeIds.length; ++lmIdx) {
                    int lmNodeId = tmpLandmarkNodeIds[lmIdx];
                    explorer = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode, accessFilter, false);
                    explorer.setStartNode(lmNodeId);
                    explorer.runAlgo();
                    maxWeight = Math.max(maxWeight, explorer.getLastEntry().weight);
                }
                continue block0;
            }
        }
        if (maxWeight <= 0.0 && searchedSubnetworks > 0) {
            throw new IllegalStateException("max weight wasn't set although " + searchedSubnetworks + " subnetworks were searched (total " + graphComponents.size() + "), minimumNodes:" + this.minimumNodes);
        }
        return maxWeight * 1.008;
    }

    private boolean createLandmarksForSubnetwork(int startNode, byte[] subnetworks, EdgeFilter accessFilter) {
        int subnetworkId = this.landmarkIDs.size();
        int[] tmpLandmarkNodeIds = new int[this.landmarks];
        int logOffset = Math.max(1, this.landmarks / 2);
        boolean pickedPrecalculatedLandmarks = false;
        if (!this.landmarkSuggestions.isEmpty()) {
            double lat = this.na.getLat(startNode);
            double lon = this.na.getLon(startNode);
            LandmarkSuggestion selectedSuggestion = null;
            for (LandmarkSuggestion lmsugg : this.landmarkSuggestions) {
                if (!lmsugg.getBox().contains(lat, lon)) continue;
                selectedSuggestion = lmsugg;
                break;
            }
            if (selectedSuggestion != null) {
                if (selectedSuggestion.getNodeIds().size() < tmpLandmarkNodeIds.length) {
                    throw new IllegalArgumentException("landmark suggestions are too few " + selectedSuggestion.getNodeIds().size() + " for requested landmarks " + this.landmarks);
                }
                pickedPrecalculatedLandmarks = true;
                for (int i = 0; i < tmpLandmarkNodeIds.length; ++i) {
                    int lmNodeId;
                    tmpLandmarkNodeIds[i] = lmNodeId = selectedSuggestion.getNodeIds().get(i).intValue();
                }
            }
        }
        if (pickedPrecalculatedLandmarks) {
            LOGGER.info("Picked " + tmpLandmarkNodeIds.length + " landmark suggestions, skip finding landmarks");
        } else {
            LandmarkExplorer explorer = this.findLandmarks(tmpLandmarkNodeIds, startNode, accessFilter, "create");
            if (explorer.getFromCount() < this.minimumNodes) {
                explorer.setSubnetworks(subnetworks, 0);
                return false;
            }
            if (this.logDetails) {
                LOGGER.info("Finished searching landmarks for subnetwork " + subnetworkId + " of size " + explorer.getVisitedNodes());
            }
        }
        for (int lmIdx = 0; lmIdx < tmpLandmarkNodeIds.length; ++lmIdx) {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("Thread was interrupted for landmark " + lmIdx);
            }
            int lmNodeId = tmpLandmarkNodeIds[lmIdx];
            LandmarkExplorer explorer = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode, accessFilter, false);
            explorer.setStartNode(lmNodeId);
            explorer.runAlgo();
            explorer.initLandmarkWeights(lmIdx, lmNodeId, this.LM_ROW_LENGTH, this.FROM_OFFSET);
            if (lmIdx == 0 && explorer.setSubnetworks(subnetworks, subnetworkId)) {
                return false;
            }
            explorer = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode, accessFilter, true);
            explorer.setStartNode(lmNodeId);
            explorer.runAlgo();
            explorer.initLandmarkWeights(lmIdx, lmNodeId, this.LM_ROW_LENGTH, this.TO_OFFSET);
            if (lmIdx == 0 && explorer.setSubnetworks(subnetworks, subnetworkId)) {
                return false;
            }
            if (!this.logDetails || lmIdx % logOffset != 0) continue;
            LOGGER.info("Set landmarks weights [" + this.weighting + "]. Progress " + (int)(100.0 * (double)lmIdx / (double)tmpLandmarkNodeIds.length) + "%");
        }
        this.landmarkIDs.add(tmpLandmarkNodeIds);
        return true;
    }

    public void setAreaIndex(AreaIndex<SplitArea> areaIndex) {
        this.areaIndex = areaIndex;
    }

    protected IntHashSet findBorderEdgeIds(AreaIndex<SplitArea> areaIndex) {
        AllEdgesIterator allEdgesIterator = this.graph.getAllEdges();
        IntHashSet inaccessible = new IntHashSet();
        while (allEdgesIterator.next()) {
            int baseNode;
            SplitArea areaBase;
            int adjNode = allEdgesIterator.getAdjNode();
            List<SplitArea> areas = areaIndex.query(this.na.getLat(adjNode), this.na.getLon(adjNode));
            SplitArea areaAdj = areas.isEmpty() ? null : areas.get(0);
            if (areaAdj == (areaBase = (areas = areaIndex.query(this.na.getLat(baseNode = allEdgesIterator.getBaseNode()), this.na.getLon(baseNode))).isEmpty() ? null : areas.get(0))) continue;
            inaccessible.add(allEdgesIterator.getEdge());
        }
        return inaccessible;
    }

    double getFactor() {
        return this.factor;
    }

    int getFromWeight(int landmarkIndex, int node) {
        int res = this.landmarkWeightDA.getShort((long)node * this.LM_ROW_LENGTH + (long)(landmarkIndex * 4) + (long)this.FROM_OFFSET) & 0xFFFF;
        if (res == 65535) {
            return 65534;
        }
        return res;
    }

    int getToWeight(int landmarkIndex, int node) {
        int res = this.landmarkWeightDA.getShort((long)node * this.LM_ROW_LENGTH + (long)(landmarkIndex * 4) + (long)this.TO_OFFSET) & 0xFFFF;
        if (res == 65535) {
            return 65534;
        }
        return res;
    }

    final boolean setWeight(long pointer, double value) {
        double tmpVal = value / this.factor;
        if (tmpVal > 2.147483647E9) {
            throw new UnsupportedOperationException("Cannot store infinity explicitly, pointer=" + pointer + ", value=" + value + ", factor=" + this.factor);
        }
        if (tmpVal >= 65534.0) {
            this.landmarkWeightDA.setShort(pointer, (short)-2);
            return false;
        }
        this.landmarkWeightDA.setShort(pointer, (short)tmpVal);
        return true;
    }

    boolean isInfinity(long pointer) {
        return (this.landmarkWeightDA.getShort(pointer) & 0xFFFF) == 65535;
    }

    int calcWeight(EdgeIteratorState edge, boolean reverse) {
        return (int)(this.weighting.calcEdgeWeight(edge, reverse) / this.factor);
    }

    boolean chooseActiveLandmarks(int fromNode, int toNode, int[] activeLandmarkIndices, boolean reverse) {
        if (fromNode < 0 || toNode < 0) {
            throw new IllegalStateException("from " + fromNode + " and to " + toNode + " nodes have to be 0 or positive to init landmarks");
        }
        int subnetworkFrom = this.subnetworkStorage.getSubnetwork(fromNode);
        int subnetworkTo = this.subnetworkStorage.getSubnetwork(toNode);
        if (subnetworkFrom <= 0 || subnetworkTo <= 0) {
            return false;
        }
        if (subnetworkFrom != subnetworkTo) {
            throw new ConnectionNotFoundException("Connection between locations not found. Different subnetworks " + subnetworkFrom + " vs. " + subnetworkTo, new HashMap());
        }
        ArrayList<MapEntry<Integer, Integer>> list = new ArrayList<MapEntry<Integer, Integer>>(this.landmarks);
        for (int lmIndex = 0; lmIndex < this.landmarks; ++lmIndex) {
            int fromWeight = this.getFromWeight(lmIndex, toNode) - this.getFromWeight(lmIndex, fromNode);
            int toWeight = this.getToWeight(lmIndex, fromNode) - this.getToWeight(lmIndex, toNode);
            list.add(new MapEntry<Integer, Integer>(reverse ? Math.max(-fromWeight, -toWeight) : Math.max(fromWeight, toWeight), lmIndex));
        }
        Collections.sort(list, SORT_BY_WEIGHT);
        if (activeLandmarkIndices[0] >= 0) {
            IntHashSet set = new IntHashSet(activeLandmarkIndices.length);
            set.addAll(activeLandmarkIndices);
            int existingLandmarkCounter = 0;
            int COUNT = Math.min(activeLandmarkIndices.length - 2, 2);
            for (int i = 0; i < activeLandmarkIndices.length && i < activeLandmarkIndices.length - COUNT + existingLandmarkCounter; ++i) {
                activeLandmarkIndices[i] = (Integer)((Map.Entry)list.get(i)).getValue();
                if (!set.contains(activeLandmarkIndices[i])) continue;
                ++existingLandmarkCounter;
            }
        } else {
            for (int i = 0; i < activeLandmarkIndices.length; ++i) {
                activeLandmarkIndices[i] = (Integer)((Map.Entry)list.get(i)).getValue();
            }
        }
        return true;
    }

    public int getLandmarkCount() {
        return this.landmarks;
    }

    public int[] getLandmarks(int subnetwork) {
        return this.landmarkIDs.get(subnetwork);
    }

    public int getSubnetworksWithLandmarks() {
        return this.landmarkIDs.size();
    }

    public boolean isEmpty() {
        return this.landmarkIDs.size() < 2;
    }

    public String toString() {
        String str = "";
        for (int[] ints : this.landmarkIDs) {
            if (!str.isEmpty()) {
                str = str + ", ";
            }
            str = str + Arrays.toString(ints);
        }
        return str;
    }

    String getLandmarksAsGeoJSON() {
        String str = "";
        for (int subnetwork = 1; subnetwork < this.landmarkIDs.size(); ++subnetwork) {
            int[] lmArray = this.landmarkIDs.get(subnetwork);
            for (int lmIdx = 0; lmIdx < lmArray.length; ++lmIdx) {
                int index = lmArray[lmIdx];
                if (!str.isEmpty()) {
                    str = str + ",";
                }
                str = str + "{ \"type\": \"Feature\", \"geometry\": {\"type\": \"Point\", \"coordinates\": [" + this.na.getLon(index) + ", " + this.na.getLat(index) + "]},";
                str = str + "  \"properties\":{\"node_index\":" + index + ",\"subnetwork\":" + subnetwork + ",\"lm_index\":" + lmIdx + "}}";
            }
        }
        return "{ \"type\": \"FeatureCollection\", \"features\": [" + str + "]}";
    }

    public boolean loadExisting() {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call PrepareLandmarks.loadExisting if already initialized");
        }
        if (this.landmarkWeightDA.loadExisting()) {
            long maxBytes;
            if (!this.subnetworkStorage.loadExisting()) {
                throw new IllegalStateException("landmark weights loaded but not the subnetworks!?");
            }
            int nodes = this.landmarkWeightDA.getHeader(0);
            if (nodes != this.graph.getNodes()) {
                throw new IllegalArgumentException("Cannot load landmark data as written for different graph storage with " + nodes + " nodes, not " + this.graph.getNodes());
            }
            this.landmarks = this.landmarkWeightDA.getHeader(4);
            int subnetworks = this.landmarkWeightDA.getHeader(8);
            this.factor = (double)this.landmarkWeightDA.getHeader(12) / 1000000.0;
            this.LM_ROW_LENGTH = this.landmarks * 4;
            long bytePos = maxBytes = this.LM_ROW_LENGTH * (long)nodes;
            for (int j = 0; j < subnetworks; ++j) {
                int[] tmpLandmarks = new int[this.landmarks];
                for (int i = 0; i < tmpLandmarks.length; ++i) {
                    tmpLandmarks[i] = this.landmarkWeightDA.getInt(bytePos);
                    bytePos += 4L;
                }
                this.landmarkIDs.add(tmpLandmarks);
            }
            this.initialized = true;
            return true;
        }
        return false;
    }

    public void flush() {
        this.landmarkWeightDA.flush();
        this.subnetworkStorage.flush();
    }

    public void close() {
        this.landmarkWeightDA.close();
        this.subnetworkStorage.close();
    }

    public boolean isClosed() {
        return this.landmarkWeightDA.isClosed();
    }

    public long getCapacity() {
        return this.landmarkWeightDA.getCapacity() + this.subnetworkStorage.getCapacity();
    }

    int getBaseNodes() {
        return this.graph.getNodes();
    }

    private LandmarkExplorer findLandmarks(int[] landmarkNodeIdsToReturn, int startNode, EdgeFilter accessFilter, String info) {
        int logOffset = Math.max(1, landmarkNodeIdsToReturn.length / 2);
        Weighting initWeighting = this.lmSelectionWeighting;
        LandmarkExplorer explorer = new LandmarkExplorer(this.graph, this, initWeighting, this.traversalMode, accessFilter, false);
        explorer.setStartNode(startNode);
        explorer.runAlgo();
        if (explorer.getFromCount() >= this.minimumNodes) {
            landmarkNodeIdsToReturn[0] = explorer.getLastEntry().adjNode;
            for (int lmIdx = 0; lmIdx < landmarkNodeIdsToReturn.length - 1; ++lmIdx) {
                explorer = new LandmarkExplorer(this.graph, this, initWeighting, this.traversalMode, accessFilter, false);
                for (int j = 0; j < lmIdx + 1; ++j) {
                    explorer.setStartNode(landmarkNodeIdsToReturn[j]);
                }
                explorer.runAlgo();
                landmarkNodeIdsToReturn[lmIdx + 1] = explorer.getLastEntry().adjNode;
                if (!this.logDetails || lmIdx % logOffset != 0) continue;
                LOGGER.info("Finding landmarks [" + this.lmConfig + "] in network [" + explorer.getVisitedNodes() + "] for " + info + ". Start node:" + startNode + " (" + LandmarkStorage.createPoint(this.graph, startNode) + ")Progress " + (int)(100.0 * (double)lmIdx / (double)landmarkNodeIdsToReturn.length) + "%, " + Helper.getMemInfo());
            }
        }
        return explorer;
    }

    DataAccess _getInternalDA() {
        return this.landmarkWeightDA;
    }

    static GHPoint createPoint(Graph graph, int nodeId) {
        return new GHPoint(graph.getNodeAccess().getLat(nodeId), graph.getNodeAccess().getLon(nodeId));
    }

    private static class LandmarkExplorer
    extends DijkstraBidirectionRef {
        private EdgeFilter accessFilter;
        private final boolean reverse;
        private final LandmarkStorage lms;
        private SPTEntry lastEntry;

        public LandmarkExplorer(Graph g, LandmarkStorage lms, Weighting weighting, TraversalMode tMode, EdgeFilter accessFilter, boolean reverse) {
            super(g, weighting, tMode);
            this.accessFilter = accessFilter;
            this.lms = lms;
            this.reverse = reverse;
            if (reverse) {
                this.finishedFrom = true;
            } else {
                this.finishedTo = true;
            }
            this.setUpdateBestPath(false);
        }

        public void setStartNode(int startNode) {
            if (this.reverse) {
                this.initTo(startNode, 0.0);
            } else {
                this.initFrom(startNode, 0.0);
            }
        }

        @Override
        protected double calcWeight(EdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
            if (!this.accessFilter.accept(iter)) {
                return Double.POSITIVE_INFINITY;
            }
            return GHUtility.calcWeightWithTurnWeightWithAccess(this.weighting, iter, reverse, currEdge.edge) + currEdge.getWeightOfVisitedPath();
        }

        int getFromCount() {
            return this.bestWeightMapFrom.size();
        }

        @Override
        public void runAlgo() {
            super.runAlgo();
        }

        SPTEntry getLastEntry() {
            if (!this.finished()) {
                throw new IllegalStateException("Cannot get max weight if not yet finished");
            }
            return this.lastEntry;
        }

        @Override
        public boolean finished() {
            if (this.reverse) {
                this.lastEntry = this.currTo;
                return this.finishedTo;
            }
            this.lastEntry = this.currFrom;
            return this.finishedFrom;
        }

        public boolean setSubnetworks(final byte[] subnetworks, final int subnetworkId) {
            if (subnetworkId > 127) {
                throw new IllegalStateException("Too many subnetworks " + subnetworkId);
            }
            final AtomicBoolean failed = new AtomicBoolean(false);
            IntObjectMap map = this.reverse ? this.bestWeightMapTo : this.bestWeightMapFrom;
            map.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(){

                public boolean apply(int nodeId, SPTEntry value) {
                    byte sn = subnetworks[nodeId];
                    if (sn != subnetworkId) {
                        if (sn != -1 && sn != 0) {
                            LOGGER.error("subnetworkId for node " + nodeId + " (" + LandmarkStorage.createPoint(graph, nodeId) + ") already set (" + sn + "). Cannot change to " + subnetworkId);
                            failed.set(true);
                            return false;
                        }
                        subnetworks[nodeId] = (byte)subnetworkId;
                    }
                    return true;
                }
            });
            return failed.get();
        }

        public void initLandmarkWeights(final int lmIdx, int lmNodeId, final long rowSize, final int offset) {
            IntObjectMap map = this.reverse ? this.bestWeightMapTo : this.bestWeightMapFrom;
            final AtomicInteger maxedout = new AtomicInteger(0);
            final MapEntry<Double, Double> finalMaxWeight = new MapEntry<Double, Double>(0.0, 0.0);
            map.forEach((IntObjectProcedure)new IntObjectProcedure<SPTEntry>(){

                public void apply(int nodeId, SPTEntry b) {
                    if (!lms.setWeight((long)nodeId * rowSize + (long)(lmIdx * 4) + (long)offset, b.weight)) {
                        maxedout.incrementAndGet();
                        finalMaxWeight.setValue(Math.max(b.weight, (Double)finalMaxWeight.getValue()));
                    }
                }
            });
            if ((double)maxedout.get() / (double)map.size() > 0.1) {
                LOGGER.warn("landmark " + lmIdx + " (" + this.nodeAccess.getLat(lmNodeId) + "," + this.nodeAccess.getLon(lmNodeId) + "): too many weights were maxed out (" + maxedout.get() + "/" + map.size() + "). Use a bigger factor than " + this.lms.factor + ". For example use maximum_lm_weight: " + (Double)finalMaxWeight.getValue() * 1.2 + " in your LM profile definition");
            }
        }
    }
}

