/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.util.Bike2WeightFlagEncoder;
import com.graphhopper.routing.util.BikeFlagEncoder;
import com.graphhopper.routing.util.Car4WDFlagEncoder;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.HikeFlagEncoder;
import com.graphhopper.routing.util.MotorcycleFlagEncoder;
import com.graphhopper.routing.util.MountainBikeFlagEncoder;
import com.graphhopper.routing.util.RacingBikeFlagEncoder;
import com.graphhopper.routing.util.RoadsFlagEncoder;
import com.graphhopper.routing.util.WheelchairFlagEncoder;
import com.graphhopper.util.PMap;

public class DefaultFlagEncoderFactory
implements FlagEncoderFactory {
    @Override
    public FlagEncoder createFlagEncoder(String name, PMap configuration) {
        if (name.equals("roads")) {
            return new RoadsFlagEncoder();
        }
        if (name.equals("car")) {
            return new CarFlagEncoder(configuration);
        }
        if (name.equals("car4wd")) {
            return new Car4WDFlagEncoder(configuration);
        }
        if (name.equals("bike")) {
            return new BikeFlagEncoder(configuration);
        }
        if (name.equals("bike2")) {
            return new Bike2WeightFlagEncoder(configuration);
        }
        if (name.equals("racingbike")) {
            return new RacingBikeFlagEncoder(configuration);
        }
        if (name.equals("mtb")) {
            return new MountainBikeFlagEncoder(configuration);
        }
        if (name.equals("foot")) {
            return new FootFlagEncoder(configuration);
        }
        if (name.equals("hike")) {
            return new HikeFlagEncoder(configuration);
        }
        if (name.equals("motorcycle")) {
            return new MotorcycleFlagEncoder(configuration);
        }
        if (name.equals("wheelchair")) {
            return new WheelchairFlagEncoder(configuration);
        }
        throw new IllegalArgumentException("entry in encoder list not supported: " + name);
    }
}

