/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.BikeCommonFlagEncoder;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.RoadsFlagEncoder;
import com.graphhopper.routing.util.parsers.DefaultTagParserFactory;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMFootNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMGetOffBikeParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.routing.util.parsers.OSMTurnRelationParser;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EncodingManager
implements EncodedValueLookup {
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private final Map<String, EncodedValue> encodedValueMap = new LinkedHashMap<String, EncodedValue>();
    private final List<RelationTagParser> relationTagParsers = new ArrayList<RelationTagParser>();
    private final List<TagParser> edgeTagParsers = new ArrayList<TagParser>();
    private final Map<String, TurnCostParser> turnCostParsers = new LinkedHashMap<String, TurnCostParser>();
    private final EncodedValue.InitializerConfig turnCostConfig = new EncodedValue.InitializerConfig();
    private final EncodedValue.InitializerConfig relationConfig = new EncodedValue.InitializerConfig();
    private final EncodedValue.InitializerConfig edgeConfig = new EncodedValue.InitializerConfig();
    private static final String SPECIAL_SEPARATOR = "$";
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("first_match", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "non-sealed", "null", "package", "permits", "private", "protected", "public", "record", "return", "sealed", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while", "yield", "_"));

    public static EncodingManager create(String flagEncodersStr) {
        return EncodingManager.create(new DefaultFlagEncoderFactory(), flagEncodersStr);
    }

    public static EncodingManager create(FlagEncoderFactory factory, String flagEncodersStr) {
        return EncodingManager.createBuilder(Arrays.stream(flagEncodersStr.split(",")).filter(s -> !s.trim().isEmpty()).map(s -> EncodingManager.parseEncoderString(factory, s)).collect(Collectors.toList())).build();
    }

    public static EncodingManager create(FlagEncoder ... flagEncoders) {
        return EncodingManager.create(Arrays.asList(flagEncoders));
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders) {
        return EncodingManager.createBuilder(flagEncoders).build();
    }

    private static Builder createBuilder(List<? extends FlagEncoder> flagEncoders) {
        Builder builder = new Builder();
        for (FlagEncoder flagEncoder : flagEncoders) {
            builder.add(flagEncoder);
        }
        return builder;
    }

    public static EncodingManager create(Builder builder, EncodedValueFactory evFactory, FlagEncoderFactory flagEncoderFactory, StorableProperties properties) {
        String encodedValuesStr = properties.get("graph.encoded_values");
        for (String evString : encodedValuesStr.split(",")) {
            builder.addIfAbsent(evFactory, evString);
        }
        String flagEncoderValuesStr = properties.get("graph.flag_encoders");
        for (String encoderString : flagEncoderValuesStr.split(",")) {
            builder.addIfAbsent(flagEncoderFactory, encoderString);
        }
        return builder.build();
    }

    public static Builder start() {
        return new Builder();
    }

    private EncodingManager() {
    }

    public void releaseParsers() {
        this.turnCostParsers.clear();
        this.edgeTagParsers.clear();
        this.relationTagParsers.clear();
    }

    static FlagEncoder parseEncoderString(FlagEncoderFactory factory, String encoderString) {
        if (!encoderString.equals(Helper.toLowerCase((String)encoderString))) {
            throw new IllegalArgumentException("An upper case name for the FlagEncoder is not allowed: " + encoderString);
        }
        if ((encoderString = encoderString.trim()).isEmpty()) {
            throw new IllegalArgumentException("FlagEncoder cannot be empty. " + encoderString);
        }
        String entryVal = "";
        if (encoderString.contains("|")) {
            entryVal = encoderString;
            encoderString = encoderString.split("\\|")[0];
        }
        PMap configuration = new PMap(entryVal);
        return factory.createFlagEncoder(encoderString, configuration);
    }

    static EncodedValue parseEncodedValueString(EncodedValueFactory factory, String encodedValueString) {
        if (!encodedValueString.equals(Helper.toLowerCase((String)encodedValueString))) {
            throw new IllegalArgumentException("Use lower case for EncodedValues: " + encodedValueString);
        }
        if ((encodedValueString = encodedValueString.trim()).isEmpty()) {
            throw new IllegalArgumentException("EncodedValue cannot be empty. " + encodedValueString);
        }
        EncodedValue evObject = factory.create(encodedValueString);
        PMap map = new PMap(encodedValueString);
        if (!map.has("version")) {
            throw new IllegalArgumentException("EncodedValue must have a version specified but it was " + encodedValueString);
        }
        return evObject;
    }

    private static TagParser parseEncodedValueString(TagParserFactory factory, String tagParserString) {
        if (!tagParserString.equals(Helper.toLowerCase((String)tagParserString))) {
            throw new IllegalArgumentException("Use lower case for TagParser: " + tagParserString);
        }
        PMap map = new PMap(tagParserString);
        return factory.create(tagParserString, map);
    }

    public int getIntsForFlags() {
        return (int)Math.ceil((double)this.edgeConfig.getRequiredBits() / 32.0);
    }

    private void addEncoder(AbstractFlagEncoder encoder) {
        encoder.setEncodedValueLookup(this);
        ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
        encoder.createEncodedValues(list);
        for (EncodedValue ev : list) {
            this.addEncodedValue(ev, true);
        }
        this.edgeEncoders.add(encoder);
    }

    private void addEncodedValue(EncodedValue ev, boolean withNamespace) {
        String normalizedKey = ev.getName().replaceAll(SPECIAL_SEPARATOR, "_");
        if (this.hasEncodedValue(normalizedKey)) {
            throw new IllegalStateException("EncodedValue " + ev.getName() + " collides with " + normalizedKey);
        }
        if (!withNamespace && !EncodingManager.isSharedEncodedValues(ev)) {
            throw new IllegalArgumentException("EncodedValue " + ev.getName() + " must not contain namespace character '" + SPECIAL_SEPARATOR + "'");
        }
        if (withNamespace && EncodingManager.isSharedEncodedValues(ev)) {
            throw new IllegalArgumentException("EncodedValue " + ev.getName() + " must contain namespace character '" + SPECIAL_SEPARATOR + "'");
        }
        ev.init(this.edgeConfig);
        this.encodedValueMap.put(ev.getName(), ev);
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueMap.get(key) != null;
    }

    public boolean hasEncoder(String encoder) {
        return this.getEncoder(encoder, false) != null;
    }

    public FlagEncoder getEncoder(String name) {
        return this.getEncoder(name, true);
    }

    private FlagEncoder getEncoder(String name, boolean throwExc) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!name.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (throwExc) {
            throw new IllegalArgumentException("FlagEncoder for " + name + " not found. Existing: " + this.toFlagEncodersAsString());
        }
        return null;
    }

    public boolean acceptWay(ReaderWay way) {
        return this.edgeEncoders.stream().anyMatch(encoder -> !encoder.getAccess(way).equals((Object)Access.CAN_SKIP));
    }

    public IntsRef handleRelationTags(ReaderRelation relation, IntsRef relFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleRelationTags(relFlags, relation);
        }
        return relFlags;
    }

    public void handleTurnRelationTags(OSMTurnRelation turnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        for (TurnCostParser parser : this.turnCostParsers.values()) {
            parser.handleTurnRelationTags(turnRelation, map, graph);
        }
    }

    public IntsRef handleWayTags(ReaderWay way, IntsRef relationFlags) {
        IntsRef edgeFlags = this.createEdgeFlags();
        for (TagParser parser : this.edgeTagParsers) {
            parser.handleWayTags(edgeFlags, way, relationFlags);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.handleWayTags(edgeFlags, way);
            if (edgeFlags.isEmpty()) continue;
            Map<String, Object> nodeTags = way.getTag("node_tags", Collections.emptyMap());
            encoder.handleNodeTags(edgeFlags, nodeTags);
        }
        return edgeFlags;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(flagEncoder.toString());
        }
        return str.toString();
    }

    public String toFlagEncodersAsString() {
        StringBuilder str = new StringBuilder();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(encoder.toString()).append("|").append(encoder.getPropertiesString());
        }
        return str.toString();
    }

    public String toEncodedValuesAsString() {
        StringBuilder str = new StringBuilder();
        for (EncodedValue ev : this.encodedValueMap.values()) {
            if (!EncodingManager.isSharedEncodedValues(ev)) continue;
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(ev.toString());
        }
        return str.toString();
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef(this.getIntsForFlags());
    }

    public IntsRef createRelationFlags() {
        return new IntsRef(2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingManager that = (EncodingManager)o;
        return this.edgeEncoders.equals(that.edgeEncoders) && this.encodedValueMap.equals(that.encodedValueMap);
    }

    public int hashCode() {
        return Objects.hash(this.edgeEncoders, this.encodedValueMap);
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.applyWayTags(way, edge);
        }
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        return new ArrayList<FlagEncoder>(this.edgeEncoders);
    }

    public boolean needsTurnCostsSupport() {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.supportsTurnCosts()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<EncodedValue> getEncodedValues() {
        return Collections.unmodifiableList(new ArrayList<EncodedValue>(this.encodedValueMap.values()));
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum<?>> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public StringEncodedValue getStringEncodedValue(String key) {
        return this.getEncodedValue(key, StringEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue " + key + " in collection: " + ev);
        }
        return (T)ev;
    }

    private static boolean isSharedEncodedValues(EncodedValue ev) {
        return EncodingManager.isValidEncodedValue(ev.getName()) && !ev.getName().contains(SPECIAL_SEPARATOR);
    }

    public static String getKey(FlagEncoder encoder, String str) {
        return EncodingManager.getKey(encoder.toString(), str);
    }

    public static String getKey(String prefix, String str) {
        return prefix + SPECIAL_SEPARATOR + str;
    }

    public static boolean isValidEncodedValue(String name) {
        if (name.isEmpty() || !EncodingManager.isLowerLetter(name.charAt(0)) || KEYWORDS.contains(name)) {
            return false;
        }
        int dollarCount = 0;
        int underscoreCount = 0;
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '$') {
                if (dollarCount > 0) {
                    return false;
                }
                ++dollarCount;
                continue;
            }
            if (c == '_') {
                if (underscoreCount > 0) {
                    return false;
                }
                ++underscoreCount;
                continue;
            }
            if (!EncodingManager.isLowerLetter(c) && !EncodingManager.isNumber(c)) {
                return false;
            }
            underscoreCount = 0;
        }
        return true;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static enum Access {
        WAY,
        FERRY,
        OTHER,
        CAN_SKIP;


        public boolean isFerry() {
            return this.ordinal() == FERRY.ordinal();
        }

        public boolean isWay() {
            return this.ordinal() == WAY.ordinal();
        }

        public boolean isOther() {
            return this.ordinal() == OTHER.ordinal();
        }

        public boolean canSkip() {
            return this.ordinal() == CAN_SKIP.ordinal();
        }
    }

    public static class Builder {
        private EncodingManager em;
        private DateRangeParser dateRangeParser;
        private final Map<String, AbstractFlagEncoder> flagEncoderMap = new LinkedHashMap<String, AbstractFlagEncoder>();
        private final Map<String, EncodedValue> encodedValueMap = new LinkedHashMap<String, EncodedValue>();
        private final Set<TagParser> tagParserSet = new LinkedHashSet<TagParser>();
        private final List<TurnCostParser> turnCostParsers = new ArrayList<TurnCostParser>();
        private final List<RelationTagParser> relationTagParsers = new ArrayList<RelationTagParser>();

        public Builder() {
            this.em = new EncodingManager();
        }

        public boolean addIfAbsent(FlagEncoderFactory factory, String flagEncoderString) {
            this.check();
            String key = flagEncoderString.split("\\|")[0].trim();
            if (this.flagEncoderMap.containsKey(key)) {
                return false;
            }
            FlagEncoder fe = EncodingManager.parseEncoderString(factory, flagEncoderString);
            this.flagEncoderMap.put(fe.toString(), (AbstractFlagEncoder)fe);
            return true;
        }

        public boolean addIfAbsent(EncodedValueFactory factory, String encodedValueString) {
            this.check();
            String key = encodedValueString.split("\\|")[0].trim();
            if (this.encodedValueMap.containsKey(key)) {
                return false;
            }
            EncodedValue ev = EncodingManager.parseEncodedValueString(factory, encodedValueString);
            this.encodedValueMap.put(ev.getName(), ev);
            return true;
        }

        public boolean addIfAbsent(TagParserFactory factory, String tagParserString) {
            this.check();
            tagParserString = tagParserString.trim();
            if (tagParserString.isEmpty()) {
                return false;
            }
            TagParser tagParser = EncodingManager.parseEncodedValueString(factory, tagParserString);
            return this.tagParserSet.add(tagParser);
        }

        public Builder addTurnCostParser(TurnCostParser parser) {
            this.check();
            this.turnCostParsers.add(parser);
            return this;
        }

        public Builder addRelationTagParser(RelationTagParser tagParser) {
            this.check();
            this.relationTagParsers.add(tagParser);
            return this;
        }

        public Builder add(FlagEncoder encoder) {
            this.check();
            if (this.flagEncoderMap.containsKey(encoder.toString())) {
                throw new IllegalArgumentException("FlagEncoder already exists: " + encoder);
            }
            this.flagEncoderMap.put(encoder.toString(), (AbstractFlagEncoder)encoder);
            return this;
        }

        public Builder add(EncodedValue encodedValue) {
            this.check();
            if (this.encodedValueMap.containsKey(encodedValue.getName())) {
                throw new IllegalArgumentException("EncodedValue already exists: " + encodedValue.getName());
            }
            this.encodedValueMap.put(encodedValue.getName(), encodedValue);
            return this;
        }

        public Builder add(TagParser tagParser) {
            this.check();
            if (!this.tagParserSet.add(tagParser)) {
                throw new IllegalArgumentException("TagParser already exists: " + tagParser);
            }
            return this;
        }

        public Builder setDateRangeParser(DateRangeParser dateRangeParser) {
            this.check();
            this.dateRangeParser = dateRangeParser;
            return this;
        }

        private void check() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        private void _addEdgeTagParser(TagParser tagParser, boolean withNamespace) {
            if (!this.em.edgeEncoders.isEmpty()) {
                throw new IllegalStateException("Avoid mixing encoded values from FlagEncoder with shared encoded values until we have a more clever mechanism, see #1862");
            }
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            tagParser.createEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                this.em.addEncodedValue(ev, withNamespace);
            }
            this.em.edgeTagParsers.add(tagParser);
        }

        private void _addRelationTagParser(RelationTagParser tagParser) {
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            tagParser.createRelationEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                ev.init(this.em.relationConfig);
            }
            this.em.relationTagParsers.add(tagParser);
            this._addEdgeTagParser(tagParser, false);
        }

        private void _addTurnCostParser(TurnCostParser parser) {
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            parser.createTurnCostEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                ev.init(this.em.turnCostConfig);
                if (this.em.encodedValueMap.containsKey(ev.getName())) {
                    throw new IllegalArgumentException("Already defined: " + ev.getName() + ". Please note that EncodedValues for edges and turn cost are in the same namespace.");
                }
                this.em.encodedValueMap.put(ev.getName(), ev);
            }
            this.em.turnCostParsers.put(parser.getName(), parser);
        }

        public EncodingManager build() {
            this.check();
            for (RelationTagParser relationTagParser : this.relationTagParsers) {
                this._addRelationTagParser(relationTagParser);
            }
            for (TagParser tagParser : this.tagParserSet) {
                this._addEdgeTagParser(tagParser, false);
            }
            for (EncodedValue encodedValue : this.encodedValueMap.values()) {
                this.em.addEncodedValue(encodedValue, false);
            }
            if (!this.em.hasEncodedValue("roundabout")) {
                this._addEdgeTagParser(new OSMRoundaboutParser(), false);
            }
            if (!this.em.hasEncodedValue("road_class")) {
                this._addEdgeTagParser(new OSMRoadClassParser(), false);
            }
            if (!this.em.hasEncodedValue("road_class_link")) {
                this._addEdgeTagParser(new OSMRoadClassLinkParser(), false);
            }
            if (!this.em.hasEncodedValue("road_environment")) {
                this._addEdgeTagParser(new OSMRoadEnvironmentParser(), false);
            }
            if (!this.em.hasEncodedValue("max_speed")) {
                this._addEdgeTagParser(new OSMMaxSpeedParser(), false);
            }
            if (!this.em.hasEncodedValue("road_access")) {
                this._addEdgeTagParser(new OSMRoadAccessParser(), false);
            }
            if (this.dateRangeParser == null) {
                this.dateRangeParser = new DateRangeParser(DateRangeParser.createCalendar());
            }
            for (AbstractFlagEncoder abstractFlagEncoder : this.flagEncoderMap.values()) {
                if (abstractFlagEncoder instanceof RoadsFlagEncoder) {
                    if (!this.em.hasEncodedValue("car_access")) {
                        this._addEdgeTagParser(new DefaultTagParserFactory().create("car_access", new PMap()), false);
                    }
                    if (this.em.hasEncodedValue("bike_access")) continue;
                    this._addEdgeTagParser(new DefaultTagParserFactory().create("bike_access", new PMap()), false);
                    continue;
                }
                if (abstractFlagEncoder instanceof BikeCommonFlagEncoder) {
                    if (!this.em.hasEncodedValue(RouteNetwork.key("bike"))) {
                        this._addRelationTagParser(new OSMBikeNetworkTagParser());
                    }
                    if (!this.em.hasEncodedValue("get_off_bike")) {
                        this._addEdgeTagParser(new OSMGetOffBikeParser(), false);
                    }
                    if (this.em.hasEncodedValue("smoothness")) continue;
                    this._addEdgeTagParser(new OSMSmoothnessParser(), false);
                    continue;
                }
                if (!(abstractFlagEncoder instanceof FootFlagEncoder) || this.em.hasEncodedValue(RouteNetwork.key("foot"))) continue;
                this._addRelationTagParser(new OSMFootNetworkTagParser());
            }
            for (AbstractFlagEncoder abstractFlagEncoder : this.flagEncoderMap.values()) {
                abstractFlagEncoder.init(this.dateRangeParser);
                this.em.addEncoder(abstractFlagEncoder);
            }
            for (TurnCostParser turnCostParser : this.turnCostParsers) {
                this._addTurnCostParser(turnCostParser);
            }
            for (AbstractFlagEncoder abstractFlagEncoder : this.flagEncoderMap.values()) {
                if (!abstractFlagEncoder.supportsTurnCosts() || this.em.turnCostParsers.containsKey(abstractFlagEncoder.toString())) continue;
                this._addTurnCostParser(new OSMTurnRelationParser(abstractFlagEncoder.toString(), abstractFlagEncoder.getMaxTurnCosts(), abstractFlagEncoder.getRestrictions()));
            }
            if (this.em.encodedValueMap.isEmpty()) {
                throw new IllegalStateException("No EncodedValues found");
            }
            EncodingManager tmp = this.em;
            this.em = null;
            return tmp;
        }
    }
}

