/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class RoadsFlagEncoder
extends AbstractFlagEncoder {
    final boolean speedTwoDirections = true;

    public RoadsFlagEncoder() {
        super(7, 2.0, 3);
        this.avgSpeedEnc = new DecimalEncodedValueImpl(EncodingManager.getKey(this.getName(), "average_speed"), this.speedBits, this.speedFactor, true);
        this.maxPossibleSpeed = this.avgSpeedEnc.getNextStorableValue(254.0);
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue) {
        super.createEncodedValues(registerNewEncodedValue);
        registerNewEncodedValue.add(this.avgSpeedEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        double speed = this.maxPossibleSpeed;
        this.accessEnc.setBool(true, edgeFlags, true);
        this.accessEnc.setBool(false, edgeFlags, true);
        this.setSpeed(false, edgeFlags, speed);
        this.setSpeed(true, edgeFlags, speed);
        return edgeFlags;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        if (way.getTag("highway", "").isEmpty()) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public TransportationMode getTransportationMode() {
        return TransportationMode.VEHICLE;
    }

    @Override
    public String getName() {
        return "roads";
    }
}

