/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.Arrays;

public enum TraversalMode {
    NODE_BASED(false),
    EDGE_BASED(true);

    private final boolean edgeBased;

    private TraversalMode(boolean edgeBased) {
        this.edgeBased = edgeBased;
    }

    public static TraversalMode fromString(String name) {
        try {
            return TraversalMode.valueOf(Helper.toUpperCase((String)name));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("TraversalMode " + name + " not supported. Supported are: " + Arrays.asList(TraversalMode.values()));
        }
    }

    public final int createTraversalId(EdgeIteratorState iterState, boolean reverse) {
        return this.createTraversalId(iterState.getBaseNode(), iterState.getAdjNode(), iterState.getEdge(), reverse);
    }

    public final int createTraversalId(int baseNode, int adjNode, int edgeId, boolean reverse) {
        if (this.edgeBased) {
            return GHUtility.createEdgeKey(baseNode, adjNode, edgeId, reverse);
        }
        return adjNode;
    }

    public boolean isEdgeBased() {
        return this.edgeBased;
    }
}

