/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class WheelchairFlagEncoder
extends FootFlagEncoder {
    private final Set<String> excludeSurfaces = new HashSet<String>();
    private final Set<String> excludeSmoothness = new HashSet<String>();
    private final int maxInclinePercent = 6;

    public WheelchairFlagEncoder() {
        this(4, 1.0);
    }

    public WheelchairFlagEncoder(PMap properties) {
        this(properties.getInt("speed_bits", 4), properties.getDouble("speed_factor", 1.0));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected WheelchairFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor, true);
        this.restrictions.add("wheelchair");
        this.barriers.add("handrail");
        this.barriers.add("wall");
        this.barriers.add("turnstile");
        this.barriers.add("kissing_gate");
        this.barriers.add("stile");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.safeHighwayTags.remove("steps");
        this.safeHighwayTags.remove("track");
        this.allowedHighwayTags.clear();
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.excludeSurfaces.add("cobblestone");
        this.excludeSurfaces.add("gravel");
        this.excludeSurfaces.add("sand");
        this.excludeSmoothness.add("bad");
        this.excludeSmoothness.add("very_bad");
        this.excludeSmoothness.add("horrible");
        this.excludeSmoothness.add("very_horrible");
        this.excludeSmoothness.add("impassable");
        this.allowedSacScale.clear();
        this.maxPossibleSpeed = this.avgSpeedEnc.getNextStorableValue(15.0);
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String tagValue;
        String sidewalk;
        if (way.hasTag("surface", this.excludeSurfaces)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":surface", this.excludeSurfaces)) {
                return EncodingManager.Access.CAN_SKIP;
            }
        }
        if (way.hasTag("smoothness", this.excludeSmoothness)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":smoothness", this.excludeSmoothness)) {
                return EncodingManager.Access.CAN_SKIP;
            }
        }
        if (way.hasTag("incline", new String[0]) && ((tagValue = way.getTag("incline")).endsWith("%") || tagValue.endsWith("\u00b0"))) {
            try {
                double incline = Double.parseDouble(tagValue.substring(0, tagValue.length() - 1));
                if (tagValue.endsWith("\u00b0")) {
                    incline = Math.tan(incline * Math.PI / 180.0) * 100.0;
                }
                if (-6.0 > incline || incline > 6.0) {
                    return EncodingManager.Access.CAN_SKIP;
                }
            }
            catch (NumberFormatException incline) {
                // empty catch block
            }
        }
        if (way.hasTag("kerb", (Object)"raised")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("kerb", new String[0]) && ((tagValue = way.getTag("kerb")).endsWith("cm") || tagValue.endsWith("mm"))) {
            try {
                int maxKerbHeightCm;
                float kerbHeight = Float.parseFloat(tagValue.substring(0, tagValue.length() - 2));
                if (tagValue.endsWith("mm")) {
                    kerbHeight /= 100.0f;
                }
                if (kerbHeight > (float)(maxKerbHeightCm = 3)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getAccess(way);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        EncodingManager.Access access = this.getAccess(way);
        if (access.canSkip()) {
            return edgeFlags;
        }
        this.accessEnc.setBool(false, edgeFlags, true);
        this.accessEnc.setBool(true, edgeFlags, true);
        if (!access.isFerry()) {
            this.setSpeed(edgeFlags, true, true, 5.0);
        } else {
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.setSpeed(edgeFlags, true, true, ferrySpeed);
        }
        Integer priorityFromRelation = (Integer)this.routeMap.get(this.footRouteEnc.getEnum(false, edgeFlags));
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
        return edgeFlags;
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
        double fullDist2D = edge.getDistance();
        if (Double.isInfinite(fullDist2D)) {
            throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
        }
        if (fullDist2D < 20.0 || !pl.is3D()) {
            return;
        }
        double prevEle = pl.getEle(0);
        double eleDelta = pl.getEle(pl.size() - 1) - prevEle;
        double elePercent = eleDelta / fullDist2D * 100.0;
        int smallInclinePercent = 3;
        double fwdSpeed = 0.0;
        double bwdSpeed = 0.0;
        if (elePercent > (double)smallInclinePercent && elePercent < 6.0) {
            fwdSpeed = 2.0;
            bwdSpeed = 5.0;
        } else if (elePercent < (double)(-smallInclinePercent) && elePercent > -6.0) {
            fwdSpeed = 5.0;
            bwdSpeed = 2.0;
        } else if (elePercent > 6.0 || elePercent < -6.0) {
            if (fullDist2D > 50.0) {
                edge.set(this.accessEnc, false, false);
            }
            fwdSpeed = 2.0;
            bwdSpeed = 2.0;
            edge.set(this.priorityWayEncoder, PriorityCode.getValue(PriorityCode.REACH_DESTINATION.getValue()));
        }
        if (fwdSpeed > 0.0 && edge.get(this.accessEnc)) {
            this.setSpeed(edge.getFlags(), true, false, fwdSpeed);
        }
        if (bwdSpeed > 0.0 && edge.getReverse(this.accessEnc)) {
            this.setSpeed(edge.getFlags(), false, true, bwdSpeed);
        }
    }

    @Override
    protected int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        weightToPrioMap.put(100.0, super.handlePriority(way, priorityFromRelation));
        if (way.hasTag("wheelchair", (Object)"designated")) {
            weightToPrioMap.put(102.0, PriorityCode.VERY_NICE.getValue());
        } else if (way.hasTag("wheelchair", (Object)"limited")) {
            weightToPrioMap.put(102.0, PriorityCode.AVOID.getValue());
        }
        return (Integer)weightToPrioMap.lastEntry().getValue();
    }

    @Override
    public String getName() {
        return "wheelchair";
    }
}

