/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.countryrules;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;

public class GermanyCountryRule
implements CountryRule {
    @Override
    public double getMaxSpeed(ReaderWay readerWay, TransportationMode transportationMode, double currentMaxSpeed) {
        if (!Double.isNaN(currentMaxSpeed) || !transportationMode.isMotorVehicle()) {
            return currentMaxSpeed;
        }
        RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
        switch (roadClass) {
            case MOTORWAY: 
            case TRUNK: {
                return 150.0;
            }
            case PRIMARY: 
            case SECONDARY: 
            case TERTIARY: 
            case UNCLASSIFIED: 
            case RESIDENTIAL: {
                return 100.0;
            }
            case LIVING_STREET: {
                return 4.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public RoadAccess getAccess(ReaderWay readerWay, TransportationMode transportationMode, RoadAccess currentRoadAccess) {
        if (currentRoadAccess != RoadAccess.YES) {
            return currentRoadAccess;
        }
        if (!transportationMode.isMotorVehicle()) {
            return RoadAccess.YES;
        }
        RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
        switch (roadClass) {
            case TRACK: {
                return RoadAccess.DESTINATION;
            }
            case PATH: 
            case BRIDLEWAY: 
            case CYCLEWAY: 
            case FOOTWAY: 
            case PEDESTRIAN: {
                return RoadAccess.NO;
            }
        }
        return RoadAccess.YES;
    }

    @Override
    public Toll getToll(ReaderWay readerWay, TransportationMode transportationMode, Toll currentToll) {
        if (!transportationMode.isMotorVehicle() || currentToll != Toll.MISSING) {
            return currentToll;
        }
        RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
        if (roadClass == RoadClass.MOTORWAY || roadClass == RoadClass.TRUNK || roadClass == RoadClass.PRIMARY) {
            return Toll.HGV;
        }
        return currentToll;
    }
}

