/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OSMAccessParser
implements TagParser {
    private final BooleanEncodedValue accessEnc;
    private final List<String> restrictions;
    private final TransportationMode transportationMode;
    private final Set<String> restrictedValues = new HashSet<String>(10);
    private final Set<String> oneways = new HashSet<String>(5);
    private final HashSet<String> oppositeLanes = new HashSet();
    private BooleanEncodedValue roundaboutEnc;
    private Set<String> intendedValues = new HashSet<String>(5);

    public OSMAccessParser(String name, List<String> restrictions, TransportationMode transportationMode) {
        this.accessEnc = new SimpleBooleanEncodedValue(name, true);
        this.restrictions = restrictions;
        this.transportationMode = transportationMode;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("delivery");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.oneways.add("yes");
        this.oneways.add("true");
        this.oneways.add("1");
        this.oneways.add("-1");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.oppositeLanes.add("opposite");
        this.oppositeLanes.add("opposite_lane");
        this.oppositeLanes.add("opposite_track");
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.accessEnc);
        this.roundaboutEnc = lookup.getBooleanEncodedValue("roundabout");
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        RoadAccess accessValue = RoadAccess.YES;
        for (String restriction : this.restrictions) {
            RoadAccess tmpAccessValue = RoadAccess.find(way.getTag(restriction, "yes"));
            if (tmpAccessValue == null || tmpAccessValue.ordinal() <= accessValue.ordinal()) continue;
            accessValue = tmpAccessValue;
        }
        CountryRule countryRule = way.getTag("country_rule", null);
        if (countryRule != null) {
            accessValue = countryRule.getAccess(way, this.transportationMode, accessValue);
        }
        boolean access = accessValue != RoadAccess.NO;
        this.accessEnc.setBool(false, edgeFlags, access);
        if (access) {
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (this.transportationMode.isMotorVehicle() && (this.isOneway(way) || isRoundabout)) {
                if (this.isForwardOneway(way)) {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
                if (this.isBackwardOneway(way)) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                }
            } else if (!(this.transportationMode != TransportationMode.BIKE || !this.isBikeOneway(way) && (!isRoundabout || way.hasTag("oneway:bicycle", (Object)"no") || way.hasTag("cycleway", this.oppositeLanes) || way.hasTag("cycleway:left", this.oppositeLanes) || way.hasTag("cycleway:right", this.oppositeLanes) || way.hasTag("cycleway:left:oneway", (Object)"-1") || way.hasTag("cycleway:right:oneway", (Object)"-1")))) {
                boolean isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("oneway:bicycle", (Object)"-1") || way.hasTag("vehicle:forward", this.restrictedValues) || way.hasTag("bicycle:forward", this.restrictedValues);
                this.accessEnc.setBool(isBackward, edgeFlags, true);
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
        }
        return edgeFlags;
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", this.restrictedValues) || way.hasTag("motor_vehicle:forward", this.restrictedValues);
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return !way.hasTag("oneway", (Object)"-1") && !way.hasTag("vehicle:forward", this.restrictedValues) && !way.hasTag("motor_vehicle:forward", this.restrictedValues);
    }

    protected boolean isOneway(ReaderWay way) {
        return way.hasTag("oneway", this.oneways) || way.hasTag("vehicle:backward", this.restrictedValues) || way.hasTag("vehicle:forward", this.restrictedValues) || way.hasTag("motor_vehicle:backward", this.restrictedValues) || way.hasTag("motor_vehicle:forward", this.restrictedValues);
    }

    boolean isBikeOneway(ReaderWay way) {
        return way.hasTag("oneway", this.oneways) && !way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:backward", this.intendedValues) || way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:forward", this.intendedValues) || way.hasTag("oneway:bicycle", this.oneways) || way.hasTag("vehicle:backward", this.restrictedValues) && !way.hasTag("bicycle:forward", this.intendedValues) || way.hasTag("vehicle:forward", this.restrictedValues) && !way.hasTag("bicycle:backward", this.intendedValues) || way.hasTag("bicycle:forward", this.restrictedValues) || way.hasTag("bicycle:backward", this.restrictedValues);
    }
}

