/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.HikeRating;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMHikeRatingParser
implements TagParser {
    private final IntEncodedValue sacScaleEnc = HikeRating.create();

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> link) {
        link.add(this.sacScaleEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String scale = readerWay.getTag("sac_scale");
        int rating = 0;
        if (scale != null) {
            if (scale.equals("hiking")) {
                rating = 1;
            } else if (scale.equals("mountain_hiking")) {
                rating = 2;
            } else if (scale.equals("demanding_mountain_hiking")) {
                rating = 3;
            } else if (scale.equals("alpine_hiking")) {
                rating = 4;
            } else if (scale.equals("demanding_alpine_hiking")) {
                rating = 5;
            } else if (scale.equals("difficult_alpine_hiking")) {
                rating = 6;
            }
        }
        if (rating != 0) {
            this.sacScaleEnc.setInt(false, edgeFlags, rating);
        }
        return edgeFlags;
    }
}

