/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMLanesParser
implements TagParser {
    private final IntEncodedValue lanesEnc = Lanes.create();

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.lanesEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        String noLanes;
        String[] noLanesTok;
        int laneCount = 1;
        if (way.hasTag("lanes", new String[0]) && (noLanesTok = (noLanes = way.getTag("lanes")).split(";|\\.")).length > 0) {
            try {
                int noLanesInt = Integer.parseInt(noLanesTok[0]);
                laneCount = noLanesInt < 0 ? 1 : (noLanesInt > 6 ? 6 : noLanesInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.lanesEnc.setInt(false, edgeFlags, laneCount);
        return edgeFlags;
    }
}

