/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class CurvatureWeighting
extends PriorityWeighting {
    private final double minFactor;
    private final DecimalEncodedValue priorityEnc;
    private final DecimalEncodedValue curvatureEnc;
    private final DecimalEncodedValue avSpeedEnc;

    public CurvatureWeighting(FlagEncoder flagEncoder, PMap pMap) {
        this(flagEncoder, pMap, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    public CurvatureWeighting(FlagEncoder flagEncoder, PMap pMap, TurnCostProvider turnCostProvider) {
        super(flagEncoder, pMap, turnCostProvider);
        this.priorityEnc = flagEncoder.getDecimalEncodedValue(EncodingManager.getKey(flagEncoder, "priority"));
        this.curvatureEnc = flagEncoder.getDecimalEncodedValue(EncodingManager.getKey(flagEncoder, "curvature"));
        this.avSpeedEnc = flagEncoder.getDecimalEncodedValue(EncodingManager.getKey(flagEncoder, "average_speed"));
        double minBendiness = 1.0;
        this.minFactor = minBendiness / Math.log(flagEncoder.getMaxSpeed()) / PriorityCode.getValue(PriorityCode.BEST.getValue());
    }

    @Override
    public double getMinWeight(double distance) {
        return this.minFactor * distance;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double priority = edgeState.get(this.priorityEnc);
        double bendiness = edgeState.get(this.curvatureEnc);
        double speed = this.getRoadSpeed(edgeState, reverse);
        double roadDistance = edgeState.getDistance();
        double regularWeight = roadDistance / Math.log(speed);
        return bendiness * regularWeight / priority;
    }

    protected double getRoadSpeed(EdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getReverse(this.avSpeedEnc) : edge.get(this.avSpeedEnc);
    }

    @Override
    public String getName() {
        return "curvature";
    }
}

