/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.DefaultEncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.util.Helper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.Visitor;

class ExpressionVisitor
implements Visitor.AtomVisitor<Boolean, Exception> {
    private final ParseResult result;
    private final EncodedValueLookup lookup;
    private final TreeMap<Integer, Replacement> replacements = new TreeMap();
    private final NameValidator nameValidator;
    private final Set<String> allowedMethods = new HashSet<String>(Arrays.asList("ordinal", "getDistance", "getName", "contains", "sqrt", "abs"));
    private String invalidMessage;
    private DefaultEncodedValueFactory factory = new DefaultEncodedValueFactory();

    public ExpressionVisitor(ParseResult result, NameValidator nameValidator, EncodedValueLookup lookup) {
        this.result = result;
        this.nameValidator = nameValidator;
        this.lookup = lookup;
    }

    boolean isValidIdentifier(String identifier) {
        if (this.nameValidator.isValid(identifier)) {
            if (!Character.isUpperCase(identifier.charAt(0))) {
                this.result.guessedVariables.add(identifier);
            }
            return true;
        }
        return false;
    }

    public Boolean visitRvalue(Java.Rvalue rv) throws Exception {
        if (rv instanceof Java.AmbiguousName) {
            Java.AmbiguousName n = (Java.AmbiguousName)rv;
            if (n.identifiers.length == 1) {
                String arg = n.identifiers[0];
                if (arg.startsWith("in_")) {
                    int start = rv.getLocation().getColumnNumber() - 1;
                    this.replacements.put(start, new Replacement(start, arg.length(), CustomWeightingHelper.class.getSimpleName() + ".in(this." + arg + ", edge)"));
                    this.result.guessedVariables.add(arg);
                    return true;
                }
                if (this.isValidIdentifier(arg)) {
                    return true;
                }
                try {
                    this.factory.create(arg);
                    this.invalidMessage = "encoded value '" + arg + "' not available";
                    return false;
                }
                catch (Exception start) {
                    // empty catch block
                }
            }
            this.invalidMessage = "identifier " + n + " invalid";
            return false;
        }
        if (rv instanceof Java.Literal) {
            return true;
        }
        if (rv instanceof Java.UnaryOperation) {
            Java.UnaryOperation uo = (Java.UnaryOperation)rv;
            if (uo.operator.equals("!")) {
                return (Boolean)uo.operand.accept((Visitor.AtomVisitor)this);
            }
            return false;
        }
        if (rv instanceof Java.MethodInvocation) {
            Java.MethodInvocation mi = (Java.MethodInvocation)rv;
            if (this.allowedMethods.contains(mi.methodName) && mi.target != null) {
                Java.AmbiguousName n = (Java.AmbiguousName)mi.target.toRvalue();
                if (n.identifiers.length == 2 && this.isValidIdentifier(n.identifiers[0])) {
                    return true;
                }
            }
            this.invalidMessage = mi.methodName + " is illegal method";
            return false;
        }
        if (rv instanceof Java.ParenthesizedExpression) {
            return (Boolean)((Java.ParenthesizedExpression)rv).value.accept((Visitor.AtomVisitor)this);
        }
        if (rv instanceof Java.BinaryOperation) {
            Java.BinaryOperation binOp = (Java.BinaryOperation)rv;
            int startRH = binOp.rhs.getLocation().getColumnNumber() - 1;
            if (binOp.lhs instanceof Java.AmbiguousName && ((Java.AmbiguousName)binOp.lhs).identifiers.length == 1) {
                boolean eqOps;
                String lhVarAsString = ((Java.AmbiguousName)binOp.lhs).identifiers[0];
                boolean bl = eqOps = binOp.operator.equals("==") || binOp.operator.equals("!=");
                if (binOp.rhs instanceof Java.StringLiteral) {
                    if (this.lookup.hasEncodedValue(lhVarAsString)) {
                        String str;
                        if (!eqOps) {
                            throw new IllegalArgumentException("Operator " + binOp.operator + " not allowed for String");
                        }
                        StringEncodedValue ev = this.lookup.getStringEncodedValue(lhVarAsString);
                        int integ = ev.indexOf((str = ((Java.StringLiteral)binOp.rhs).value).substring(1, str.length() - 1));
                        if (integ == 0) {
                            integ = -1;
                        }
                        this.replacements.put(startRH, new Replacement(startRH, str.length(), "" + integ));
                    }
                } else if (binOp.rhs instanceof Java.AmbiguousName && ((Java.AmbiguousName)binOp.rhs).identifiers.length == 1) {
                    String rhValueAsString = ((Java.AmbiguousName)binOp.rhs).identifiers[0];
                    if (this.nameValidator.isValid(lhVarAsString) && Helper.toUpperCase((String)rhValueAsString).equals(rhValueAsString)) {
                        if (!eqOps) {
                            throw new IllegalArgumentException("Operator " + binOp.operator + " not allowed for enum");
                        }
                        String value = ExpressionVisitor.toEncodedValueClassName(binOp.lhs.toString());
                        this.replacements.put(startRH, new Replacement(startRH, rhValueAsString.length(), value + "." + rhValueAsString));
                    }
                }
            }
            return (Boolean)binOp.lhs.accept((Visitor.AtomVisitor)this) != false && (Boolean)binOp.rhs.accept((Visitor.AtomVisitor)this) != false;
        }
        return false;
    }

    public Boolean visitPackage(Java.Package p) {
        return false;
    }

    public Boolean visitType(Java.Type t) {
        return false;
    }

    public Boolean visitConstructorInvocation(Java.ConstructorInvocation ci) {
        return false;
    }

    static void parseExpressions(StringBuilder expressions, NameValidator nameInConditionValidator, String exceptionInfo, Set<String> createObjects, List<Statement> list, EncodedValueLookup lookup, String lastStmt) {
        for (Statement statement : list) {
            if (statement.getKeyword() == Statement.Keyword.ELSE) {
                if (!Helper.isEmpty((String)statement.getCondition())) {
                    throw new IllegalArgumentException("expression must be empty but was " + statement.getCondition());
                }
                expressions.append("else {" + statement.getOperation().build(statement.getValue()) + "; }\n");
                continue;
            }
            if (statement.getKeyword() == Statement.Keyword.ELSEIF || statement.getKeyword() == Statement.Keyword.IF) {
                ParseResult parseResult = ExpressionVisitor.parseExpression(statement.getCondition(), nameInConditionValidator, lookup);
                if (!parseResult.ok) {
                    throw new IllegalArgumentException(exceptionInfo + " invalid expression \"" + statement.getCondition() + "\"" + (parseResult.invalidMessage == null ? "" : ": " + parseResult.invalidMessage));
                }
                createObjects.addAll(parseResult.guessedVariables);
                if (statement.getKeyword() == Statement.Keyword.ELSEIF) {
                    expressions.append("else ");
                }
                expressions.append("if (" + parseResult.converted + ") {" + statement.getOperation().build(statement.getValue()) + "; }\n");
                continue;
            }
            throw new IllegalArgumentException("The statement must be either 'if', 'else_if' or 'else'");
        }
        expressions.append(lastStmt);
    }

    static ParseResult parseExpression(String expression, NameValidator validator, EncodedValueLookup lookup) {
        ParseResult result = new ParseResult();
        try {
            Parser parser = new Parser(new Scanner("ignore", (Reader)new StringReader(expression)));
            Java.Atom atom = parser.parseConditionalExpression();
            if (parser.peek().type == TokenType.END_OF_INPUT) {
                result.guessedVariables = new LinkedHashSet<String>();
                ExpressionVisitor visitor = new ExpressionVisitor(result, validator, lookup);
                result.ok = (Boolean)atom.accept((Visitor.AtomVisitor)visitor);
                result.invalidMessage = visitor.invalidMessage;
                if (result.ok) {
                    result.converted = new StringBuilder(expression.length());
                    int start = 0;
                    for (Replacement replace : visitor.replacements.values()) {
                        result.converted.append(expression, start, replace.start).append(replace.newString);
                        start = replace.start + replace.oldLength;
                    }
                    result.converted.append(expression.substring(start));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static String toEncodedValueClassName(String arg) {
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("Cannot be empty");
        }
        if (arg.endsWith(RouteNetwork.key(""))) {
            return RouteNetwork.class.getSimpleName();
        }
        String clazz = Helper.underScoreToCamelCase((String)arg);
        return Character.toUpperCase(clazz.charAt(0)) + clazz.substring(1);
    }

    class Replacement {
        int start;
        int oldLength;
        String newString;

        public Replacement(int start, int oldLength, String newString) {
            this.start = start;
            this.oldLength = oldLength;
            this.newString = newString;
        }
    }

    static interface NameValidator {
        public boolean isValid(String var1);
    }

    static class ParseResult {
        StringBuilder converted;
        boolean ok;
        String invalidMessage;
        Set<String> guessedVariables;

        ParseResult() {
        }
    }
}

