/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.search;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringIndex {
    private static final long EMPTY_POINTER = 0L;
    private static final long START_POINTER = 1L;
    static final int MAX_UNIQUE_KEYS = 32768;
    private static final int MAX_LENGTH = 255;
    boolean throwExceptionIfTooLong = false;
    private final DataAccess keys;
    private final DataAccess vals;
    private final Map<String, Integer> keysInMem = new LinkedHashMap<String, Integer>();
    private final List<String> keyList = new ArrayList<String>();
    private final Map<String, Long> smallCache;
    private long bytePointer = 1L;
    private long lastEntryPointer = -1L;
    private Map<String, String> lastEntryMap;

    public StringIndex(Directory dir, final int cacheSize, int segmentSize) {
        this.keys = dir.create("string_index_keys", segmentSize);
        this.vals = dir.create("string_index_vals", segmentSize);
        this.smallCache = new LinkedHashMap<String, Long>(cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Long> entry) {
                return this.size() > cacheSize;
            }
        };
    }

    public StringIndex create(long initBytes) {
        this.keys.create(initBytes);
        this.vals.create(initBytes);
        this.keysInMem.put("", 0);
        this.keyList.add("");
        return this;
    }

    public boolean loadExisting() {
        if (this.vals.loadExisting()) {
            if (!this.keys.loadExisting()) {
                throw new IllegalStateException("Loaded values but cannot load keys");
            }
            int stringIndexKeysVersion = this.keys.getHeader(0);
            int stringIndexValsVersion = this.vals.getHeader(0);
            GHUtility.checkDAVersion(this.keys.getName(), 6, stringIndexKeysVersion);
            GHUtility.checkDAVersion(this.vals.getName(), 6, stringIndexValsVersion);
            this.bytePointer = BitUtil.LITTLE.combineIntsToLong(this.vals.getHeader(4), this.vals.getHeader(8));
            int count = this.keys.getShort(0L);
            long keyBytePointer = 2L;
            for (int i = 0; i < count; ++i) {
                short keyLength = this.keys.getShort(keyBytePointer);
                byte[] keyBytes = new byte[keyLength];
                this.keys.getBytes(keyBytePointer += 2L, keyBytes, keyLength);
                String valueStr = new String(keyBytes, Helper.UTF_CS);
                this.keysInMem.put(valueStr, this.keysInMem.size());
                this.keyList.add(valueStr);
                keyBytePointer += (long)keyLength;
            }
            return true;
        }
        return false;
    }

    Set<String> getKeys() {
        return this.keysInMem.keySet();
    }

    public long add(Map<String, String> entryMap) {
        if (entryMap.isEmpty()) {
            return 0L;
        }
        if (entryMap.size() > 200) {
            throw new IllegalArgumentException("Cannot store more than 200 entries per entry");
        }
        if (entryMap.equals(this.lastEntryMap)) {
            return this.lastEntryPointer;
        }
        this.lastEntryMap = entryMap;
        this.lastEntryPointer = this.bytePointer;
        long currentPointer = this.bytePointer;
        this.vals.ensureCapacity(currentPointer + 1L);
        this.vals.setByte(currentPointer, (byte)entryMap.size());
        ++currentPointer;
        for (Map.Entry<String, String> entry : entryMap.entrySet()) {
            byte[] valueBytes;
            String key = entry.getKey();
            String value = entry.getValue();
            Integer keyIndex = this.keysInMem.get(key);
            if (keyIndex == null) {
                keyIndex = this.keysInMem.size();
                if (keyIndex >= 32768) {
                    throw new IllegalArgumentException("Cannot store more than 32768 unique keys");
                }
                this.keysInMem.put(key, keyIndex);
                this.keyList.add(key);
            }
            if (value == null || value.isEmpty()) {
                this.vals.ensureCapacity(currentPointer + 3L);
                this.vals.setShort(currentPointer, keyIndex.shortValue());
                this.vals.setByte(currentPointer + 2L, (byte)0);
                currentPointer += 3L;
                continue;
            }
            Long existingRef = this.smallCache.get(value);
            if (existingRef != null) {
                long delta = this.lastEntryPointer - existingRef;
                if (delta < Integer.MAX_VALUE && delta > Integer.MIN_VALUE) {
                    this.vals.ensureCapacity(currentPointer + 2L + 4L);
                    this.vals.setShort(currentPointer, (short)(-keyIndex.intValue()));
                    byte[] valueBytes2 = new byte[4];
                    BitUtil.LITTLE.fromInt(valueBytes2, (int)delta);
                    this.vals.setBytes(currentPointer += 2L, valueBytes2, valueBytes2.length);
                    currentPointer += (long)valueBytes2.length;
                    continue;
                }
                this.smallCache.remove(value);
            }
            if ((valueBytes = this.getBytesForString("Value for key" + key, value)).length > 3) {
                this.smallCache.put(value, currentPointer);
            }
            this.vals.ensureCapacity(currentPointer + 2L + 1L + (long)valueBytes.length);
            this.vals.setShort(currentPointer, keyIndex.shortValue());
            this.vals.setByte(currentPointer += 2L, (byte)valueBytes.length);
            this.vals.setBytes(++currentPointer, valueBytes, valueBytes.length);
            currentPointer += (long)valueBytes.length;
        }
        this.bytePointer = currentPointer;
        return this.lastEntryPointer;
    }

    public Map<String, String> getAll(long entryPointer) {
        if (entryPointer < 0L) {
            throw new IllegalStateException("Pointer to access StringIndex cannot be negative:" + entryPointer);
        }
        if (entryPointer == 0L) {
            return Collections.emptyMap();
        }
        int keyCount = this.vals.getByte(entryPointer) & 0xFF;
        if (keyCount == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(keyCount);
        long tmpPointer = entryPointer + 1L;
        for (int i = 0; i < keyCount; ++i) {
            short currentKeyIndex = this.vals.getShort(tmpPointer);
            tmpPointer += 2L;
            if (currentKeyIndex < 0) {
                currentKeyIndex = -currentKeyIndex;
                byte[] valueBytes = new byte[4];
                this.vals.getBytes(tmpPointer, valueBytes, valueBytes.length);
                tmpPointer += 4L;
                long dupPointer = entryPointer - (long)BitUtil.LITTLE.toInt(valueBytes);
                if ((dupPointer += 2L) > this.bytePointer) {
                    throw new IllegalStateException("dup marker should exist but points into not yet allocated area " + dupPointer + " > " + this.bytePointer);
                }
                this.putIntoMap(map, dupPointer, currentKeyIndex);
                continue;
            }
            int valueLength = this.putIntoMap(map, tmpPointer, currentKeyIndex);
            tmpPointer += (long)(1 + valueLength);
        }
        return map;
    }

    private int putIntoMap(Map<String, String> map, long tmpPointer, int currentKeyIndex) {
        String valueStr;
        int valueLength = this.vals.getByte(tmpPointer) & 0xFF;
        ++tmpPointer;
        if (valueLength == 0) {
            valueStr = "";
        } else {
            byte[] valueBytes = new byte[valueLength];
            this.vals.getBytes(tmpPointer, valueBytes, valueBytes.length);
            valueStr = new String(valueBytes, Helper.UTF_CS);
        }
        map.put(this.keyList.get(currentKeyIndex), valueStr);
        return valueLength;
    }

    public String get(long entryPointer, String key) {
        if (entryPointer < 0L) {
            throw new IllegalStateException("Pointer to access StringIndex cannot be negative:" + entryPointer);
        }
        if (entryPointer == 0L) {
            return "";
        }
        int keyCount = this.vals.getByte(entryPointer) & 0xFF;
        if (keyCount == 0) {
            return null;
        }
        Integer keyIndex = this.keysInMem.get(key);
        if (keyIndex == null) {
            return null;
        }
        long tmpPointer = entryPointer + 1L;
        for (int i = 0; i < keyCount; ++i) {
            short currentKeyIndex = this.vals.getShort(tmpPointer);
            tmpPointer += 2L;
            if (Math.abs(currentKeyIndex) == keyIndex) {
                int valueLength;
                if (currentKeyIndex < 0) {
                    byte[] valueBytes = new byte[4];
                    this.vals.getBytes(tmpPointer, valueBytes, valueBytes.length);
                    tmpPointer = entryPointer - (long)BitUtil.LITTLE.toInt(valueBytes);
                    if ((tmpPointer += 2L) > this.bytePointer) {
                        throw new IllegalStateException("dup marker " + this.bytePointer + " should exist but points into not yet allocated area " + tmpPointer);
                    }
                }
                if ((valueLength = this.vals.getByte(tmpPointer) & 0xFF) == 0) {
                    return "";
                }
                byte[] valueBytes = new byte[valueLength];
                this.vals.getBytes(++tmpPointer, valueBytes, valueBytes.length);
                return new String(valueBytes, Helper.UTF_CS);
            }
            int valueLength = this.vals.getByte(tmpPointer) & 0xFF;
            tmpPointer += (long)(1 + valueLength);
        }
        return null;
    }

    private byte[] getBytesForString(String info, String name) {
        byte[] bytes = name.getBytes(Helper.UTF_CS);
        if (bytes.length > 255) {
            String newString = new String(bytes, 0, 255, Helper.UTF_CS);
            if (this.throwExceptionIfTooLong) {
                throw new IllegalStateException(info + " is too long: " + name + " truncated to " + newString);
            }
            return newString.getBytes(Helper.UTF_CS);
        }
        return bytes;
    }

    public void flush() {
        this.keys.setHeader(0, 6);
        this.keys.ensureCapacity(2L);
        this.keys.setShort(0L, (short)this.keysInMem.size());
        long keyBytePointer = 2L;
        for (String key : this.keysInMem.keySet()) {
            byte[] keyBytes = this.getBytesForString("key", key);
            this.keys.ensureCapacity(keyBytePointer + 2L + (long)keyBytes.length);
            this.keys.setShort(keyBytePointer, (short)keyBytes.length);
            this.keys.setBytes(keyBytePointer += 2L, keyBytes, keyBytes.length);
            keyBytePointer += (long)keyBytes.length;
        }
        this.keys.flush();
        this.vals.setHeader(0, 6);
        this.vals.setHeader(4, BitUtil.LITTLE.getIntLow(this.bytePointer));
        this.vals.setHeader(8, BitUtil.LITTLE.getIntHigh(this.bytePointer));
        this.vals.flush();
    }

    public void close() {
        this.keys.close();
        this.vals.close();
    }

    public boolean isClosed() {
        return this.vals.isClosed() && this.keys.isClosed();
    }

    public long getCapacity() {
        return this.vals.getCapacity() + this.keys.getCapacity();
    }
}

