/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.RAMDirectory;

public class GraphBuilder {
    private final EncodingManager encodingManager;
    private Directory dir = new RAMDirectory();
    private boolean elevation;
    private boolean turnCosts;
    private long bytes = 100L;
    private int segmentSize = -1;

    public static GraphBuilder start(EncodingManager encodingManager) {
        return new GraphBuilder(encodingManager);
    }

    public GraphBuilder(EncodingManager encodingManager) {
        this.encodingManager = encodingManager;
        this.turnCosts = encodingManager.needsTurnCostsSupport();
    }

    public GraphBuilder setDir(Directory dir) {
        this.dir = dir;
        return this;
    }

    public GraphBuilder setMMap(String location) {
        return this.setDir(new MMapDirectory(location));
    }

    public GraphBuilder setRAM() {
        return this.setDir(new RAMDirectory());
    }

    public GraphBuilder setRAM(String location) {
        return this.setDir(new RAMDirectory(location));
    }

    public GraphBuilder setRAM(String location, boolean store) {
        return this.setDir(new RAMDirectory(location, store));
    }

    public GraphBuilder set3D(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GraphBuilder withTurnCosts(boolean turnCosts) {
        this.turnCosts = turnCosts;
        return this;
    }

    public GraphBuilder setSegmentSize(int segmentSize) {
        this.segmentSize = segmentSize;
        return this;
    }

    public GraphHopperStorage build() {
        return new GraphHopperStorage(this.dir, this.encodingManager, this.elevation, this.turnCosts, this.segmentSize);
    }

    public GraphHopperStorage create() {
        return this.build().create(this.bytes);
    }
}

