/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.BBox;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphHopperStorage
implements Graph,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperStorage.class);
    private final Directory dir;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;
    private final BaseGraph baseGraph;
    private final int segmentSize;

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, boolean withTurnCosts, int segmentSize) {
        if (encodingManager == null) {
            throw new IllegalArgumentException("EncodingManager needs to be non-null since 0.7. Create one using EncodingManager.create or EncodingManager.create(flagEncoderFactory, ghLocation)");
        }
        this.encodingManager = encodingManager;
        this.dir = dir;
        this.properties = new StorableProperties(dir);
        this.segmentSize = segmentSize;
        this.baseGraph = new BaseGraph(dir, encodingManager.getIntsForFlags(), withElevation, withTurnCosts, segmentSize);
    }

    public CHStorage createCHStorage(CHConfig chConfig) {
        return this.createCHStorage(chConfig.getName(), chConfig.isEdgeBased());
    }

    public CHStorage createCHStorage(String name, boolean edgeBased) {
        if (!this.isFrozen()) {
            throw new IllegalStateException("graph must be frozen before we can create ch graphs");
        }
        CHStorage store = new CHStorage(this.dir, name, this.segmentSize, edgeBased);
        store.setLowShortcutWeightConsumer(s -> {
            NodeAccess nodeAccess = this.baseGraph.getNodeAccess();
            LOGGER.warn("Setting weights smaller than " + s.minWeight + " is not allowed. You passed: " + s.weight + " for the shortcut  nodeA (" + nodeAccess.getLat(s.nodeA) + "," + nodeAccess.getLon(s.nodeA) + " nodeB " + nodeAccess.getLat(s.nodeB) + "," + nodeAccess.getLon(s.nodeB));
        });
        store.create();
        double expectedShortcuts = 0.3 * (double)this.baseGraph.getEdges();
        store.init(this.baseGraph.getNodes(), (int)expectedShortcuts);
        return store;
    }

    public CHStorage loadCHStorage(String chGraphName, boolean edgeBased) {
        CHStorage store = new CHStorage(this.dir, chGraphName, this.segmentSize, edgeBased);
        return store.loadExisting() ? store : null;
    }

    public RoutingCHGraph createCHGraph(CHStorage store, CHConfig chConfig) {
        return new RoutingCHGraphImpl(this.baseGraph, store, chConfig.getWeighting());
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public GraphHopperStorage create(long byteCount) {
        this.baseGraph.checkNotInitialized();
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager can only be null if you call loadExisting");
        }
        this.dir.create();
        this.properties.create(100L);
        this.properties.put("graph.encoded_values", this.encodingManager.toEncodedValuesAsString());
        this.properties.put("graph.flag_encoders", this.encodingManager.toFlagEncodersAsString());
        this.baseGraph.create(Math.max(byteCount, 100L));
        return this;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public StorableProperties getProperties() {
        return this.properties;
    }

    public boolean loadExisting() {
        this.baseGraph.checkNotInitialized();
        if (this.properties.loadExisting()) {
            if (this.properties.containsVersion()) {
                throw new IllegalStateException("The GraphHopper file format is not compatible with the data you are trying to load. You either need to use an older version of GraphHopper or run a new import");
            }
            String flagEncodersStr = this.properties.get("graph.flag_encoders");
            if (!this.encodingManager.toFlagEncodersAsString().equalsIgnoreCase(flagEncodersStr)) {
                throw new IllegalStateException("Encoding does not match:\nGraphhopper config: " + this.encodingManager.toFlagEncodersAsString() + "\nGraph: " + flagEncodersStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String encodedValueStr = this.properties.get("graph.encoded_values");
            if (!this.encodingManager.toEncodedValuesAsString().equalsIgnoreCase(encodedValueStr)) {
                throw new IllegalStateException("Encoded values do not match:\nGraphhopper config: " + this.encodingManager.toEncodedValuesAsString() + "\nGraph: " + encodedValueStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            this.baseGraph.loadExisting();
            return true;
        }
        return false;
    }

    public void flush() {
        this.baseGraph.flush();
        this.properties.flush();
    }

    @Override
    public void close() {
        this.properties.close();
        this.baseGraph.close();
    }

    public boolean isClosed() {
        return this.baseGraph.isClosed();
    }

    public long getCapacity() {
        return this.baseGraph.getCapacity() + this.properties.getCapacity();
    }

    public synchronized void freeze() {
        if (this.isFrozen()) {
            return;
        }
        this.baseGraph.freeze();
    }

    public boolean isFrozen() {
        return this.baseGraph.isFrozen();
    }

    public String toDetailsString() {
        return this.baseGraph.toDetailsString();
    }

    public String toString() {
        return this.encodingManager + "|" + this.getDirectory().getDefaultType() + "|" + this.baseGraph.nodeAccess.getDimension() + "D|" + (this.baseGraph.supportsTurnCosts() ? this.baseGraph.turnCostStorage : "no_turn_cost") + "|" + this.getVersionsString();
    }

    private String getVersionsString() {
        return "nodes:9,edges:21,geometry:6,location_index:5,string_index:6,nodesCH:0,shortcuts:8";
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        return this.baseGraph.edge(a, b);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        return this.baseGraph.getEdgeIteratorState(edgeId, adjNode);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorStateForKey(int edgeKey) {
        return this.baseGraph.getEdgeIteratorStateForKey(edgeKey);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return this.baseGraph.getAllEdges();
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.baseGraph.getTurnCostStorage();
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return weighting;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    public void flushAndCloseGeometryAndNameStorage() {
        this.baseGraph.flushAndCloseGeometryAndNameStorage();
    }
}

