/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIteratorImpl;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHEdgeIteratorStateImpl;
import com.graphhopper.storage.RoutingCHGraph;

public class RoutingCHGraphImpl
implements RoutingCHGraph {
    private final BaseGraph baseGraph;
    private final CHStorage chStorage;
    private final Weighting weighting;

    public RoutingCHGraphImpl(BaseGraph baseGraph, CHStorage chStorage, Weighting weighting) {
        if (weighting.hasTurnCosts() && !chStorage.isEdgeBased()) {
            throw new IllegalArgumentException("Weighting has turn costs, but CHStorage is node-based");
        }
        this.baseGraph = baseGraph;
        this.chStorage = chStorage;
        this.weighting = weighting;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges() + this.chStorage.getShortcuts();
    }

    @Override
    public int getShortcuts() {
        return this.chStorage.getShortcuts();
    }

    @Override
    public RoutingCHEdgeExplorer createInEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.inEdges(this.chStorage, this.baseGraph, this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createOutEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.outEdges(this.chStorage, this.baseGraph, this.weighting);
    }

    @Override
    public RoutingCHEdgeIteratorState getEdgeIteratorState(int chEdge, int adjNode) {
        RoutingCHEdgeIteratorStateImpl edgeState = new RoutingCHEdgeIteratorStateImpl(this.chStorage, this.baseGraph, new BaseGraph.EdgeIteratorStateImpl(this.baseGraph), this.weighting);
        if (edgeState.init(chEdge, adjNode)) {
            return edgeState;
        }
        return null;
    }

    @Override
    public int getLevel(int node) {
        return this.chStorage.getLevel(this.chStorage.toNodePointer(node));
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Weighting getWeighting() {
        return this.weighting;
    }

    @Override
    public boolean hasTurnCosts() {
        return this.weighting.hasTurnCosts();
    }

    @Override
    public boolean isEdgeBased() {
        return this.chStorage.isEdgeBased();
    }

    @Override
    public double getTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        return this.weighting.calcTurnWeight(edgeFrom, nodeVia, edgeTo);
    }

    @Override
    public void close() {
        if (!this.baseGraph.isClosed()) {
            this.baseGraph.close();
        }
        this.chStorage.close();
    }
}

