/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIterator;

public class TurnCostStorage {
    static final int NO_TURN_ENTRY = -1;
    private static final int EMPTY_FLAGS = 0;
    private static final int TC_FROM = 0;
    private static final int TC_TO = 4;
    private static final int TC_FLAGS = 8;
    private static final int TC_NEXT = 12;
    private static final int BYTES_PER_ENTRY = 16;
    private BaseGraph baseGraph;
    private DataAccess turnCosts;
    private int turnCostsCount;

    public TurnCostStorage(BaseGraph baseGraph, DataAccess turnCosts) {
        this.baseGraph = baseGraph;
        this.turnCosts = turnCosts;
    }

    public TurnCostStorage create(long initBytes) {
        this.turnCosts.create(initBytes);
        return this;
    }

    public void flush() {
        this.turnCosts.setHeader(0, 16);
        this.turnCosts.setHeader(4, this.turnCostsCount);
        this.turnCosts.flush();
    }

    public void close() {
        this.turnCosts.close();
    }

    public long getCapacity() {
        return this.turnCosts.getCapacity();
    }

    public boolean loadExisting() {
        if (!this.turnCosts.loadExisting()) {
            return false;
        }
        if (this.turnCosts.getHeader(0) != 16) {
            throw new IllegalStateException("Number of bytes per turn cost entry does not match the current configuration: " + this.turnCosts.getHeader(0) + " vs. " + 16);
        }
        this.turnCostsCount = this.turnCosts.getHeader(4);
        return true;
    }

    public void set(DecimalEncodedValue turnCostEnc, int fromEdge, int viaNode, int toEdge, double cost) {
        IntsRef tcFlags = TurnCost.createFlags();
        turnCostEnc.setDecimal(false, tcFlags, cost);
        this.merge(tcFlags, fromEdge, viaNode, toEdge);
    }

    private void merge(IntsRef tcFlags, int fromEdge, int viaNode, int toEdge) {
        long costsBase;
        int newEntryIndex = this.turnCostsCount;
        this.ensureTurnCostIndex(newEntryIndex);
        boolean oldEntryFound = false;
        int newFlags = tcFlags.ints[0];
        int next = -1;
        int previousEntryIndex = this.baseGraph.getNodeAccess().getTurnCostIndex(viaNode);
        if (previousEntryIndex == -1) {
            this.baseGraph.getNodeAccess().setTurnCostIndex(viaNode, newEntryIndex);
        } else {
            int i = 0;
            next = this.turnCosts.getInt((long)previousEntryIndex * 16L + 12L);
            int existingFlags = 0;
            while (true) {
                long costsIdx;
                if (fromEdge == this.turnCosts.getInt((costsIdx = (long)previousEntryIndex * 16L) + 0L) && toEdge == this.turnCosts.getInt(costsIdx + 4L)) {
                    oldEntryFound = true;
                    existingFlags = this.turnCosts.getInt(costsIdx + 8L);
                    break;
                }
                if (next == -1) break;
                previousEntryIndex = next;
                if (i++ > 1000) {
                    throw new IllegalStateException("Something unexpected happened. A node probably will not have 1000+ relations.");
                }
                next = this.turnCosts.getInt((long)next * 16L + 12L);
            }
            if (!oldEntryFound) {
                this.turnCosts.setInt((long)previousEntryIndex * 16L + 12L, newEntryIndex);
            } else {
                newFlags = existingFlags | newFlags;
            }
        }
        if (!oldEntryFound) {
            costsBase = (long)newEntryIndex * 16L;
            ++this.turnCostsCount;
        } else {
            costsBase = (long)previousEntryIndex * 16L;
        }
        this.turnCosts.setInt(costsBase + 0L, fromEdge);
        this.turnCosts.setInt(costsBase + 4L, toEdge);
        this.turnCosts.setInt(costsBase + 8L, newFlags);
        this.turnCosts.setInt(costsBase + 12L, next);
    }

    public double get(DecimalEncodedValue turnCostEnc, int fromEdge, int viaNode, int toEdge) {
        IntsRef flags = this.readFlags(fromEdge, viaNode, toEdge);
        return turnCostEnc.getDecimal(false, flags);
    }

    private IntsRef readFlags(int fromEdge, int viaNode, int toEdge) {
        if (!EdgeIterator.Edge.isValid(fromEdge) || !EdgeIterator.Edge.isValid(toEdge)) {
            throw new IllegalArgumentException("from and to edge cannot be NO_EDGE");
        }
        if (viaNode < 0) {
            throw new IllegalArgumentException("via node cannot be negative");
        }
        IntsRef flags = TurnCost.createFlags();
        this.readFlags(flags, fromEdge, viaNode, toEdge);
        return flags;
    }

    private void readFlags(IntsRef tcFlags, int fromEdge, int viaNode, int toEdge) {
        int i;
        int turnCostIndex = this.baseGraph.getNodeAccess().getTurnCostIndex(viaNode);
        for (i = 0; i < 1000 && turnCostIndex != -1; ++i) {
            long turnCostPtr = (long)turnCostIndex * 16L;
            if (fromEdge == this.turnCosts.getInt(turnCostPtr + 0L) && toEdge == this.turnCosts.getInt(turnCostPtr + 4L)) {
                tcFlags.ints[0] = this.turnCosts.getInt(turnCostPtr + 8L);
                return;
            }
            int nextTurnCostIndex = this.turnCosts.getInt(turnCostPtr + 12L);
            if (nextTurnCostIndex == turnCostIndex) {
                throw new IllegalStateException("something went wrong: next entry would be the same");
            }
            turnCostIndex = nextTurnCostIndex;
        }
        if (i >= 1000) {
            throw new IllegalStateException("something went wrong: there seems to be no end of the turn cost-list!?");
        }
        tcFlags.ints[0] = 0;
    }

    private void ensureTurnCostIndex(int nodeIndex) {
        this.turnCosts.ensureCapacity(((long)nodeIndex + 4L) * 16L);
    }

    public boolean isClosed() {
        return this.turnCosts.isClosed();
    }

    public String toString() {
        return "turn_cost";
    }

    public TurnRelationIterator getAllTurnRelations() {
        return new Itr();
    }

    private class Itr
    implements TurnRelationIterator {
        private int viaNode = -1;
        private int turnCostIndex = -1;
        private final IntsRef intsRef = TurnCost.createFlags();

        private Itr() {
        }

        private long turnCostPtr() {
            return (long)this.turnCostIndex * 16L;
        }

        @Override
        public int getFromEdge() {
            return TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 0L);
        }

        @Override
        public int getViaNode() {
            return this.viaNode;
        }

        @Override
        public int getToEdge() {
            return TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 4L);
        }

        @Override
        public double getCost(DecimalEncodedValue encodedValue) {
            this.intsRef.ints[0] = TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 8L);
            return encodedValue.getDecimal(false, this.intsRef);
        }

        @Override
        public boolean next() {
            boolean gotNextTci = this.nextTci();
            if (!gotNextTci) {
                this.turnCostIndex = -1;
                boolean gotNextNode = true;
                while (this.turnCostIndex == -1 && (gotNextNode = this.nextNode())) {
                }
                if (!gotNextNode) {
                    return false;
                }
            }
            return true;
        }

        private boolean nextNode() {
            ++this.viaNode;
            if (this.viaNode >= TurnCostStorage.this.baseGraph.getNodes()) {
                return false;
            }
            this.turnCostIndex = TurnCostStorage.this.baseGraph.getNodeAccess().getTurnCostIndex(this.viaNode);
            return true;
        }

        private boolean nextTci() {
            if (this.turnCostIndex == -1) {
                return false;
            }
            this.turnCostIndex = TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 12L);
            return this.turnCostIndex != -1;
        }
    }

    public static interface TurnRelationIterator {
        public int getFromEdge();

        public int getViaNode();

        public int getToEdge();

        public double getCost(DecimalEncodedValue var1);

        public boolean next();
    }
}

