/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.HGTProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.OSMReaderConfig;
import com.graphhopper.routing.Router;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHPreparationHandler;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DefaultEncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.BikeCommonTagParser;
import com.graphhopper.routing.util.CurvatureCalculator;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.DefaultVehicleEncodedValuesFactory;
import com.graphhopper.routing.util.DefaultVehicleTagParserFactory;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FootTagParser;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.SlopeCalculator;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.UrbanDensityCalculator;
import com.graphhopper.routing.util.VehicleEncodedValuesFactory;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.VehicleTagParserFactory;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.DefaultTagParserFactory;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMFootNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMGetOffBikeParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.Constants;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopper.class);
    private final Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
    private final String fileLockName = "gh.lock";
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    private CountryRuleFactory countryRuleFactory = null;
    private String customAreasDirectory = "";
    private BaseGraph baseGraph;
    private StorableProperties properties;
    private EncodingManager encodingManager;
    private OSMParsers osmParsers;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessDefaultType = DAType.RAM_STORE;
    private final LinkedHashMap<String, String> dataAccessConfig = new LinkedHashMap();
    private boolean sortGraph = false;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private boolean fullyLoaded = false;
    private final OSMReaderConfig osmReaderConfig = new OSMReaderConfig();
    private final RouterConfig routerConfig = new RouterConfig();
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private double residentialAreaRadius = 300.0;
    private double residentialAreaSensitivity = 60.0;
    private double cityAreaRadius = 2000.0;
    private double cityAreaSensitivity = 30.0;
    private int urbanDensityCalculationThreads = 0;
    private final LMPreparationHandler lmPreparationHandler = new LMPreparationHandler();
    private final CHPreparationHandler chPreparationHandler = new CHPreparationHandler();
    private Map<String, RoutingCHGraph> chGraphs = Collections.emptyMap();
    private Map<String, LandmarkStorage> landmarks = Collections.emptyMap();
    private String osmFile;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private VehicleEncodedValuesFactory vehicleEncodedValuesFactory = new DefaultVehicleEncodedValuesFactory();
    private VehicleTagParserFactory vehicleTagParserFactory = new DefaultVehicleTagParserFactory();
    private EncodedValueFactory encodedValueFactory = new DefaultEncodedValueFactory();
    private TagParserFactory tagParserFactory = new DefaultTagParserFactory();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();
    private String dateRangeParserString = "";
    private String encodedValuesString = "";
    private String vehiclesString = "";

    public GraphHopper setEncodedValuesString(String encodedValuesString) {
        this.encodedValuesString = encodedValuesString;
        return this;
    }

    public GraphHopper setVehiclesString(String vehiclesString) {
        this.vehiclesString = vehiclesString;
        return this;
    }

    public EncodingManager getEncodingManager() {
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager not yet built");
        }
        return this.encodingManager;
    }

    public OSMParsers getOSMParsers() {
        if (this.osmParsers == null) {
            throw new IllegalStateException("OSMParsers not yet built");
        }
        return this.osmParsers;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize) {
        this.ensureNotLoaded();
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public GraphHopper setUrbanDensityCalculation(double residentialAreaRadius, double residentialAreaSensitivity, double cityAreaRadius, double cityAreaSensitivity, int threads) {
        this.ensureNotLoaded();
        this.residentialAreaRadius = residentialAreaRadius;
        this.residentialAreaSensitivity = residentialAreaSensitivity;
        this.cityAreaRadius = cityAreaRadius;
        this.cityAreaSensitivity = cityAreaSensitivity;
        this.urbanDensityCalculationThreads = threads;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessDefaultType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setProfiles(Profile ... profiles) {
        return this.setProfiles(Arrays.asList(profiles));
    }

    public GraphHopper setProfiles(List<Profile> profiles) {
        if (!this.profilesByName.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize profiles multiple times");
        }
        if (this.encodingManager != null) {
            throw new IllegalArgumentException("Cannot set profiles after EncodingManager was built");
        }
        for (Profile profile : profiles) {
            Profile previous = this.profilesByName.put(profile.getName(), profile);
            if (previous == null) continue;
            throw new IllegalArgumentException("Profile names must be unique. Duplicate name: '" + profile.getName() + "'");
        }
        return this;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public Profile getProfile(String profileName) {
        return this.profilesByName.get(profileName);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getOSMFile() {
        return this.osmFile;
    }

    public GraphHopper setOSMFile(String osmFile) {
        this.ensureNotLoaded();
        if (Helper.isEmpty((String)osmFile)) {
            throw new IllegalArgumentException("OSM file cannot be empty.");
        }
        this.osmFile = osmFile;
        return this;
    }

    public BaseGraph getBaseGraph() {
        if (this.baseGraph == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.baseGraph;
    }

    public void setBaseGraph(BaseGraph baseGraph) {
        this.baseGraph = baseGraph;
        this.setFullyLoaded();
    }

    public StorableProperties getProperties() {
        return this.properties;
    }

    public Map<String, RoutingCHGraph> getCHGraphs() {
        return this.chGraphs;
    }

    public Map<String, LandmarkStorage> getLandmarks() {
        return this.landmarks;
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("LocationIndex not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.ensureNotLoaded();
        this.sortGraph = sortGraph;
        return this;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setVehicleEncodedValuesFactory(VehicleEncodedValuesFactory factory) {
        this.vehicleEncodedValuesFactory = factory;
        return this;
    }

    public EncodedValueFactory getEncodedValueFactory() {
        return this.encodedValueFactory;
    }

    public GraphHopper setEncodedValueFactory(EncodedValueFactory factory) {
        this.encodedValueFactory = factory;
        return this;
    }

    public VehicleTagParserFactory getVehicleTagParserFactory() {
        return this.vehicleTagParserFactory;
    }

    public GraphHopper setVehicleTagParserFactory(VehicleTagParserFactory factory) {
        this.vehicleTagParserFactory = factory;
        return this;
    }

    public TagParserFactory getTagParserFactory() {
        return this.tagParserFactory;
    }

    public GraphHopper setTagParserFactory(TagParserFactory factory) {
        this.tagParserFactory = factory;
        return this;
    }

    public GraphHopper setCustomAreasDirectory(String customAreasDirectory) {
        this.customAreasDirectory = customAreasDirectory;
        return this;
    }

    public String getCustomAreasDirectory() {
        return this.customAreasDirectory;
    }

    public GraphHopper setCountryRuleFactory(CountryRuleFactory countryRuleFactory) {
        this.countryRuleFactory = countryRuleFactory;
        return this;
    }

    public CountryRuleFactory getCountryRuleFactory() {
        return this.countryRuleFactory;
    }

    public GraphHopper init(GraphHopperConfig ghConfig) {
        String graphHopperFolder;
        this.ensureNotLoaded();
        if (ghConfig.has("routing.ch.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.ch.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("routing.lm.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.lm.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead of osmreader.osm use datareader.file, for other changes see CHANGELOG.md");
        }
        String tmpOsmFile = ghConfig.getString("datareader.file", "");
        if (!Helper.isEmpty((String)tmpOsmFile)) {
            this.osmFile = tmpOsmFile;
        }
        if (Helper.isEmpty((String)(graphHopperFolder = ghConfig.getString("graph.location", ""))) && Helper.isEmpty((String)this.ghLocation)) {
            if (Helper.isEmpty((String)this.osmFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = Helper.pruneFileEnd((String)this.osmFile) + "-gh";
        }
        this.ghLocation = graphHopperFolder;
        this.countryRuleFactory = ghConfig.getBool("country_rules.enabled", false) ? new CountryRuleFactory() : null;
        this.customAreasDirectory = ghConfig.getString("custom_areas.directory", this.customAreasDirectory);
        this.defaultSegmentSize = ghConfig.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String daTypeString = ghConfig.getString("graph.dataaccess.default_type", ghConfig.getString("graph.dataaccess", "RAM_STORE"));
        this.dataAccessDefaultType = DAType.fromString(daTypeString);
        for (Map.Entry entry : ghConfig.asPMap().toMap().entrySet()) {
            if (((String)entry.getKey()).startsWith("graph.dataaccess.type.")) {
                this.dataAccessConfig.put(((String)entry.getKey()).substring("graph.dataaccess.type.".length()), entry.getValue().toString());
            }
            if (!((String)entry.getKey()).startsWith("graph.dataaccess.mmap.preload.")) continue;
            this.dataAccessConfig.put(((String)entry.getKey()).substring("graph.dataaccess.mmap.".length()), entry.getValue().toString());
        }
        this.sortGraph = ghConfig.getBool("graph.do_sort", this.sortGraph);
        this.removeZipped = ghConfig.getBool("graph.remove_zipped", this.removeZipped);
        if (!ghConfig.getString("spatial_rules.location", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.location has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.borders_directory", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.borders_directory has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.max_bbox", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.max_bbox has been deprecated. There is no replacement, all custom areas will be considered.");
        }
        this.setProfiles(ghConfig.getProfiles());
        if (ghConfig.has("graph.vehicles") && ghConfig.has("graph.flag_encoders")) {
            throw new IllegalArgumentException("Remove graph.flag_encoders as it cannot be used in parallel with graph.vehicles");
        }
        if (ghConfig.has("graph.flag_encoders")) {
            logger.warn("The option graph.flag_encoders is deprecated and will be removed. Replace with graph.vehicles");
        }
        this.vehiclesString = ghConfig.getString("graph.vehicles", ghConfig.getString("graph.flag_encoders", this.vehiclesString));
        this.encodedValuesString = ghConfig.getString("graph.encoded_values", this.encodedValuesString);
        this.dateRangeParserString = ghConfig.getString("datareader.date_range_parser_day", this.dateRangeParserString);
        this.lockFactory = ghConfig.getString("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        if (ghConfig.has("graph.elevation.smoothing")) {
            throw new IllegalArgumentException("Use 'graph.elevation.edge_smoothing: moving_average' or the new 'graph.elevation.edge_smoothing: ramer'. See #2634.");
        }
        this.osmReaderConfig.setElevationSmoothing(ghConfig.getString("graph.elevation.edge_smoothing", this.osmReaderConfig.getElevationSmoothing()));
        this.osmReaderConfig.setElevationSmoothingRamerMax(ghConfig.getInt("graph.elevation.edge_smoothing.ramer.max_elevation", this.osmReaderConfig.getElevationSmoothingRamerMax()));
        this.osmReaderConfig.setLongEdgeSamplingDistance(ghConfig.getDouble("graph.elevation.long_edge_sampling_distance", this.osmReaderConfig.getLongEdgeSamplingDistance()));
        this.osmReaderConfig.setElevationMaxWayPointDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", this.osmReaderConfig.getElevationMaxWayPointDistance()));
        this.routerConfig.setElevationWayPointMaxDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", this.routerConfig.getElevationWayPointMaxDistance()));
        ElevationProvider elevationProvider = GraphHopper.createElevationProvider(ghConfig);
        this.setElevationProvider(elevationProvider);
        if (this.osmReaderConfig.getLongEdgeSamplingDistance() < Double.MAX_VALUE && !elevationProvider.canInterpolate()) {
            logger.warn("Long edge sampling enabled, but bilinear interpolation disabled. See #1953");
        }
        this.minNetworkSize = ghConfig.getInt("prepare.min_network_size", this.minNetworkSize);
        this.chPreparationHandler.init(ghConfig);
        this.lmPreparationHandler.init(ghConfig);
        this.osmReaderConfig.setIgnoredHighways(Arrays.stream(ghConfig.getString("import.osm.ignored_highways", String.join((CharSequence)",", this.osmReaderConfig.getIgnoredHighways())).split(",")).map(String::trim).collect(Collectors.toList()));
        List<String> ignoredHighways = this.osmReaderConfig.getIgnoredHighways();
        if (ignoredHighways.isEmpty()) {
            throw new IllegalArgumentException("Missing 'import.osm.ignored_highways'. Not using this parameter can decrease performance, see config-example.yml for more details");
        }
        if ((ignoredHighways.contains("footway") || ignoredHighways.contains("path")) && ghConfig.getProfiles().stream().map(Profile::getName).anyMatch(p -> p.contains("foot") || p.contains("hike") || p.contains("wheelchair"))) {
            throw new IllegalArgumentException("You should not use import.osm.ignored_highways=footway or =path in conjunction with pedestrian profiles. This is probably an error in your configuration.");
        }
        if ((ignoredHighways.contains("cycleway") || ignoredHighways.contains("path")) && ghConfig.getProfiles().stream().map(Profile::getName).anyMatch(p -> p.contains("mtb") || p.contains("bike"))) {
            throw new IllegalArgumentException("You should not use import.osm.ignored_highways=cycleway or =path in conjunction with bicycle profiles. This is probably an error in your configuration");
        }
        this.osmReaderConfig.setParseWayNames(ghConfig.getBool("datareader.instructions", this.osmReaderConfig.isParseWayNames()));
        this.osmReaderConfig.setPreferredLanguage(ghConfig.getString("datareader.preferred_language", this.osmReaderConfig.getPreferredLanguage()));
        this.osmReaderConfig.setMaxWayPointDistance(ghConfig.getDouble("routing.way_point_max_distance", this.osmReaderConfig.getMaxWayPointDistance()));
        this.osmReaderConfig.setWorkerThreads(ghConfig.getInt("datareader.worker_threads", this.osmReaderConfig.getWorkerThreads()));
        this.preciseIndexResolution = ghConfig.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = ghConfig.getInt("index.max_region_search", this.maxRegionSearch);
        this.residentialAreaRadius = ghConfig.getDouble("graph.urban_density.residential_radius", this.residentialAreaRadius);
        this.residentialAreaSensitivity = ghConfig.getDouble("graph.urban_density.residential_sensitivity", this.residentialAreaSensitivity);
        this.cityAreaRadius = ghConfig.getDouble("graph.urban_density.city_radius", this.cityAreaRadius);
        this.cityAreaSensitivity = ghConfig.getDouble("graph.urban_density.city_sensitivity", this.cityAreaSensitivity);
        this.urbanDensityCalculationThreads = ghConfig.getInt("graph.urban_density.threads", this.urbanDensityCalculationThreads);
        this.routerConfig.setMaxVisitedNodes(ghConfig.getInt("routing.max_visited_nodes", this.routerConfig.getMaxVisitedNodes()));
        this.routerConfig.setMaxRoundTripRetries(ghConfig.getInt("routing.round_trip.max_retries", this.routerConfig.getMaxRoundTripRetries()));
        this.routerConfig.setNonChMaxWaypointDistance(ghConfig.getInt("routing.non_ch.max_waypoint_distance", this.routerConfig.getNonChMaxWaypointDistance()));
        this.routerConfig.setInstructionsEnabled(ghConfig.getBool("routing.instructions", this.routerConfig.isInstructionsEnabled()));
        int activeLandmarkCount = ghConfig.getInt("routing.lm.active_landmarks", Math.min(8, this.lmPreparationHandler.getLandmarks()));
        if (activeLandmarkCount > this.lmPreparationHandler.getLandmarks()) {
            throw new IllegalArgumentException("Default value for active landmarks " + activeLandmarkCount + " should be less or equal to landmark count of " + this.lmPreparationHandler.getLandmarks());
        }
        this.routerConfig.setActiveLandmarkCount(activeLandmarkCount);
        return this;
    }

    protected EncodingManager buildEncodingManager(Map<String, String> vehiclesByName, List<String> encodedValueStrings, boolean withUrbanDensity, Collection<Profile> profiles) {
        EncodingManager.Builder emBuilder = new EncodingManager.Builder();
        vehiclesByName.forEach((name, vehicleStr) -> emBuilder.add(this.vehicleEncodedValuesFactory.createVehicleEncodedValues((String)name, new PMap(vehicleStr))));
        profiles.forEach(profile -> emBuilder.add(Subnetwork.create(profile.getName())));
        if (withUrbanDensity) {
            emBuilder.add(UrbanDensity.create());
        }
        encodedValueStrings.forEach(s -> emBuilder.add(this.encodedValueFactory.create((String)s)));
        return emBuilder.build();
    }

    protected OSMParsers buildOSMParsers(Map<String, String> vehiclesByName, List<String> encodedValueStrings, List<String> ignoredHighways, String dateRangeParserString) {
        OSMParsers osmParsers = new OSMParsers();
        ignoredHighways.forEach(osmParsers::addIgnoredHighway);
        for (String s : encodedValueStrings) {
            TagParser tagParser = this.tagParserFactory.create(this.encodingManager, s);
            if (tagParser == null) continue;
            osmParsers.addWayTagParser(tagParser);
        }
        if (!encodedValueStrings.contains("roundabout")) {
            osmParsers.addWayTagParser(new OSMRoundaboutParser(this.encodingManager.getBooleanEncodedValue("roundabout")));
        }
        if (!encodedValueStrings.contains("road_class")) {
            osmParsers.addWayTagParser(new OSMRoadClassParser(this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class)));
        }
        if (!encodedValueStrings.contains("road_class_link")) {
            osmParsers.addWayTagParser(new OSMRoadClassLinkParser(this.encodingManager.getBooleanEncodedValue("road_class_link")));
        }
        if (!encodedValueStrings.contains("road_environment")) {
            osmParsers.addWayTagParser(new OSMRoadEnvironmentParser(this.encodingManager.getEnumEncodedValue("road_environment", RoadEnvironment.class)));
        }
        if (!encodedValueStrings.contains("max_speed")) {
            osmParsers.addWayTagParser(new OSMMaxSpeedParser(this.encodingManager.getDecimalEncodedValue("max_speed")));
        }
        if (!encodedValueStrings.contains("road_access")) {
            osmParsers.addWayTagParser(new OSMRoadAccessParser(this.encodingManager.getEnumEncodedValue("road_access", RoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.CAR)));
        }
        if (this.encodingManager.hasEncodedValue("average_slope") || this.encodingManager.hasEncodedValue("max_slope")) {
            if (!this.encodingManager.hasEncodedValue("average_slope") || !this.encodingManager.hasEncodedValue("max_slope")) {
                throw new IllegalArgumentException("Enable both, average_slope and max_slope");
            }
            osmParsers.addWayTagParser(new SlopeCalculator(this.encodingManager.getDecimalEncodedValue("max_slope"), this.encodingManager.getDecimalEncodedValue("average_slope")));
        }
        if (this.encodingManager.hasEncodedValue("curvature")) {
            osmParsers.addWayTagParser(new CurvatureCalculator(this.encodingManager.getDecimalEncodedValue("curvature")));
        }
        DateRangeParser dateRangeParser = DateRangeParser.createInstance(dateRangeParserString);
        vehiclesByName.forEach((name, vehicleStr) -> {
            VehicleTagParser vehicleTagParser = this.vehicleTagParserFactory.createParser(this.encodingManager, (String)name, new PMap(vehicleStr));
            if (vehicleTagParser == null) {
                return;
            }
            vehicleTagParser.init(dateRangeParser);
            if (vehicleTagParser instanceof BikeCommonTagParser) {
                if (this.encodingManager.hasEncodedValue(BikeNetwork.KEY)) {
                    osmParsers.addRelationTagParser(relConfig -> new OSMBikeNetworkTagParser(this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), (EncodedValue.InitializerConfig)relConfig));
                }
                if (this.encodingManager.hasEncodedValue("get_off_bike")) {
                    osmParsers.addWayTagParser(new OSMGetOffBikeParser(this.encodingManager.getBooleanEncodedValue("get_off_bike")));
                }
                if (this.encodingManager.hasEncodedValue("smoothness")) {
                    osmParsers.addWayTagParser(new OSMSmoothnessParser(this.encodingManager.getEnumEncodedValue("smoothness", Smoothness.class)));
                }
            } else if (vehicleTagParser instanceof FootTagParser && this.encodingManager.hasEncodedValue(FootNetwork.KEY)) {
                osmParsers.addRelationTagParser(relConfig -> new OSMFootNetworkTagParser(this.encodingManager.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class), (EncodedValue.InitializerConfig)relConfig));
            }
            osmParsers.addVehicleTagParser(vehicleTagParser);
        });
        return osmParsers;
    }

    public static List<String> getEncodedValueStrings(String encodedValuesStr) {
        return Arrays.stream(encodedValuesStr.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static Map<String, String> getVehiclesByName(String vehiclesStr, Collection<Profile> profiles) {
        LinkedHashMap<String, String> vehiclesMap = new LinkedHashMap<String, String>();
        for (String encoderStr : vehiclesStr.split(",")) {
            String name = encoderStr.split("\\|")[0].trim();
            if (name.isEmpty()) continue;
            if (vehiclesMap.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate flag encoder: " + name + " in: " + encoderStr);
            }
            vehiclesMap.put(name, encoderStr);
        }
        LinkedHashMap<String, String> flagEncodersFromProfilesMap = new LinkedHashMap<String, String>();
        for (Profile profile : profiles) {
            String vehicle = profile.getVehicle().trim();
            if (flagEncodersFromProfilesMap.containsKey(vehicle) && !profile.isTurnCosts()) continue;
            flagEncodersFromProfilesMap.put(vehicle, vehicle + (profile.isTurnCosts() ? "|turn_costs=true" : ""));
        }
        flagEncodersFromProfilesMap.forEach(vehiclesMap::putIfAbsent);
        return vehiclesMap;
    }

    private static ElevationProvider createElevationProvider(GraphHopperConfig ghConfig) {
        String eleProviderStr = Helper.toLowerCase((String)ghConfig.getString("graph.elevation.provider", "noop"));
        if (ghConfig.has("graph.elevation.calcmean")) {
            throw new IllegalArgumentException("graph.elevation.calcmean is deprecated, use graph.elevation.interpolate");
        }
        String cacheDirStr = ghConfig.getString("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty() && ghConfig.has("graph.elevation.cachedir")) {
            throw new IllegalArgumentException("use graph.elevation.cache_dir not cachedir in configuration");
        }
        ElevationProvider elevationProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("hgt")) {
            elevationProvider = new HGTProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtm")) {
            elevationProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            elevationProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            elevationProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            elevationProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            elevationProvider = new MultiSourceElevationProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("skadi")) {
            elevationProvider = new SkadiProvider(cacheDirStr);
        }
        if (elevationProvider instanceof TileBasedElevationProvider) {
            TileBasedElevationProvider provider = (TileBasedElevationProvider)elevationProvider;
            String baseURL = ghConfig.getString("graph.elevation.base_url", "");
            if (baseURL.isEmpty() && ghConfig.has("graph.elevation.baseurl")) {
                throw new IllegalArgumentException("use graph.elevation.base_url not baseurl in configuration");
            }
            DAType elevationDAType = DAType.fromString(ghConfig.getString("graph.elevation.dataaccess", "MMAP"));
            boolean interpolate = ghConfig.has("graph.elevation.interpolate") ? "bilinear".equals(ghConfig.getString("graph.elevation.interpolate", "none")) : ghConfig.getBool("graph.elevation.calc_mean", false);
            boolean removeTempElevationFiles = ghConfig.getBool("graph.elevation.cgiar.clear", true);
            removeTempElevationFiles = ghConfig.getBool("graph.elevation.clear", removeTempElevationFiles);
            provider.setAutoRemoveTemporaryFiles(removeTempElevationFiles).setInterpolate(interpolate).setDAType(elevationDAType);
            if (!baseURL.isEmpty()) {
                provider.setBaseURL(baseURL);
            }
        }
        return elevationProvider;
    }

    private void printInfo() {
        logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.baseGraph != null) {
            logger.info("graph " + this.getBaseGraphString() + ", details:" + this.baseGraph.toDetailsString());
        }
    }

    private String getBaseGraphString() {
        return this.encodingManager + "|" + this.baseGraph.getDirectory().getDefaultType() + "|" + this.baseGraph.getNodeAccess().getDimension() + "D|" + (this.baseGraph.getTurnCostStorage() != null ? this.baseGraph.getTurnCostStorage() : "no_turn_cost") + "|" + this.getVersionsString();
    }

    private String getVersionsString() {
        return "nodes:9,edges:21,geometry:6,location_index:5,string_index:2,nodesCH:0,shortcuts:9";
    }

    public GraphHopper importOrLoad() {
        if (!this.load()) {
            this.printInfo();
            this.process(false);
        } else {
            this.printInfo();
        }
        return this;
    }

    public void importAndClose() {
        if (!this.load()) {
            this.printInfo();
            this.process(true);
        } else {
            this.printInfo();
            logger.info("Graph already imported into " + this.ghLocation);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(boolean closeEarly) {
        GHDirectory directory = new GHDirectory(this.ghLocation, this.dataAccessDefaultType);
        directory.configure(this.dataAccessConfig);
        boolean withUrbanDensity = this.urbanDensityCalculationThreads > 0;
        Map<String, String> vehiclesByName = GraphHopper.getVehiclesByName(this.vehiclesString, this.profilesByName.values());
        List<String> encodedValueStrings = GraphHopper.getEncodedValueStrings(this.encodedValuesString);
        this.encodingManager = this.buildEncodingManager(vehiclesByName, encodedValueStrings, withUrbanDensity, this.profilesByName.values());
        this.osmParsers = this.buildOSMParsers(vehiclesByName, encodedValueStrings, this.osmReaderConfig.getIgnoredHighways(), this.dateRangeParserString);
        this.baseGraph = new BaseGraph.Builder(this.getEncodingManager()).setDir(directory).set3D(this.hasElevation()).withTurnCosts(this.encodingManager.needsTurnCostsSupport()).setSegmentSize(this.defaultSegmentSize).build();
        this.properties = new StorableProperties(directory);
        this.checkProfilesConsistency();
        GHLock lock = null;
        try {
            if (directory.getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            this.ensureWriteAccess();
            this.importOSM();
            this.cleanUp();
            this.postImport();
            this.postProcessing(closeEarly);
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    protected void postImport() {
        if (this.sortGraph) {
            BaseGraph newGraph = GHUtility.newGraph(this.baseGraph);
            GHUtility.sortDFS(this.baseGraph, newGraph);
            logger.info("graph sorted (" + Helper.getMemInfo() + ")");
            this.baseGraph = newGraph;
        }
        if (this.hasElevation()) {
            this.interpolateBridgesTunnelsAndFerries();
        }
        if (this.encodingManager.hasEncodedValue("urban_density")) {
            EnumEncodedValue<UrbanDensity> urbanDensityEnc = this.encodingManager.getEnumEncodedValue("urban_density", UrbanDensity.class);
            if (!this.encodingManager.hasEncodedValue("road_class")) {
                throw new IllegalArgumentException("Urban density calculation requires road_class");
            }
            if (!this.encodingManager.hasEncodedValue("road_class_link")) {
                throw new IllegalArgumentException("Urban density calculation requires road_class_link");
            }
            EnumEncodedValue<RoadClass> roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
            BooleanEncodedValue roadClassLinkEnc = this.encodingManager.getBooleanEncodedValue("road_class_link");
            UrbanDensityCalculator.calcUrbanDensity(this.baseGraph, urbanDensityEnc, roadClassEnc, roadClassLinkEnc, this.residentialAreaRadius, this.residentialAreaSensitivity, this.cityAreaRadius, this.cityAreaSensitivity, this.urbanDensityCalculationThreads);
        }
    }

    protected void importOSM() {
        if (this.osmFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        List<CustomArea> customAreas = GHUtility.readCountries();
        if (Helper.isEmpty((String)this.customAreasDirectory)) {
            logger.info("No custom areas are used, custom_areas.directory not given");
        } else {
            logger.info("Creating custom area index, reading custom areas from: '" + this.customAreasDirectory + "'");
            customAreas.addAll(this.readCustomAreas());
        }
        CustomArea area = GHUtility.getFirstDuplicateArea(customAreas, "ISO3166-1:alpha3");
        if (area != null) {
            throw new IllegalArgumentException("area used duplicate 'ISO3166-1:alpha3' see properties: " + area.getProperties());
        }
        AreaIndex<CustomArea> areaIndex = new AreaIndex<CustomArea>(customAreas);
        if (this.countryRuleFactory == null || this.countryRuleFactory.getCountryToRuleMap().isEmpty()) {
            logger.info("No country rules available");
        } else {
            logger.info("Applying rules for the following countries: {}", this.countryRuleFactory.getCountryToRuleMap().keySet());
        }
        logger.info("start creating graph from " + this.osmFile);
        OSMReader reader = new OSMReader(this.baseGraph.getBaseGraph(), this.encodingManager, this.osmParsers, this.osmReaderConfig).setFile(this._getOSMFile()).setAreaIndex(areaIndex).setElevationProvider(this.eleProvider).setCountryRuleFactory(this.countryRuleFactory);
        logger.info("using " + this.getBaseGraphString() + ", memory:" + Helper.getMemInfo());
        this.createBaseGraphAndProperties();
        try {
            reader.readGraph();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file " + this.getOSMFile(), ex);
        }
        DateFormat f = Helper.createFormatter();
        this.properties.put("datareader.import.date", f.format(new Date()));
        if (reader.getDataDate() != null) {
            this.properties.put("datareader.data.date", f.format(reader.getDataDate()));
        }
        this.writeEncodingManagerToProperties();
    }

    protected void createBaseGraphAndProperties() {
        this.baseGraph.getDirectory().create();
        this.baseGraph.create(100L);
        this.properties.create(100L);
    }

    protected void writeEncodingManagerToProperties() {
        EncodingManager.putEncodingManagerIntoProperties(this.encodingManager, this.properties);
    }

    private List<CustomArea> readCustomAreas() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JtsModule());
        Path bordersDirectory = Paths.get(this.customAreasDirectory, new String[0]);
        ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
            for (Path borderFile : stream) {
                BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                    jsonFeatureCollections.add(jsonFeatureCollection);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jsonFeatureCollections.stream().flatMap(j -> j.getFeatures().stream()).map(CustomArea::fromJsonFeature).collect(Collectors.toList());
    }

    protected File _getOSMFile() {
        return new File(this.osmFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (Helper.isEmpty((String)this.ghLocation)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(this.ghLocation);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(this.ghLocation + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), this.ghLocation, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + this.ghLocation, ex);
            }
        }
        if (!this.allowWrites && this.dataAccessDefaultType.isMMap()) {
            this.dataAccessDefaultType = DAType.MMAP_RO;
        }
        if (!new File(this.ghLocation).exists()) {
            return false;
        }
        GHDirectory directory = new GHDirectory(this.ghLocation, this.dataAccessDefaultType);
        directory.configure(this.dataAccessConfig);
        GHLock lock = null;
        try {
            if (directory.getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            this.properties = new StorableProperties(directory);
            if (!this.properties.loadExisting()) {
                boolean bl = false;
                return bl;
            }
            this.encodingManager = EncodingManager.fromProperties(this.properties);
            this.baseGraph = new BaseGraph.Builder(this.encodingManager).setDir(directory).set3D(this.hasElevation()).withTurnCosts(this.encodingManager.needsTurnCostsSupport()).setSegmentSize(this.defaultSegmentSize).build();
            this.baseGraph.loadExisting();
            this.checkProfilesConsistency();
            String storedProfiles = this.properties.get("profiles");
            String configuredProfiles = this.getProfilesString();
            if (!storedProfiles.equals(configuredProfiles)) {
                throw new IllegalStateException("Profiles do not match:\nGraphhopper config: " + configuredProfiles + "\nGraph: " + storedProfiles + "\nChange configuration to match the graph or delete " + this.baseGraph.getDirectory().getLocation());
            }
            this.postProcessing(false);
            directory.loadMMap();
            this.setFullyLoaded();
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private String getProfilesString() {
        return this.profilesByName.values().stream().map(p -> p.getName() + "|" + p.getVersion()).collect(Collectors.joining(","));
    }

    private void checkProfilesConsistency() {
        if (this.profilesByName.isEmpty()) {
            throw new IllegalArgumentException("There has to be at least one profile");
        }
        EncodingManager encodingManager = this.getEncodingManager();
        for (Profile profile : this.profilesByName.values()) {
            DecimalEncodedValue turnCostEnc;
            if (!encodingManager.getVehicles().contains(profile.getVehicle())) {
                throw new IllegalArgumentException("Unknown vehicle '" + profile.getVehicle() + "' in profile: " + profile + ". Available vehicles: " + String.join((CharSequence)",", encodingManager.getVehicles()));
            }
            DecimalEncodedValue decimalEncodedValue = turnCostEnc = encodingManager.hasEncodedValue(TurnCost.key(profile.getVehicle())) ? encodingManager.getDecimalEncodedValue(TurnCost.key(profile.getVehicle())) : null;
            if (profile.isTurnCosts() && turnCostEnc == null) {
                throw new IllegalArgumentException("The profile '" + profile.getName() + "' was configured with 'turn_costs=true', but the corresponding vehicle '" + profile.getVehicle() + "' does not support turn costs.\nYou need to add `|turn_costs=true` to the vehicle in `graph.vehicles`");
            }
            try {
                this.createWeighting(profile, new PMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not create weighting for profile: '" + profile.getName() + "'.\nProfile: " + profile + "\nError: " + e.getMessage());
            }
            if (!(profile instanceof CustomProfile)) continue;
            CustomModel customModel = ((CustomProfile)profile).getCustomModel();
            if (customModel == null) {
                throw new IllegalArgumentException("custom model for profile '" + profile.getName() + "' was empty");
            }
            if ("custom".equals(profile.getWeighting())) continue;
            throw new IllegalArgumentException("profile '" + profile.getName() + "' has a custom model but weighting=" + profile.getWeighting() + " was defined");
        }
        LinkedHashSet<String> chProfileSet = new LinkedHashSet<String>(this.chPreparationHandler.getCHProfiles().size());
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            boolean added = chProfileSet.add(chProfile.getProfile());
            if (!added) {
                throw new IllegalArgumentException("Duplicate CH reference to profile '" + chProfile.getProfile() + "'");
            }
            if (this.profilesByName.containsKey(chProfile.getProfile())) continue;
            throw new IllegalArgumentException("CH profile references unknown profile '" + chProfile.getProfile() + "'");
        }
        LinkedHashMap<String, LMProfile> linkedHashMap = new LinkedHashMap<String, LMProfile>(this.lmPreparationHandler.getLMProfiles().size());
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            LMProfile previous = linkedHashMap.put(lmProfile.getProfile(), lmProfile);
            if (previous != null) {
                throw new IllegalArgumentException("Multiple LM profiles are using the same profile '" + lmProfile.getProfile() + "'");
            }
            if (!this.profilesByName.containsKey(lmProfile.getProfile())) {
                throw new IllegalArgumentException("LM profile references unknown profile '" + lmProfile.getProfile() + "'");
            }
            if (!lmProfile.usesOtherPreparation() || this.profilesByName.containsKey(lmProfile.getPreparationProfile())) continue;
            throw new IllegalArgumentException("LM profile references unknown preparation profile '" + lmProfile.getPreparationProfile() + "'");
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation() && !linkedHashMap.containsKey(lmProfile.getPreparationProfile())) {
                throw new IllegalArgumentException("Unknown LM preparation profile '" + lmProfile.getPreparationProfile() + "' in LM profile '" + lmProfile.getProfile() + "' cannot be used as preparation_profile");
            }
            if (!lmProfile.usesOtherPreparation() || !((LMProfile)linkedHashMap.get(lmProfile.getPreparationProfile())).usesOtherPreparation()) continue;
            throw new IllegalArgumentException("Cannot use '" + lmProfile.getPreparationProfile() + "' as preparation_profile for LM profile '" + lmProfile.getProfile() + "', because it uses another profile for preparation itself.");
        }
    }

    public final CHPreparationHandler getCHPreparationHandler() {
        return this.chPreparationHandler;
    }

    private List<CHConfig> createCHConfigs(List<CHProfile> chProfiles) {
        ArrayList<CHConfig> chConfigs = new ArrayList<CHConfig>();
        for (CHProfile chProfile : chProfiles) {
            Profile profile = this.profilesByName.get(chProfile.getProfile());
            if (profile.isTurnCosts()) {
                chConfigs.add(CHConfig.edgeBased(profile.getName(), this.createWeighting(profile, new PMap())));
                continue;
            }
            chConfigs.add(CHConfig.nodeBased(profile.getName(), this.createWeighting(profile, new PMap())));
        }
        return chConfigs;
    }

    public final LMPreparationHandler getLMPreparationHandler() {
        return this.lmPreparationHandler;
    }

    private List<LMConfig> createLMConfigs(List<LMProfile> lmProfiles) {
        ArrayList<LMConfig> lmConfigs = new ArrayList<LMConfig>();
        for (LMProfile lmProfile : lmProfiles) {
            if (lmProfile.usesOtherPreparation()) continue;
            Profile profile = this.profilesByName.get(lmProfile.getProfile());
            Weighting weighting = this.createWeighting(profile, new PMap(), true);
            lmConfigs.add(new LMConfig(profile.getName(), weighting));
        }
        return lmConfigs;
    }

    protected void postProcessing(boolean closeEarly) {
        boolean includesCustomProfiles;
        this.initLocationIndex();
        this.importPublicTransit();
        if (closeEarly && !(includesCustomProfiles = this.profilesByName.values().stream().anyMatch(p -> p instanceof CustomProfile))) {
            this.baseGraph.flushAndCloseGeometryAndNameStorage();
        }
        if (this.lmPreparationHandler.isEnabled()) {
            this.loadOrPrepareLM(closeEarly);
        }
        if (closeEarly) {
            this.locationIndex.close();
        }
        if (this.chPreparationHandler.isEnabled()) {
            this.loadOrPrepareCH(closeEarly);
        }
    }

    protected void importPublicTransit() {
    }

    void interpolateBridgesTunnelsAndFerries() {
        if (this.encodingManager.hasEncodedValue("road_environment")) {
            EnumEncodedValue<RoadEnvironment> roadEnvEnc = this.encodingManager.getEnumEncodedValue("road_environment", RoadEnvironment.class);
            StopWatch sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.TUNNEL).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.BRIDGE).execute();
            float bridge = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.FERRY).execute();
            logger.info("Bridge interpolation " + (int)bridge + "s, tunnel interpolation " + (int)tunnel + "s, ferry interpolation " + (int)sw.stop().getSeconds() + "s");
        }
    }

    public final Weighting createWeighting(Profile profile, PMap hints) {
        return this.createWeighting(profile, hints, false);
    }

    public final Weighting createWeighting(Profile profile, PMap hints, boolean disableTurnCosts) {
        return this.createWeightingFactory().createWeighting(profile, hints, disableTurnCosts);
    }

    protected WeightingFactory createWeightingFactory() {
        return new DefaultWeightingFactory(this.baseGraph.getBaseGraph(), this.getEncodingManager());
    }

    public GHResponse route(GHRequest request) {
        return this.createRouter().route(request);
    }

    private Router createRouter() {
        if (this.baseGraph == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.baseGraph.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        return this.doCreateRouter(this.baseGraph, this.encodingManager, this.locationIndex, this.profilesByName, this.pathBuilderFactory, this.trMap, this.routerConfig, this.createWeightingFactory(), this.chGraphs, this.landmarks);
    }

    protected Router doCreateRouter(BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, Map<String, Profile> profilesByName, PathDetailsBuilderFactory pathBuilderFactory, TranslationMap trMap, RouterConfig routerConfig, WeightingFactory weightingFactory, Map<String, RoutingCHGraph> chGraphs, Map<String, LandmarkStorage> landmarks) {
        return new Router(baseGraph, encodingManager, locationIndex, profilesByName, pathBuilderFactory, trMap, routerConfig, weightingFactory, chGraphs, landmarks);
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.baseGraph, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.baseGraph.getDirectory());
    }

    private String getCHProfileVersion(String profile) {
        return this.properties.get("graph.profiles.ch." + profile + ".version");
    }

    private void setCHProfileVersion(String profile, int version) {
        this.properties.put("graph.profiles.ch." + profile + ".version", version);
    }

    private String getLMProfileVersion(String profile) {
        return this.properties.get("graph.profiles.lm." + profile + ".version");
    }

    private void setLMProfileVersion(String profile, int version) {
        this.properties.put("graph.profiles.lm." + profile + ".version", version);
    }

    protected void loadOrPrepareCH(boolean closeEarly) {
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (this.getCHProfileVersion(profile.getProfile()).isEmpty() || this.getCHProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        List<CHConfig> chConfigs = this.createCHConfigs(this.chPreparationHandler.getCHProfiles());
        Map<String, RoutingCHGraph> loaded = this.chPreparationHandler.load(this.baseGraph.getBaseGraph(), chConfigs);
        List<CHConfig> configsToPrepare = chConfigs.stream().filter(c -> !loaded.containsKey(c.getName())).collect(Collectors.toList());
        Map<String, PrepareContractionHierarchies.Result> prepared = this.prepareCH(closeEarly, configsToPrepare);
        this.chGraphs = new LinkedHashMap<String, RoutingCHGraph>();
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (loaded.containsKey(profile.getProfile()) && prepared.containsKey(profile.getProfile())) {
                throw new IllegalStateException("CH graph should be either loaded or prepared, but not both: " + profile.getProfile());
            }
            if (prepared.containsKey(profile.getProfile())) {
                this.setCHProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
                PrepareContractionHierarchies.Result res = prepared.get(profile.getProfile());
                this.chGraphs.put(profile.getProfile(), RoutingCHGraphImpl.fromGraph(this.baseGraph.getBaseGraph(), res.getCHStorage(), res.getCHConfig()));
                continue;
            }
            if (loaded.containsKey(profile.getProfile())) {
                this.chGraphs.put(profile.getProfile(), loaded.get(profile.getProfile()));
                continue;
            }
            throw new IllegalStateException("CH graph should be either loaded or prepared: " + profile.getProfile());
        }
    }

    protected Map<String, PrepareContractionHierarchies.Result> prepareCH(boolean closeEarly, List<CHConfig> configsToPrepare) {
        if (!configsToPrepare.isEmpty()) {
            this.ensureWriteAccess();
        }
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
        return this.chPreparationHandler.prepare(this.baseGraph, this.properties, configsToPrepare, closeEarly);
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
            if (this.getLMProfileVersion(profile.getProfile()).isEmpty() || this.getLMProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("LM preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        List<LMConfig> lmConfigs = this.createLMConfigs(this.lmPreparationHandler.getLMProfiles());
        List<LandmarkStorage> loaded = this.lmPreparationHandler.load(lmConfigs, this.baseGraph, this.encodingManager);
        List loadedConfigs = loaded.stream().map(LandmarkStorage::getLMConfig).collect(Collectors.toList());
        List<LMConfig> configsToPrepare = lmConfigs.stream().filter(c -> !loadedConfigs.contains(c)).collect(Collectors.toList());
        List<PrepareLandmarks> prepared = this.prepareLM(closeEarly, configsToPrepare);
        this.landmarks = new LinkedHashMap<String, LandmarkStorage>();
        for (LMProfile lmp : this.lmPreparationHandler.getLMProfiles()) {
            String prepProfile = lmp.usesOtherPreparation() ? lmp.getPreparationProfile() : lmp.getProfile();
            Optional<LandmarkStorage> loadedLMS = loaded.stream().filter(lms -> lms.getLMConfig().getName().equals(prepProfile)).findFirst();
            Optional<PrepareLandmarks> preparedLMS = prepared.stream().filter(pl -> pl.getLandmarkStorage().getLMConfig().getName().equals(prepProfile)).findFirst();
            if (loadedLMS.isPresent() && preparedLMS.isPresent()) {
                throw new IllegalStateException("LM should be either loaded or prepared, but not both: " + prepProfile);
            }
            if (preparedLMS.isPresent()) {
                this.setLMProfileVersion(lmp.getProfile(), this.profilesByName.get(lmp.getProfile()).getVersion());
                this.landmarks.put(lmp.getProfile(), preparedLMS.get().getLandmarkStorage());
                continue;
            }
            loadedLMS.ifPresent(landmarkStorage -> this.landmarks.put(lmp.getProfile(), (LandmarkStorage)landmarkStorage));
        }
    }

    protected List<PrepareLandmarks> prepareLM(boolean closeEarly, List<LMConfig> configsToPrepare) {
        if (!configsToPrepare.isEmpty()) {
            this.ensureWriteAccess();
        }
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
        return this.lmPreparationHandler.prepare(configsToPrepare, this.baseGraph, this.encodingManager, this.properties, this.locationIndex, closeEarly);
    }

    protected void cleanUp() {
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.baseGraph.getBaseGraph(), this.buildSubnetworkRemovalJobs());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.doWork();
        this.properties.put("profiles", this.getProfilesString());
        logger.info("nodes: " + Helper.nf((long)this.baseGraph.getNodes()) + ", edges: " + Helper.nf((long)this.baseGraph.getEdges()));
    }

    private List<PrepareRoutingSubnetworks.PrepareJob> buildSubnetworkRemovalJobs() {
        ArrayList<PrepareRoutingSubnetworks.PrepareJob> jobs = new ArrayList<PrepareRoutingSubnetworks.PrepareJob>();
        for (Profile profile : this.profilesByName.values()) {
            Weighting weighting = this.createWeighting(profile, new PMap().putObject("u_turn_costs", (Object)0));
            jobs.add(new PrepareRoutingSubnetworks.PrepareJob(this.encodingManager.getBooleanEncodedValue(Subnetwork.key(profile.getName())), weighting));
        }
        return jobs;
    }

    protected void flush() {
        logger.info("flushing graph " + this.getBaseGraphString() + ", details:" + this.baseGraph.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.baseGraph.flush();
        this.properties.flush();
        logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.setFullyLoaded();
    }

    public void close() {
        if (this.baseGraph != null) {
            this.baseGraph.close();
        }
        if (this.properties != null) {
            this.properties.close();
        }
        this.chGraphs.values().forEach(RoutingCHGraph::close);
        this.landmarks.values().forEach(LandmarkStorage::close);
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir((File)folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    private void setFullyLoaded() {
        this.fullyLoaded = true;
    }

    public boolean getFullyLoaded() {
        return this.fullyLoaded;
    }

    public RouterConfig getRouterConfig() {
        return this.routerConfig;
    }

    public OSMReaderConfig getReaderConfig() {
        return this.osmReaderConfig;
    }
}

