/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import com.graphhopper.storage.DAType;

public class MultiSourceElevationProvider
extends TileBasedElevationProvider {
    private final TileBasedElevationProvider srtmProvider;
    private final TileBasedElevationProvider globalProvider;

    public MultiSourceElevationProvider(TileBasedElevationProvider srtmProvider, TileBasedElevationProvider globalProvider) {
        super(srtmProvider.cacheDir.getAbsolutePath());
        this.srtmProvider = srtmProvider;
        this.globalProvider = globalProvider;
    }

    public MultiSourceElevationProvider() {
        this(new CGIARProvider(), new GMTEDProvider());
    }

    public MultiSourceElevationProvider(String cacheDir) {
        this(new CGIARProvider(cacheDir), new GMTEDProvider(cacheDir));
    }

    @Override
    public double getEle(double lat, double lon) {
        if (lat < 59.999 && lat > -56.0) {
            return this.srtmProvider.getEle(lat, lon);
        }
        return this.globalProvider.getEle(lat, lon);
    }

    @Override
    public MultiSourceElevationProvider setBaseURL(String baseURL) {
        String[] urls = baseURL.split(";");
        if (urls.length != 2) {
            throw new IllegalArgumentException("The base url must consist of two urls separated by a ';'. The first for cgiar, the second for gmted");
        }
        this.srtmProvider.setBaseURL(urls[0]);
        this.globalProvider.setBaseURL(urls[1]);
        return this;
    }

    @Override
    public MultiSourceElevationProvider setDAType(DAType daType) {
        this.srtmProvider.setDAType(daType);
        this.globalProvider.setDAType(daType);
        return this;
    }

    @Override
    public MultiSourceElevationProvider setInterpolate(boolean interpolate) {
        this.srtmProvider.setInterpolate(interpolate);
        this.globalProvider.setInterpolate(interpolate);
        return this;
    }

    @Override
    public boolean canInterpolate() {
        return this.srtmProvider.canInterpolate() && this.globalProvider.canInterpolate();
    }

    @Override
    public void release() {
        this.srtmProvider.release();
        this.globalProvider.release();
    }

    @Override
    public MultiSourceElevationProvider setAutoRemoveTemporaryFiles(boolean autoRemoveTemporary) {
        this.srtmProvider.setAutoRemoveTemporaryFiles(autoRemoveTemporary);
        this.globalProvider.setAutoRemoveTemporaryFiles(autoRemoveTemporary);
        return this;
    }

    public String toString() {
        return "multi";
    }
}

