/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathExtractor;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public class AStar
extends AbstractRoutingAlgorithm {
    private GHIntObjectHashMap<AStarEntry> fromMap;
    private PriorityQueue<AStarEntry> fromHeap;
    private AStarEntry currEdge;
    private int visitedNodes;
    private int to = -1;
    private WeightApproximator weightApprox;

    public AStar(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 2000);
        this.initCollections(size);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, weighting);
        defaultApprox.setDistanceCalc(DistancePlaneProjection.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    public AStar setApproximation(WeightApproximator approx) {
        this.weightApprox = approx;
        return this;
    }

    protected void initCollections(int size) {
        this.fromMap = new GHIntObjectHashMap();
        this.fromHeap = new PriorityQueue(size);
    }

    @Override
    public Path calcPath(int from, int to) {
        this.checkAlreadyRun();
        this.to = to;
        this.weightApprox.setTo(to);
        double weightToGoal = this.weightApprox.approximate(from);
        AStarEntry startEntry = new AStarEntry(-1, from, 0.0 + weightToGoal, 0.0);
        this.fromHeap.add(startEntry);
        if (!this.traversalMode.isEdgeBased()) {
            this.fromMap.put(from, this.currEdge);
        }
        this.runAlgo();
        return this.extractPath();
    }

    private void runAlgo() {
        while (!this.fromHeap.isEmpty()) {
            this.currEdge = this.fromHeap.poll();
            if (this.currEdge.isDeleted()) continue;
            ++this.visitedNodes;
            if (this.isMaxVisitedNodesExceeded() || this.finished()) break;
            int currNode = this.currEdge.adjNode;
            EdgeIterator iter = this.edgeExplorer.setBaseNode(currNode);
            while (iter.next()) {
                int traversalId;
                AStarEntry ase;
                double tmpWeight;
                if (!this.accept(iter, this.currEdge.edge) || Double.isInfinite(tmpWeight = GHUtility.calcWeightWithTurnWeightWithAccess(this.weighting, iter, false, this.currEdge.edge) + this.currEdge.weightOfVisitedPath) || (ase = (AStarEntry)this.fromMap.get(traversalId = this.traversalMode.createTraversalId(iter, false))) != null && !(ase.weightOfVisitedPath > tmpWeight)) continue;
                int neighborNode = iter.getAdjNode();
                double currWeightToGoal = this.weightApprox.approximate(neighborNode);
                double estimationFullWeight = tmpWeight + currWeightToGoal;
                if (ase == null) {
                    ase = new AStarEntry(iter.getEdge(), neighborNode, estimationFullWeight, tmpWeight, this.currEdge);
                    this.fromMap.put(traversalId, ase);
                } else {
                    ase.setDeleted();
                    ase = new AStarEntry(iter.getEdge(), neighborNode, estimationFullWeight, tmpWeight, this.currEdge);
                    this.fromMap.put(traversalId, ase);
                }
                this.fromHeap.add(ase);
                this.updateBestPath(iter, ase, traversalId);
            }
        }
    }

    @Override
    protected boolean finished() {
        return this.currEdge.adjNode == this.to;
    }

    @Override
    protected Path extractPath() {
        if (this.currEdge == null || !this.finished()) {
            return this.createEmptyPath();
        }
        return PathExtractor.extractPath(this.graph, this.weighting, this.currEdge);
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry bestSPTEntry, int traversalId) {
    }

    @Override
    public String getName() {
        return "astar|" + this.weightApprox;
    }

    public static class AStarEntry
    extends SPTEntry {
        double weightOfVisitedPath;

        public AStarEntry(int edgeId, int adjNode, double weightForHeap, double weightOfVisitedPath) {
            this(edgeId, adjNode, weightForHeap, weightOfVisitedPath, null);
        }

        public AStarEntry(int edgeId, int adjNode, double weightForHeap, double weightOfVisitedPath, SPTEntry parent) {
            super(edgeId, adjNode, weightForHeap, parent);
            this.weightOfVisitedPath = weightOfVisitedPath;
        }

        @Override
        public final double getWeightOfVisitedPath() {
            return this.weightOfVisitedPath;
        }

        @Override
        public AStarEntry getParent() {
            return (AStarEntry)this.parent;
        }
    }
}

