/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.IntsRef;

public class IntEncodedValueImpl
implements IntEncodedValue {
    private final String name;
    private final boolean storeTwoDirections;
    final int bits;
    final boolean negateReverseDirection;
    final int minStorableValue;
    final int maxStorableValue;
    int maxValue;
    private int fwdDataIndex;
    private int bwdDataIndex;
    int fwdShift = -1;
    int bwdShift = -1;
    int fwdMask;
    int bwdMask;

    public IntEncodedValueImpl(String name, int bits, boolean storeTwoDirections) {
        this(name, bits, 0, false, storeTwoDirections);
    }

    public IntEncodedValueImpl(String name, int bits, int minStorableValue, boolean negateReverseDirection, boolean storeTwoDirections) {
        if (!EncodingManager.isValidEncodedValue(name)) {
            throw new IllegalArgumentException("EncodedValue name wasn't valid: " + name + ". Use lower case letters, underscore and numbers only.");
        }
        if (bits <= 0) {
            throw new IllegalArgumentException(name + ": bits cannot be zero or negative");
        }
        if (bits > 31) {
            throw new IllegalArgumentException(name + ": at the moment the number of reserved bits cannot be more than 31");
        }
        if (negateReverseDirection && (minStorableValue != 0 || storeTwoDirections)) {
            throw new IllegalArgumentException(name + ": negating value for reverse direction only works for minValue == 0 and !storeTwoDirections but was minValue=" + minStorableValue + ", storeTwoDirections=" + storeTwoDirections);
        }
        this.name = name;
        this.storeTwoDirections = storeTwoDirections;
        int max = (1 << bits) - 1;
        this.minStorableValue = negateReverseDirection ? -max : minStorableValue;
        this.maxStorableValue = max + minStorableValue;
        if (minStorableValue == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("-2147483648 is not allowed for minValue");
        }
        this.maxValue = Integer.MIN_VALUE;
        this.bits = negateReverseDirection ? bits + 1 : bits;
        this.negateReverseDirection = negateReverseDirection;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    IntEncodedValueImpl(@JsonProperty(value="name") String name, @JsonProperty(value="bits") int bits, @JsonProperty(value="min_storable_value") int minStorableValue, @JsonProperty(value="max_storable_value") int maxStorableValue, @JsonProperty(value="max_value") int maxValue, @JsonProperty(value="negate_reverse_direction") boolean negateReverseDirection, @JsonProperty(value="store_two_directions") boolean storeTwoDirections, @JsonProperty(value="fwd_data_index") int fwdDataIndex, @JsonProperty(value="bwd_data_index") int bwdDataIndex, @JsonProperty(value="fwd_shift") int fwdShift, @JsonProperty(value="bwd_shift") int bwdShift, @JsonProperty(value="fwd_mask") int fwdMask, @JsonProperty(value="bwd_mask") int bwdMask) {
        this.name = name;
        this.storeTwoDirections = storeTwoDirections;
        this.bits = bits;
        this.negateReverseDirection = negateReverseDirection;
        this.minStorableValue = minStorableValue;
        this.maxStorableValue = maxStorableValue;
        this.maxValue = maxValue;
        this.fwdDataIndex = fwdDataIndex;
        this.bwdDataIndex = bwdDataIndex;
        this.fwdShift = fwdShift;
        this.bwdShift = bwdShift;
        this.fwdMask = fwdMask;
        this.bwdMask = bwdMask;
    }

    @Override
    public final int init(EncodedValue.InitializerConfig init) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call init multiple times");
        }
        init.next(this.bits);
        this.fwdMask = init.bitMask;
        this.fwdDataIndex = init.dataIndex;
        this.fwdShift = init.shift;
        if (this.storeTwoDirections) {
            init.next(this.bits);
            this.bwdMask = init.bitMask;
            this.bwdDataIndex = init.dataIndex;
            this.bwdShift = init.shift;
        }
        return this.storeTwoDirections ? 2 * this.bits : this.bits;
    }

    boolean isInitialized() {
        return this.fwdMask != 0;
    }

    @Override
    public final void setInt(boolean reverse, IntsRef ref, int value) {
        this.checkValue(value);
        this.uncheckedSet(reverse, ref, value);
    }

    private void checkValue(int value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("EncodedValue " + this.getName() + " not initialized");
        }
        if (value > this.maxStorableValue) {
            throw new IllegalArgumentException(this.name + " value too large for encoding: " + value + ", maxValue:" + this.maxStorableValue);
        }
        if (value < this.minStorableValue) {
            throw new IllegalArgumentException(this.name + " value too small for encoding " + value + ", minValue:" + this.minStorableValue);
        }
    }

    final void uncheckedSet(boolean reverse, IntsRef ref, int value) {
        if (this.negateReverseDirection) {
            if (reverse) {
                reverse = false;
                value = -value;
            }
        } else if (reverse && !this.storeTwoDirections) {
            throw new IllegalArgumentException(this.getName() + ": value for reverse direction would overwrite forward direction. Enable storeTwoDirections for this EncodedValue or don't use setReverse");
        }
        this.maxValue = Math.max(this.maxValue, value);
        value -= this.minStorableValue;
        if (reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            ref.ints[this.bwdDataIndex + ref.offset] = (flags &= ~this.bwdMask) | value << this.bwdShift;
        } else {
            int flags = ref.ints[this.fwdDataIndex + ref.offset];
            ref.ints[this.fwdDataIndex + ref.offset] = (flags &= ~this.fwdMask) | value << this.fwdShift;
        }
    }

    @Override
    public final int getInt(boolean reverse, IntsRef ref) {
        if (this.storeTwoDirections && reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            return this.minStorableValue + ((flags & this.bwdMask) >>> this.bwdShift);
        }
        int flags = ref.ints[this.fwdDataIndex + ref.offset];
        if (this.negateReverseDirection && reverse) {
            return -(this.minStorableValue + ((flags & this.fwdMask) >>> this.fwdShift));
        }
        return this.minStorableValue + ((flags & this.fwdMask) >>> this.fwdShift);
    }

    @Override
    public int getMaxStorableInt() {
        return this.maxStorableValue;
    }

    @Override
    public int getMinStorableInt() {
        return this.minStorableValue;
    }

    @Override
    public int getMaxOrMaxStorableInt() {
        return this.maxValue == Integer.MIN_VALUE ? this.getMaxStorableInt() : this.maxValue;
    }

    @Override
    public final boolean isStoreTwoDirections() {
        return this.storeTwoDirections;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }
}

