/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.BikeCommonTagParser;
import com.graphhopper.util.PMap;

public class BikeTagParser
extends BikeCommonTagParser {
    public BikeTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "bike"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "bike"))), lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "bike"))), lookup.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), lookup.getEnumEncodedValue("smoothness", Smoothness.class), properties.getString("name", "bike"), lookup.getBooleanEncodedValue("roundabout"), lookup.hasEncodedValue(TurnCost.key(properties.getString("name", "bike"))) ? lookup.getDecimalEncodedValue(TurnCost.key(properties.getString("name", "bike"))) : null);
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    public BikeTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc, EnumEncodedValue<Smoothness> smoothnessEnc, String name, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue turnCostEnc) {
        super(accessEnc, speedEnc, priorityEnc, bikeRouteEnc, smoothnessEnc, name, roundaboutEnc, turnCostEnc);
        this.addPushingSection("path");
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.addPushingSection("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.preferHighwayTags.add("service");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.preferHighwayTags.add("unclassified");
        this.barriers.add("kissing_gate");
        this.barriers.add("stile");
        this.barriers.add("turnstile");
        this.setSpecificClassBicycle("touring");
    }
}

