/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EncodedValueSerializer;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.DefaultVehicleEncodedValuesFactory;
import com.graphhopper.routing.util.VehicleEncodedValues;
import com.graphhopper.routing.util.VehicleEncodedValuesFactory;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EncodingManager
implements EncodedValueLookup {
    private final LinkedHashMap<String, EncodedValue> encodedValueMap;
    private final EncodedValue.InitializerConfig edgeConfig;
    private final EncodedValue.InitializerConfig turnCostConfig;
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("first_match", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "non-sealed", "null", "package", "permits", "private", "protected", "public", "record", "return", "sealed", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while", "yield", "_"));

    public static EncodingManager create(String flagEncodersStr) {
        return EncodingManager.create(new DefaultVehicleEncodedValuesFactory(), flagEncodersStr);
    }

    public static EncodingManager create(VehicleEncodedValuesFactory factory, String flagEncodersStr) {
        return EncodingManager.createBuilder(Arrays.stream(flagEncodersStr.split(",")).filter(s -> !s.trim().isEmpty()).map(s -> EncodingManager.parseEncoderString(factory, s)).collect(Collectors.toList())).build();
    }

    private static Builder createBuilder(List<? extends VehicleEncodedValues> vehicleEncodedValues) {
        Builder builder = new Builder();
        for (VehicleEncodedValues vehicleEncodedValues2 : vehicleEncodedValues) {
            builder.add(vehicleEncodedValues2);
        }
        return builder;
    }

    public static void putEncodingManagerIntoProperties(EncodingManager encodingManager, StorableProperties properties) {
        properties.put("graph.em.version", 1);
        properties.put("graph.em.edge_config", encodingManager.toEdgeConfigAsString());
        properties.put("graph.em.turn_cost_config", encodingManager.toTurnCostConfigAsString());
        properties.put("graph.encoded_values", encodingManager.toEncodedValuesAsString());
    }

    public static EncodingManager fromProperties(StorableProperties properties) {
        if (properties.containsVersion()) {
            throw new IllegalStateException("The GraphHopper file format is not compatible with the data you are trying to load. You either need to use an older version of GraphHopper or run a new import");
        }
        String versionStr = properties.get("graph.em.version");
        if (versionStr.isEmpty() || !String.valueOf(1).equals(versionStr)) {
            throw new IllegalStateException("Incompatible encoding version. You need to use the same GraphHopper version you used to import the graph, or run a new import.  Stored encoding version: " + (versionStr.isEmpty() ? "missing" : versionStr) + ", used encoding version: " + 1);
        }
        String encodedValueStr = properties.get("graph.encoded_values");
        ArrayNode evList = EncodingManager.deserializeEncodedValueList(encodedValueStr);
        LinkedHashMap<String, EncodedValue> encodedValues = new LinkedHashMap<String, EncodedValue>();
        evList.forEach(serializedEV -> {
            EncodedValue encodedValue = EncodedValueSerializer.deserializeEncodedValue(serializedEV.textValue());
            if (encodedValues.put(encodedValue.getName(), encodedValue) != null) {
                throw new IllegalStateException("Duplicate encoded value name: " + encodedValue.getName() + " in: graph.encoded_values=" + encodedValueStr);
            }
        });
        EncodedValue.InitializerConfig edgeConfig = EncodedValueSerializer.deserializeInitializerConfig(properties.get("graph.em.edge_config"));
        EncodedValue.InitializerConfig turnCostConfig = EncodedValueSerializer.deserializeInitializerConfig(properties.get("graph.em.turn_cost_config"));
        return new EncodingManager(encodedValues, edgeConfig, turnCostConfig);
    }

    private static ArrayNode deserializeEncodedValueList(String encodedValueStr) {
        try {
            return (ArrayNode)Jackson.newObjectMapper().readValue(encodedValueStr, ArrayNode.class);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static Builder start() {
        return new Builder();
    }

    public EncodingManager(LinkedHashMap<String, EncodedValue> encodedValueMap, EncodedValue.InitializerConfig edgeConfig, EncodedValue.InitializerConfig turnCostConfig) {
        this.encodedValueMap = encodedValueMap;
        this.turnCostConfig = turnCostConfig;
        this.edgeConfig = edgeConfig;
    }

    private EncodingManager() {
        this(new LinkedHashMap<String, EncodedValue>(), new EncodedValue.InitializerConfig(), new EncodedValue.InitializerConfig());
    }

    static VehicleEncodedValues parseEncoderString(VehicleEncodedValuesFactory factory, String encoderString) {
        if (!encoderString.equals(Helper.toLowerCase((String)encoderString))) {
            throw new IllegalArgumentException("An upper case name for the vehicle is not allowed: " + encoderString);
        }
        if ((encoderString = encoderString.trim()).isEmpty()) {
            throw new IllegalArgumentException("vehicle cannot be empty. " + encoderString);
        }
        String entryVal = "";
        if (encoderString.contains("|")) {
            entryVal = encoderString;
            encoderString = encoderString.split("\\|")[0];
        }
        PMap configuration = new PMap(entryVal);
        return factory.createVehicleEncodedValues(encoderString, configuration);
    }

    public int getIntsForFlags() {
        return this.edgeConfig.getRequiredInts();
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueMap.get(key) != null;
    }

    public List<String> getVehicles() {
        return this.getEncodedValues().stream().filter(ev -> ev.getName().endsWith("_access")).map(ev -> ev.getName().replaceAll("_access", "")).filter(v -> this.getEncodedValues().stream().anyMatch(ev -> ev.getName().contains(VehicleSpeed.key(v)))).collect(Collectors.toList());
    }

    public String toEncodedValuesAsString() {
        List serializedEVsList = this.encodedValueMap.values().stream().map(EncodedValueSerializer::serializeEncodedValue).collect(Collectors.toList());
        try {
            return Jackson.newObjectMapper().writeValueAsString(serializedEVsList);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public String toEdgeConfigAsString() {
        return EncodedValueSerializer.serializeInitializerConfig(this.edgeConfig);
    }

    public String toTurnCostConfigAsString() {
        return EncodedValueSerializer.serializeInitializerConfig(this.turnCostConfig);
    }

    public String toString() {
        return String.join((CharSequence)",", this.getVehicles());
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef(this.getIntsForFlags());
    }

    public IntsRef createRelationFlags() {
        return new IntsRef(2);
    }

    public boolean needsTurnCostsSupport() {
        return this.turnCostConfig.getRequiredBits() > 0;
    }

    @Override
    public List<EncodedValue> getEncodedValues() {
        return Collections.unmodifiableList(new ArrayList<EncodedValue>(this.encodedValueMap.values()));
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum<?>> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public StringEncodedValue getStringEncodedValue(String key) {
        return this.getEncodedValue(key, StringEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue " + key + " in collection: " + this.encodedValueMap.keySet());
        }
        return (T)ev;
    }

    public static String getKey(String prefix, String str) {
        return prefix + "_" + str;
    }

    public static boolean isValidEncodedValue(String name) {
        if (name.isEmpty() || !EncodingManager.isLowerLetter(name.charAt(0)) || KEYWORDS.contains(name)) {
            return false;
        }
        int underscoreCount = 0;
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                if (underscoreCount > 0) {
                    return false;
                }
                ++underscoreCount;
                continue;
            }
            if (!EncodingManager.isLowerLetter(c) && !EncodingManager.isNumber(c)) {
                return false;
            }
            underscoreCount = 0;
        }
        return true;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static class Builder {
        private EncodingManager em = new EncodingManager();

        public Builder add(VehicleEncodedValues v) {
            this.checkNotBuiltAlready();
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            v.createEncodedValues(list);
            list.forEach(this::add);
            list = new ArrayList();
            v.createTurnCostEncodedValues(list);
            list.forEach(this::addTurnCostEncodedValue);
            return this;
        }

        public Builder add(EncodedValue encodedValue) {
            this.checkNotBuiltAlready();
            if (this.em.hasEncodedValue(encodedValue.getName())) {
                throw new IllegalArgumentException("EncodedValue already exists: " + encodedValue.getName());
            }
            encodedValue.init(this.em.edgeConfig);
            this.em.encodedValueMap.put(encodedValue.getName(), encodedValue);
            return this;
        }

        public Builder addTurnCostEncodedValue(EncodedValue turnCostEnc) {
            this.checkNotBuiltAlready();
            if (this.em.hasEncodedValue(turnCostEnc.getName())) {
                throw new IllegalArgumentException("Already defined: " + turnCostEnc.getName() + ". Please note that EncodedValues for edges and turn costs are in the same namespace.");
            }
            turnCostEnc.init(this.em.turnCostConfig);
            this.em.encodedValueMap.put(turnCostEnc.getName(), turnCostEnc);
            return this;
        }

        private void checkNotBuiltAlready() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        public EncodingManager build() {
            this.checkNotBuiltAlready();
            this.addDefaultEncodedValues();
            if (this.em.encodedValueMap.isEmpty()) {
                throw new IllegalStateException("No EncodedValues were added to the EncodingManager");
            }
            EncodingManager result = this.em;
            this.em = null;
            return result;
        }

        private void addDefaultEncodedValues() {
            if (!this.em.hasEncodedValue("roundabout")) {
                this.add(Roundabout.create());
            }
            if (!this.em.hasEncodedValue("road_class")) {
                this.add(new EnumEncodedValue<RoadClass>("road_class", RoadClass.class));
            }
            if (!this.em.hasEncodedValue("road_class_link")) {
                this.add(new SimpleBooleanEncodedValue("road_class_link"));
            }
            if (!this.em.hasEncodedValue("road_environment")) {
                this.add(new EnumEncodedValue<RoadEnvironment>("road_environment", RoadEnvironment.class));
            }
            if (!this.em.hasEncodedValue("max_speed")) {
                this.add(MaxSpeed.create());
            }
            if (!this.em.hasEncodedValue("road_access")) {
                this.add(new EnumEncodedValue<RoadAccess>("road_access", RoadAccess.class));
            }
            for (String vehicle : this.em.getVehicles()) {
                if (vehicle.contains("bike") || vehicle.contains("mtb")) {
                    if (!this.em.hasEncodedValue(BikeNetwork.KEY)) {
                        this.add(new EnumEncodedValue<RouteNetwork>(BikeNetwork.KEY, RouteNetwork.class));
                    }
                    if (!this.em.hasEncodedValue("get_off_bike")) {
                        this.add(GetOffBike.create());
                    }
                    if (this.em.hasEncodedValue("smoothness")) continue;
                    this.add(new EnumEncodedValue<Smoothness>("smoothness", Smoothness.class));
                    continue;
                }
                if (!vehicle.contains("foot") && !vehicle.contains("hike") && !vehicle.contains("wheelchair") || this.em.hasEncodedValue(FootNetwork.KEY)) continue;
                this.add(new EnumEncodedValue<RouteNetwork>(FootNetwork.KEY, RouteNetwork.class));
            }
        }
    }
}

