/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.BikeCommonTagParser;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.util.PMap;
import java.util.TreeMap;

public class MountainBikeTagParser
extends BikeCommonTagParser {
    public MountainBikeTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key("mtb")), lookup.getDecimalEncodedValue(VehicleSpeed.key("mtb")), lookup.getDecimalEncodedValue(VehiclePriority.key("mtb")), lookup.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), lookup.getEnumEncodedValue("smoothness", Smoothness.class), lookup.getBooleanEncodedValue("roundabout"), lookup.hasEncodedValue(TurnCost.key("mtb")) ? lookup.getDecimalEncodedValue(TurnCost.key("mtb")) : null);
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected MountainBikeTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc, EnumEncodedValue<Smoothness> smoothnessEnc, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue turnCostEnc) {
        super(accessEnc, speedEnc, priorityEnc, bikeRouteEnc, smoothnessEnc, "mtb", roundaboutEnc, turnCostEnc);
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 16);
        this.setTrackTypeSpeed("grade3", 12);
        this.setTrackTypeSpeed("grade4", 8);
        this.setTrackTypeSpeed("grade5", 6);
        this.setSurfaceSpeed("concrete", 14);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("dirt", 14);
        this.setSurfaceSpeed("earth", 14);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 14);
        this.setSurfaceSpeed("grass_paver", 14);
        this.setSurfaceSpeed("gravel", 16);
        this.setSurfaceSpeed("ground", 16);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 12);
        this.setSurfaceSpeed("salt", 12);
        this.setSurfaceSpeed("sand", 10);
        this.setSurfaceSpeed("wood", 10);
        this.setHighwaySpeed("living_street", 4);
        this.setHighwaySpeed("steps", 4);
        this.setHighwaySpeed("path", 18);
        this.setHighwaySpeed("footway", 4);
        this.setHighwaySpeed("pedestrian", 4);
        this.setHighwaySpeed("track", 18);
        this.setHighwaySpeed("residential", 16);
        this.addPushingSection("footway");
        this.addPushingSection("platform");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.BEST.getValue());
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.preferHighwayTags.add("road");
        this.preferHighwayTags.add("track");
        this.preferHighwayTags.add("path");
        this.preferHighwayTags.add("service");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.preferHighwayTags.add("unclassified");
        this.setSpecificClassBicycle("mtb");
    }

    @Override
    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, Integer> weightToPrioMap) {
        super.collect(way, wayTypeSpeed, weightToPrioMap);
        String highway = way.getTag("highway");
        if ("track".equals(highway)) {
            String trackType = way.getTag("tracktype");
            if ("grade1".equals(trackType)) {
                weightToPrioMap.put(50.0, PriorityCode.UNCHANGED.getValue());
            } else if (trackType == null) {
                weightToPrioMap.put(90.0, PriorityCode.PREFER.getValue());
            } else if (trackType.startsWith("grade")) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            }
        }
    }

    @Override
    boolean isSacScaleAllowed(String sacScale) {
        return "hiking".equals(sacScale) || "mountain_hiking".equals(sacScale) || "demanding_mountain_hiking".equals(sacScale) || "alpine_hiking".equals(sacScale);
    }
}

