/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.shapes.GHPoint;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RoadDensityCalculator {
    private final Graph graph;
    private final EdgeExplorer edgeExplorer;
    private final IntSet visited;
    private final IntArrayDeque deque;

    public RoadDensityCalculator(Graph graph) {
        this.graph = graph;
        this.edgeExplorer = graph.createEdgeExplorer();
        this.visited = new IntScatterSet();
        this.deque = new IntArrayDeque(100);
    }

    public static void calcRoadDensities(Graph graph, BiConsumer<RoadDensityCalculator, EdgeIteratorState> edgeHandler, int threads) {
        ThreadLocal<RoadDensityCalculator> calculator = ThreadLocal.withInitial(() -> new RoadDensityCalculator(graph));
        Stream<Callable<String>> roadDensityWorkers = IntStream.range(0, graph.getEdges()).mapToObj(i -> () -> {
            EdgeIteratorState edge = graph.getEdgeIteratorState(i, Integer.MIN_VALUE);
            edgeHandler.accept((RoadDensityCalculator)calculator.get(), edge);
            return "road_density_calc";
        });
        GHUtility.runConcurrently(roadDensityWorkers, threads);
    }

    public double calcRoadDensity(EdgeIteratorState edge, double radius, ToDoubleFunction<EdgeIteratorState> calcRoadFactor) {
        this.visited.clear();
        this.deque.tail = 0;
        this.deque.head = 0;
        double totalRoadWeight = 0.0;
        NodeAccess na = this.graph.getNodeAccess();
        int baseNode = edge.getBaseNode();
        int adjNode = edge.getAdjNode();
        GHPoint center = new GHPoint(RoadDensityCalculator.getLat(na, baseNode, adjNode), RoadDensityCalculator.getLon(na, baseNode, adjNode));
        this.deque.addLast(baseNode);
        this.deque.addLast(adjNode);
        this.visited.add(baseNode);
        this.visited.add(adjNode);
        double radiusNormalized = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(radius);
        while (!this.deque.isEmpty()) {
            int node = this.deque.removeFirst();
            EdgeIterator iter = this.edgeExplorer.setBaseNode(node);
            while (iter.next()) {
                if (this.visited.contains(iter.getAdjNode())) continue;
                this.visited.add(iter.getAdjNode());
                double distance = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(center.lat, center.lon, RoadDensityCalculator.getLat(na, iter.getBaseNode(), iter.getAdjNode()), RoadDensityCalculator.getLon(na, iter.getBaseNode(), iter.getAdjNode()));
                if (distance > radiusNormalized) continue;
                double roadLength = Math.min(2.0 * radius, iter.getDistance());
                totalRoadWeight += roadLength * calcRoadFactor.applyAsDouble(iter);
                this.deque.addLast(iter.getAdjNode());
            }
        }
        return totalRoadWeight / radius / radius;
    }

    private static double getLat(NodeAccess na, int baseNode, int adjNode) {
        return (na.getLat(baseNode) + na.getLat(adjNode)) / 2.0;
    }

    private static double getLon(NodeAccess na, int baseNode, int adjNode) {
        return (na.getLon(baseNode) + na.getLon(adjNode)) / 2.0;
    }
}

