/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;

public class OSMMaxSpeedParser
implements TagParser {
    protected final DecimalEncodedValue carMaxSpeedEnc;

    public OSMMaxSpeedParser(DecimalEncodedValue carMaxSpeedEnc) {
        if (!carMaxSpeedEnc.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue for maxSpeed must be able to store two directions");
        }
        this.carMaxSpeedEnc = carMaxSpeedEnc;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        double bwdSpeed;
        double fwdSpeed;
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        CountryRule countryRule = way.getTag("country_rule", null);
        if (countryRule != null) {
            maxSpeed = countryRule.getMaxSpeed(way, TransportationMode.CAR, maxSpeed);
        }
        if (!this.isValidSpeed(fwdSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:forward"))) && this.isValidSpeed(maxSpeed)) {
            fwdSpeed = maxSpeed;
        }
        double maxPossibleSpeed = 150.0;
        if (this.isValidSpeed(fwdSpeed) && fwdSpeed > maxPossibleSpeed) {
            fwdSpeed = maxPossibleSpeed;
        }
        if (!this.isValidSpeed(bwdSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:backward"))) && this.isValidSpeed(maxSpeed)) {
            bwdSpeed = maxSpeed;
        }
        if (this.isValidSpeed(bwdSpeed) && bwdSpeed > maxPossibleSpeed) {
            bwdSpeed = maxPossibleSpeed;
        }
        if (!this.isValidSpeed(fwdSpeed)) {
            fwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(false, edgeFlags, fwdSpeed);
        if (!this.isValidSpeed(bwdSpeed)) {
            bwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(true, edgeFlags, bwdSpeed);
        return edgeFlags;
    }

    private boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }
}

