/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMRoadAccessParser
implements TagParser {
    protected final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final List<String> restrictions;

    public OSMRoadAccessParser(EnumEncodedValue<RoadAccess> roadAccessEnc, List<String> restrictions) {
        this.roadAccessEnc = roadAccessEnc;
        this.restrictions = restrictions;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        RoadAccess accessValue = RoadAccess.YES;
        for (String restriction : this.restrictions) {
            String[] complex;
            String tagValue = readerWay.getTag(restriction);
            if (tagValue == null) continue;
            for (String simple : complex = tagValue.split(";")) {
                RoadAccess tmpAccessValue = RoadAccess.find(simple);
                if (tmpAccessValue == null || tmpAccessValue.ordinal() <= accessValue.ordinal()) continue;
                accessValue = tmpAccessValue;
            }
        }
        CountryRule countryRule = readerWay.getTag("country_rule", null);
        if (countryRule != null) {
            accessValue = countryRule.getAccess(readerWay, TransportationMode.CAR, accessValue);
        }
        this.roadAccessEnc.setEnum(false, edgeFlags, accessValue);
        return edgeFlags;
    }

    public static List<String> toOSMRestrictions(TransportationMode mode) {
        switch (mode) {
            case FOOT: {
                return Arrays.asList("foot", "access");
            }
            case VEHICLE: {
                return Arrays.asList("vehicle", "access");
            }
            case BIKE: {
                return Arrays.asList("bicycle", "vehicle", "access");
            }
            case CAR: {
                return Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access");
            }
            case MOTORCYCLE: {
                return Arrays.asList("motorcycle", "motor_vehicle", "vehicle", "access");
            }
            case HGV: {
                return Arrays.asList("hgv", "motor_vehicle", "vehicle", "access");
            }
            case PSV: {
                return Arrays.asList("psv", "motor_vehicle", "vehicle", "access");
            }
        }
        throw new IllegalArgumentException("Cannot convert TransportationMode " + (Object)((Object)mode) + " to list of restrictions");
    }
}

