/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class FastestWeighting
extends AbstractWeighting {
    public static String DESTINATION_FACTOR = "road_access_destination_factor";
    public static String PRIVATE_FACTOR = "road_access_private_factor";
    protected static final double SPEED_CONV = 3.6;
    private final double headingPenalty;
    private final long headingPenaltyMillis;
    private final double maxSpeed;
    private final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final double destinationPenalty;
    private final double privatePenalty;

    public FastestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc) {
        this(accessEnc, speedEnc, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    public FastestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, TurnCostProvider turnCostProvider) {
        this(accessEnc, speedEnc, null, new PMap(0), turnCostProvider);
    }

    public FastestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, EnumEncodedValue<RoadAccess> roadAccessEnc, PMap map, TurnCostProvider turnCostProvider) {
        super(accessEnc, speedEnc, turnCostProvider);
        this.headingPenalty = map.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(this.headingPenalty * 1000.0);
        this.maxSpeed = speedEnc.getMaxOrMaxStorableDecimal() / 3.6;
        this.destinationPenalty = map.getDouble(DESTINATION_FACTOR, 1.0);
        this.privatePenalty = map.getDouble(PRIVATE_FACTOR, 1.0);
        FastestWeighting.checkBounds(DESTINATION_FACTOR, this.destinationPenalty, 1.0, 10.0);
        FastestWeighting.checkBounds(PRIVATE_FACTOR, this.privatePenalty, 1.0, 10.0);
        if (this.destinationPenalty > 1.0 || this.privatePenalty > 1.0) {
            if (roadAccessEnc == null) {
                throw new IllegalArgumentException("road_access must not be null when destination or private penalties are > 1");
            }
            this.roadAccessEnc = roadAccessEnc;
        } else {
            this.roadAccessEnc = null;
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        boolean unfavoredEdge;
        double speed;
        double d = speed = reverse ? edgeState.getReverse(this.speedEnc) : edgeState.get(this.speedEnc);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double time = edgeState.getDistance() / speed * 3.6;
        if (this.roadAccessEnc != null) {
            RoadAccess access = edgeState.get(this.roadAccessEnc);
            if (access == RoadAccess.DESTINATION) {
                time *= this.destinationPenalty;
            } else if (access == RoadAccess.PRIVATE) {
                time *= this.privatePenalty;
            }
        }
        if (unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE)) {
            time += this.headingPenalty;
        }
        return time;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        long time = 0L;
        boolean unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenaltyMillis;
        }
        return time + super.calcEdgeMillis(edgeState, reverse);
    }

    static double checkBounds(String key, double val, double from, double to) {
        if (val < from || val > to) {
            throw new IllegalArgumentException(key + " has invalid range should be within [" + from + ", " + to + "]");
        }
        return val;
    }

    @Override
    public String getName() {
        return "fastest";
    }
}

