/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class PriorityWeighting
extends FastestWeighting {
    private final double minFactor;
    private final double maxPrio;
    protected final DecimalEncodedValue priorityEnc;

    public PriorityWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RoadAccess> roadAccessEnc, PMap pMap, TurnCostProvider turnCostProvider) {
        super(accessEnc, speedEnc, roadAccessEnc, pMap, turnCostProvider);
        this.priorityEnc = priorityEnc;
        this.minFactor = 1.0 / PriorityCode.getValue(PriorityCode.BEST.getValue());
        this.maxPrio = PriorityCode.getFactor(PriorityCode.BEST.getValue());
    }

    @Override
    public double getMinWeight(double distance) {
        return this.minFactor * super.getMinWeight(distance);
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double weight = super.calcEdgeWeight(edgeState, reverse);
        if (Double.isInfinite(weight)) {
            return Double.POSITIVE_INFINITY;
        }
        double priority = edgeState.get(this.priorityEnc);
        if (priority > this.maxPrio) {
            throw new IllegalArgumentException("priority cannot be bigger than " + this.maxPrio + " but was " + priority);
        }
        return weight / priority;
    }
}

