/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.storage.IntsRef;

public final class EnumEncodedValue<E extends Enum>
extends IntEncodedValueImpl {
    @JsonIgnore
    private final E[] arr;
    private final Class<E> enumType;

    public EnumEncodedValue(String name, Class<E> enumType) {
        this(name, enumType, false);
    }

    public EnumEncodedValue(String name, Class<E> enumType, boolean storeTwoDirections) {
        super(name, 32 - Integer.numberOfLeadingZeros(((Enum[])enumType.getEnumConstants()).length - 1), storeTwoDirections);
        this.enumType = enumType;
        this.arr = (Enum[])enumType.getEnumConstants();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    EnumEncodedValue(@JsonProperty(value="name") String name, @JsonProperty(value="bits") int bits, @JsonProperty(value="min_storable_value") int minStorableValue, @JsonProperty(value="max_storable_value") int maxStorableValue, @JsonProperty(value="max_value") int maxValue, @JsonProperty(value="negate_reverse_direction") boolean negateReverseDirection, @JsonProperty(value="store_two_directions") boolean storeTwoDirections, @JsonProperty(value="fwd_data_index") int fwdDataIndex, @JsonProperty(value="bwd_data_index") int bwdDataIndex, @JsonProperty(value="fwd_shift") int fwdShift, @JsonProperty(value="bwd_shift") int bwdShift, @JsonProperty(value="fwd_mask") int fwdMask, @JsonProperty(value="bwd_mask") int bwdMask, @JsonProperty(value="enum_type") Class<E> enumType) {
        super(name, bits, minStorableValue, maxStorableValue, maxValue, negateReverseDirection, storeTwoDirections, fwdDataIndex, bwdDataIndex, fwdShift, bwdShift, fwdMask, bwdMask);
        this.enumType = enumType;
        this.arr = (Enum[])enumType.getEnumConstants();
    }

    public E[] getValues() {
        return this.arr;
    }

    public final void setEnum(boolean reverse, IntsRef ref, E value) {
        int intValue = ((Enum)value).ordinal();
        super.setInt(reverse, ref, intValue);
    }

    public final E getEnum(boolean reverse, IntsRef ref) {
        int value = super.getInt(reverse, ref);
        return this.arr[value];
    }
}

