/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.Helper;

public class LMRoutingAlgorithmFactory
implements RoutingAlgorithmFactory {
    private final LandmarkStorage lms;
    private int defaultActiveLandmarks;

    public LMRoutingAlgorithmFactory(LandmarkStorage lms) {
        this.lms = lms;
        this.defaultActiveLandmarks = Math.max(1, Math.min(lms.getLandmarkCount() / 2, 12));
    }

    public LMRoutingAlgorithmFactory setDefaultActiveLandmarks(int defaultActiveLandmarks) {
        this.defaultActiveLandmarks = defaultActiveLandmarks;
        return this;
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph g, Weighting w, AlgorithmOptions opts) {
        if (!this.lms.isInitialized()) {
            throw new IllegalStateException("Initialize landmark storage before creating algorithms");
        }
        int activeLM = Math.max(1, opts.getHints().getInt("lm.active_landmarks", this.defaultActiveLandmarks));
        String algoStr = opts.getAlgorithm();
        Weighting weighting = g.wrapWeighting(w);
        if ("astar".equalsIgnoreCase(algoStr)) {
            double epsilon = opts.getHints().getDouble("astar.epsilon", 1.0);
            AStar algo = new AStar(g, weighting, opts.getTraversalMode());
            algo.setApproximation(this.getApproximator(g, weighting, activeLM, epsilon));
            algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
            return algo;
        }
        if ("astarbi".equalsIgnoreCase(algoStr) || Helper.isEmpty((String)algoStr)) {
            double epsilon = opts.getHints().getDouble("astarbi.epsilon", 1.0);
            AStarBidirection algo = new AStarBidirection(g, weighting, opts.getTraversalMode());
            algo.setApproximation(this.getApproximator(g, weighting, activeLM, epsilon));
            algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
            return algo;
        }
        if ("alternative_route".equalsIgnoreCase(algoStr)) {
            double epsilon = opts.getHints().getDouble("astarbi.epsilon", 1.0);
            AlternativeRoute algo = new AlternativeRoute(g, weighting, opts.getTraversalMode(), opts.getHints());
            algo.setApproximation(this.getApproximator(g, weighting, activeLM, epsilon));
            algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
            return algo;
        }
        throw new IllegalArgumentException("Landmarks algorithm only supports algorithm=astar,astarbi or alternative_route, but got: " + algoStr);
    }

    private LMApproximator getApproximator(Graph g, Weighting weighting, int activeLM, double epsilon) {
        return LMApproximator.forLandmarks(g, weighting, this.lms, activeLM).setEpsilon(epsilon);
    }
}

