/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;

public class CurvatureCalculator
implements TagParser {
    private final DecimalEncodedValue curvatureEnc;

    public CurvatureCalculator(DecimalEncodedValue curvatureEnc) {
        this.curvatureEnc = curvatureEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        PointList pointList = way.getTag("point_list", null);
        Double edgeDistance = way.getTag("edge_distance", null);
        if (pointList != null && edgeDistance != null && !pointList.isEmpty()) {
            double beeline = DistanceCalcEarth.DIST_EARTH.calcDist(pointList.getLat(0), pointList.getLon(0), pointList.getLat(pointList.size() - 1), pointList.getLon(pointList.size() - 1));
            double curvature = beeline / edgeDistance;
            this.curvatureEnc.setDecimal(false, edgeFlags, Math.max(this.curvatureEnc.getMinStorableDecimal(), Math.min(this.curvatureEnc.getMaxStorableDecimal(), curvature)));
        } else {
            this.curvatureEnc.setDecimal(false, edgeFlags, 1.0);
        }
    }
}

