/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.util.RoadDensityCalculator;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.StopWatch;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanDensityCalculator {
    private static final Logger logger = LoggerFactory.getLogger(UrbanDensityCalculator.class);

    public static void calcUrbanDensity(Graph graph, EnumEncodedValue<UrbanDensity> urbanDensityEnc, EnumEncodedValue<RoadClass> roadClassEnc, BooleanEncodedValue roadClassLinkEnc, double residentialAreaRadius, double residentialAreaSensitivity, double cityAreaRadius, double cityAreaSensitivity, int threads) {
        logger.info("Calculating residential areas ..., radius={}, sensitivity={}, threads={}", new Object[]{residentialAreaRadius, residentialAreaSensitivity, threads});
        StopWatch sw = StopWatch.started();
        UrbanDensityCalculator.calcResidential(graph, urbanDensityEnc, roadClassEnc, roadClassLinkEnc, residentialAreaRadius, residentialAreaSensitivity, threads);
        logger.info("Finished calculating residential areas, took: " + sw.stop().getSeconds() + "s");
        if (cityAreaRadius > 1.0) {
            logger.info("Calculating city areas ..., radius={}, sensitivity={}, threads={}", new Object[]{cityAreaRadius, cityAreaSensitivity, threads});
            sw = StopWatch.started();
            UrbanDensityCalculator.calcCity(graph, urbanDensityEnc, cityAreaRadius, cityAreaSensitivity, threads);
            logger.info("Finished calculating city areas, took: " + sw.stop().getSeconds() + "s");
        }
    }

    private static void calcResidential(Graph graph, EnumEncodedValue<UrbanDensity> urbanDensityEnc, EnumEncodedValue<RoadClass> roadClassEnc, BooleanEncodedValue roadClassLinkEnc, double radius, double sensitivity, int threads) {
        ToDoubleFunction<EdgeIteratorState> calcRoadFactor = edge -> {
            if (edge.get(roadClassLinkEnc)) {
                return 0.0;
            }
            RoadClass roadClass = (RoadClass)((Object)((Object)edge.get(roadClassEnc)));
            switch (roadClass) {
                case RESIDENTIAL: 
                case LIVING_STREET: 
                case FOOTWAY: 
                case CYCLEWAY: 
                case STEPS: {
                    return 2.0;
                }
                case MOTORWAY: 
                case TRUNK: 
                case PRIMARY: 
                case SECONDARY: 
                case TERTIARY: 
                case SERVICE: 
                case OTHER: {
                    return 1.0;
                }
            }
            return 0.0;
        };
        boolean[] isResidential = new boolean[graph.getEdges()];
        RoadDensityCalculator.calcRoadDensities(graph, (calculator, edge) -> {
            RoadClass roadClass = (RoadClass)((Object)((Object)edge.get(roadClassEnc)));
            if (roadClass == RoadClass.RESIDENTIAL || roadClass == RoadClass.LIVING_STREET) {
                isResidential[edge.getEdge()] = true;
                return;
            }
            double roadDensity = calculator.calcRoadDensity((EdgeIteratorState)edge, radius, calcRoadFactor);
            isResidential[edge.getEdge()] = roadDensity * sensitivity >= 1.0;
        }, threads);
        for (int edge2 = 0; edge2 < isResidential.length; ++edge2) {
            graph.getEdgeIteratorState(edge2, Integer.MIN_VALUE).set(urbanDensityEnc, isResidential[edge2] ? UrbanDensity.RESIDENTIAL : UrbanDensity.RURAL);
        }
    }

    private static void calcCity(Graph graph, EnumEncodedValue<UrbanDensity> urbanDensityEnc, double radius, double sensitivity, int threads) {
        boolean[] isCity = new boolean[graph.getEdges()];
        ToDoubleFunction<EdgeIteratorState> calcRoadFactor = edge -> edge.get(urbanDensityEnc) == UrbanDensity.RESIDENTIAL ? 1.0 : 0.0;
        RoadDensityCalculator.calcRoadDensities(graph, (calculator, edge) -> {
            UrbanDensity urbanDensity = (UrbanDensity)((Object)((Object)edge.get(urbanDensityEnc)));
            if (urbanDensity == UrbanDensity.RURAL) {
                return;
            }
            double roadDensity = calculator.calcRoadDensity((EdgeIteratorState)edge, radius, calcRoadFactor);
            if (roadDensity * sensitivity >= 1.0) {
                isCity[edge.getEdge()] = true;
            }
        }, threads);
        for (int edge2 = 0; edge2 < isCity.length; ++edge2) {
            if (!isCity[edge2]) continue;
            graph.getEdgeIteratorState(edge2, Integer.MIN_VALUE).set(urbanDensityEnc, UrbanDensity.CITY);
        }
    }
}

