/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.ConditionalTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAccessParser
implements TagParser {
    static final Collection<String> FERRIES = Arrays.asList("shuttle_train", "ferry");
    static final Collection<String> ONEWAYS = Arrays.asList("yes", "true", "1", "-1");
    static final Collection<String> INTENDED = Arrays.asList("yes", "designated", "official", "permissive");
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> intendedValues = new HashSet<String>(INTENDED);
    protected final Set<String> ferries = new HashSet<String>(FERRIES);
    protected final Set<String> oneways = new HashSet<String>(ONEWAYS);
    protected final Set<String> barriers = new HashSet<String>(5);
    protected final BooleanEncodedValue accessEnc;
    private boolean blockFords = true;
    private ConditionalTagInspector conditionalTagInspector;

    protected AbstractAccessParser(BooleanEncodedValue accessEnc, TransportationMode transportationMode) {
        this.accessEnc = accessEnc;
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.restrictedValues.add("permit");
        this.restrictions.addAll(OSMRoadAccessParser.toOSMRestrictions(transportationMode));
    }

    public AbstractAccessParser init(DateRangeParser dateRangeParser) {
        this.setConditionalTagInspector(new ConditionalOSMTagInspector(Collections.singletonList(dateRangeParser), this.restrictions, this.restrictedValues, this.intendedValues, false));
        return this;
    }

    protected void setConditionalTagInspector(ConditionalTagInspector inspector) {
        this.conditionalTagInspector = inspector;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    protected void blockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    protected void blockPrivate(boolean blockPrivate) {
        if (!blockPrivate) {
            if (!this.restrictedValues.remove("private")) {
                throw new IllegalStateException("no 'private' found in restrictedValues");
            }
            if (!this.restrictedValues.remove("permit")) {
                throw new IllegalStateException("no 'permit' found in restrictedValues");
            }
            this.intendedValues.add("private");
            this.intendedValues.add("permit");
        }
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    protected void handleNodeTags(IntsRef edgeFlags, Map<String, Object> nodeTags) {
        ReaderNode readerNode;
        if (!nodeTags.isEmpty() && this.isBarrier(readerNode = new ReaderNode(0L, 0.0, 0.0, nodeTags))) {
            BooleanEncodedValue accessEnc = this.getAccessEnc();
            accessEnc.setBool(false, edgeFlags, false);
            accessEnc.setBool(true, edgeFlags, false);
        }
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        this.handleWayTags(edgeFlags, way);
    }

    public abstract void handleWayTags(IntsRef var1, ReaderWay var2);

    public boolean isBarrier(ReaderNode node) {
        String firstValue = node.getFirstPriorityTag(this.restrictions);
        if (this.restrictedValues.contains(firstValue) || node.hasTag("locked", (Object)"yes")) {
            return true;
        }
        if (this.intendedValues.contains(firstValue)) {
            return false;
        }
        if (node.hasTag("barrier", this.barriers)) {
            return true;
        }
        return this.blockFords && node.hasTag("ford", (Object)"yes");
    }

    public final BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    public final List<String> getRestrictions() {
        return this.restrictions;
    }

    public final String getName() {
        return this.accessEnc.getName();
    }

    public String toString() {
        return this.getName();
    }
}

