/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractAverageSpeedParser
implements TagParser {
    protected final DecimalEncodedValue avgSpeedEnc;
    protected final double maxPossibleSpeed;
    protected final Set<String> ferries = new HashSet<String>(AbstractAccessParser.FERRIES);
    protected final FerrySpeedCalculator ferrySpeedCalc;

    protected AbstractAverageSpeedParser(DecimalEncodedValue speedEnc, double maxPossibleSpeed) {
        this.maxPossibleSpeed = maxPossibleSpeed;
        this.avgSpeedEnc = speedEnc;
        this.ferrySpeedCalc = new FerrySpeedCalculator(speedEnc.getSmallestNonZeroValue(), maxPossibleSpeed, 5.0);
    }

    public double getMaxSpeed() {
        return this.maxPossibleSpeed;
    }

    public static double getMaxSpeed(ReaderWay way, boolean bwd) {
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        double directedMaxSpeed = OSMValueExtractor.stringToKmh(way.getTag(bwd ? "maxspeed:backward" : "maxspeed:forward"));
        if (AbstractAverageSpeedParser.isValidSpeed(directedMaxSpeed) && (!AbstractAverageSpeedParser.isValidSpeed(maxSpeed) || directedMaxSpeed < maxSpeed)) {
            maxSpeed = directedMaxSpeed;
        }
        return maxSpeed;
    }

    protected static boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }

    public final DecimalEncodedValue getAverageSpeedEnc() {
        return this.avgSpeedEnc;
    }

    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        if (speed > 0.1 && speed < this.avgSpeedEnc.getSmallestNonZeroValue()) {
            speed = this.avgSpeedEnc.getSmallestNonZeroValue();
        }
        if (speed < this.avgSpeedEnc.getSmallestNonZeroValue()) {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, 0.0);
        } else {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, Math.min(speed, this.getMaxSpeed()));
        }
    }

    public final String getName() {
        return this.avgSpeedEnc.getName();
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        this.handleWayTags(edgeFlags, way);
    }

    public abstract void handleWayTags(IntsRef var1, ReaderWay var2);

    public String toString() {
        return this.getName();
    }
}

