/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BikeCommonAccessParser
extends AbstractAccessParser
implements TagParser {
    protected final HashSet<String> oppositeLanes = new HashSet();
    private final Set<String> allowedHighways = new HashSet<String>();
    private final BooleanEncodedValue roundaboutEnc;

    protected BikeCommonAccessParser(BooleanEncodedValue accessEnc, BooleanEncodedValue roundaboutEnc) {
        super(accessEnc, TransportationMode.BIKE);
        this.roundaboutEnc = roundaboutEnc;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("delivery");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.oppositeLanes.add("opposite");
        this.oppositeLanes.add("opposite_lane");
        this.oppositeLanes.add("opposite_track");
        this.barriers.add("fence");
        this.allowedHighways.addAll(Arrays.asList("living_street", "steps", "cycleway", "path", "footway", "platform", "pedestrian", "track", "service", "residential", "unclassified", "road", "bridleway", "motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link"));
    }

    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String bikeTag;
            WayAccess access = WayAccess.CAN_SKIP;
            if (way.hasTag("route", (Collection<String>)this.ferries) && ((bikeTag = way.getTag("bicycle")) == null && !way.hasTag("foot", new String[0]) || this.intendedValues.contains(bikeTag))) {
                access = WayAccess.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                access = WayAccess.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                access = WayAccess.WAY;
            }
            if (!access.canSkip()) {
                if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return WayAccess.CAN_SKIP;
                }
                return access;
            }
            return WayAccess.CAN_SKIP;
        }
        if (!this.allowedHighways.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        String sacScale = way.getTag("sac_scale");
        if (sacScale != null && !this.isSacScaleAllowed(sacScale)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("bicycle", (Object)"dismount") || way.hasTag("highway", (Object)"cycleway")) {
            return WayAccess.WAY;
        }
        boolean permittedWayConditionallyRestricted = this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way);
        boolean restrictedWayConditionallyPermitted = this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (!firstValue.isEmpty()) {
            String[] restrict;
            for (String value : restrict = firstValue.split(";")) {
                if (this.restrictedValues.contains(value) && !restrictedWayConditionallyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value) || permittedWayConditionallyRestricted) continue;
                return WayAccess.WAY;
            }
        }
        if ("motorway".equals(highwayValue) || "motorway_link".equals(highwayValue) || "bridleway".equals(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return WayAccess.CAN_SKIP;
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (permittedWayConditionallyRestricted) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    boolean isSacScaleAllowed(String sacScale) {
        return "hiking".equals(sacScale);
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (access.isFerry()) {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        } else {
            this.handleAccess(edgeFlags, way);
        }
        Map<String, Object> nodeTags = way.getTag("node_tags", Collections.emptyMap());
        this.handleNodeTags(edgeFlags, nodeTags);
    }

    protected void handleAccess(IntsRef edgeFlags, ReaderWay way) {
        boolean isOneway;
        boolean bl = isOneway = way.hasTag("oneway", (Collection<String>)this.oneways) && !way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:backward", (Collection<String>)this.intendedValues) || way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:forward", (Collection<String>)this.intendedValues) || way.hasTag("oneway:bicycle", (Collection<String>)this.oneways) || way.hasTag("cycleway:left:oneway", (Collection<String>)this.oneways) || way.hasTag("cycleway:right:oneway", (Collection<String>)this.oneways) || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:forward", (Collection<String>)this.intendedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:backward", (Collection<String>)this.intendedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:backward", (Collection<String>)this.restrictedValues);
        if (!(!isOneway && !this.roundaboutEnc.getBool(false, edgeFlags) || way.hasTag("oneway:bicycle", (Object)"no") || way.hasTag("cycleway", this.oppositeLanes) || way.hasTag("cycleway:left", this.oppositeLanes) || way.hasTag("cycleway:right", this.oppositeLanes) || way.hasTag("cycleway:left:oneway", (Object)"no") || way.hasTag("cycleway:right:oneway", (Object)"no"))) {
            boolean isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("oneway:bicycle", (Object)"-1") || way.hasTag("cycleway:left:oneway", (Object)"-1") || way.hasTag("cycleway:right:oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues);
            this.accessEnc.setBool(isBackward, edgeFlags, true);
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
    }
}

