/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BikeCommonAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    public static double MAX_SPEED = 30.0;
    protected static final int PUSHING_SECTION_SPEED = 4;
    protected static final int MIN_SPEED = 2;
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    private final Map<String, Integer> trackTypeSpeeds = new HashMap<String, Integer>();
    private final Map<String, Integer> surfaceSpeeds = new HashMap<String, Integer>();
    private final Map<Smoothness, Double> smoothnessFactor = new HashMap<Smoothness, Double>();
    private final Map<String, Integer> highwaySpeeds = new HashMap<String, Integer>();
    private final EnumEncodedValue<Smoothness> smoothnessEnc;
    protected final Set<String> intendedValues = new HashSet<String>(5);

    protected BikeCommonAverageSpeedParser(DecimalEncodedValue speedEnc, EnumEncodedValue<Smoothness> smoothnessEnc) {
        super(speedEnc, speedEnc.getNextStorableValue(MAX_SPEED));
        this.smoothnessEnc = smoothnessEnc;
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.addPushingSection("platform");
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 12);
        this.setTrackTypeSpeed("grade3", 8);
        this.setTrackTypeSpeed("grade4", 6);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 8);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 18);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 14);
        this.setSurfaceSpeed("paving_stones:30", 14);
        this.setSurfaceSpeed("unpaved", 12);
        this.setSurfaceSpeed("compacted", 14);
        this.setSurfaceSpeed("dirt", 10);
        this.setSurfaceSpeed("earth", 12);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 8);
        this.setSurfaceSpeed("grass_paver", 8);
        this.setSurfaceSpeed("gravel", 12);
        this.setSurfaceSpeed("ground", 12);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 10);
        this.setSurfaceSpeed("pebblestone", 14);
        this.setSurfaceSpeed("salt", 4);
        this.setSurfaceSpeed("sand", 4);
        this.setSurfaceSpeed("wood", 4);
        this.setHighwaySpeed("living_street", 4);
        this.setHighwaySpeed("steps", 2);
        int CYCLEWAY_SPEED = 18;
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 10);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("platform", 4);
        this.setHighwaySpeed("pedestrian", 4);
        this.setHighwaySpeed("track", 12);
        this.setHighwaySpeed("service", 12);
        this.setHighwaySpeed("residential", 18);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.setHighwaySpeed("motorway", 18);
        this.setHighwaySpeed("motorway_link", 18);
        this.setHighwaySpeed("bridleway", 4);
        this.setSmoothnessSpeedFactor(Smoothness.MISSING, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.OTHER, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.EXCELLENT, 1.1);
        this.setSmoothnessSpeedFactor(Smoothness.GOOD, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.INTERMEDIATE, 0.9);
        this.setSmoothnessSpeedFactor(Smoothness.BAD, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_BAD, 0.4);
        this.setSmoothnessSpeedFactor(Smoothness.HORRIBLE, 0.3);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_HORRIBLE, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.IMPASSABLE, 0.0);
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
    }

    public double applyMaxSpeed(ReaderWay way, double speed, boolean bwd) {
        double maxSpeed = BikeCommonAverageSpeedParser.getMaxSpeed(way, bwd);
        if (BikeCommonAverageSpeedParser.isValidSpeed(maxSpeed) && speed > maxSpeed) {
            return maxSpeed;
        }
        if (BikeCommonAverageSpeedParser.isValidSpeed(speed) && speed > this.maxPossibleSpeed) {
            return this.maxPossibleSpeed;
        }
        return speed;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
                this.avgSpeedEnc.setDecimal(false, edgeFlags, ferrySpeed);
                if (this.avgSpeedEnc.isStoreTwoDirections()) {
                    this.avgSpeedEnc.setDecimal(true, edgeFlags, ferrySpeed);
                }
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        double speed = this.getSpeed(way);
        Smoothness smoothness = this.smoothnessEnc.getEnum(false, edgeFlags);
        speed = Math.max(2.0, this.smoothnessFactor.get((Object)smoothness) * speed);
        double speedFwd = this.applyMaxSpeed(way, speed, false);
        this.avgSpeedEnc.setDecimal(false, edgeFlags, speedFwd);
        if (this.avgSpeedEnc.isStoreTwoDirections()) {
            speed = this.applyMaxSpeed(way, speed, true);
            this.avgSpeedEnc.setDecimal(true, edgeFlags, speed);
        }
    }

    int getSpeed(ReaderWay way) {
        int speed = 4;
        String highwayTag = way.getTag("highway");
        Integer highwaySpeed = this.highwaySpeeds.get(highwayTag);
        if (way.hasTag("railway", (Object)"platform")) {
            highwaySpeed = 4;
        } else if (way.hasTag("highway", this.pushingSectionsHighways) && (way.hasTag("foot", (Object)"yes") && way.hasTag("segregated", (Object)"yes") || way.hasTag("bicycle", this.intendedValues))) {
            highwaySpeed = this.getHighwaySpeed("cycleway");
        }
        String s = way.getTag("surface");
        Integer surfaceSpeed = 0;
        if (!Helper.isEmpty((String)s)) {
            surfaceSpeed = this.surfaceSpeeds.get(s);
            if (surfaceSpeed != null) {
                speed = surfaceSpeed;
                if (highwaySpeed != null && surfaceSpeed > highwaySpeed) {
                    speed = this.pushingSectionsHighways.contains(highwayTag) ? highwaySpeed.intValue() : surfaceSpeed.intValue();
                }
            }
        } else {
            String tt = way.getTag("tracktype");
            if (!Helper.isEmpty((String)tt)) {
                Integer tInt = this.trackTypeSpeeds.get(tt);
                if (tInt != null) {
                    speed = tInt;
                }
            } else if (highwaySpeed != null) {
                speed = !way.hasTag("service", new String[0]) ? highwaySpeed.intValue() : this.highwaySpeeds.get("living_street").intValue();
            }
        }
        if (speed > 4 && (way.hasTag("highway", this.pushingSectionsHighways) || way.hasTag("bicycle", (Object)"dismount"))) {
            if (!way.hasTag("bicycle", this.intendedValues)) {
                speed = way.hasTag("highway", (Object)"steps") ? 2 : 4;
            } else if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official") || way.hasTag("segregated", (Object)"yes") || way.hasTag("bicycle", (Object)"yes")) {
                if (way.hasTag("segregated", (Object)"yes")) {
                    speed = this.highwaySpeeds.get("cycleway");
                } else {
                    int n = speed = way.hasTag("bicycle", (Object)"yes") ? 10 : this.highwaySpeeds.get("cycleway");
                }
                if (surfaceSpeed > 0) {
                    speed = Math.min(speed, surfaceSpeed);
                }
            }
        }
        return speed;
    }

    void setHighwaySpeed(String highway, int speed) {
        this.highwaySpeeds.put(highway, speed);
    }

    int getHighwaySpeed(String key) {
        return this.highwaySpeeds.get(key);
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    void setTrackTypeSpeed(String tracktype, int speed) {
        this.trackTypeSpeeds.put(tracktype, speed);
    }

    void setSurfaceSpeed(String surface, int speed) {
        this.surfaceSpeeds.put(surface, speed);
    }

    void setSmoothnessSpeedFactor(Smoothness smoothness, double speedfactor) {
        this.smoothnessFactor.put(smoothness, speedfactor);
    }
}

