/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BikeCommonPriorityParser
implements TagParser {
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    protected final Set<String> preferHighwayTags = new HashSet<String>();
    protected final Set<String> avoidHighwayTags = new HashSet<String>();
    protected final Set<String> unpavedSurfaceTags = new HashSet<String>();
    protected final Set<String> ferries = new HashSet<String>(AbstractAccessParser.FERRIES);
    protected final Set<String> intendedValues = new HashSet<String>(AbstractAccessParser.INTENDED);
    protected final DecimalEncodedValue avgSpeedEnc;
    protected final DecimalEncodedValue priorityEnc;
    int avoidSpeedLimit;
    EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();
    private String classBicycleKey;

    protected BikeCommonPriorityParser(DecimalEncodedValue priorityEnc, DecimalEncodedValue avgSpeedEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc) {
        this.bikeRouteEnc = bikeRouteEnc;
        this.priorityEnc = priorityEnc;
        this.avgSpeedEnc = avgSpeedEnc;
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.addPushingSection("platform");
        this.unpavedSurfaceTags.add("unpaved");
        this.unpavedSurfaceTags.add("gravel");
        this.unpavedSurfaceTags.add("ground");
        this.unpavedSurfaceTags.add("dirt");
        this.unpavedSurfaceTags.add("grass");
        this.unpavedSurfaceTags.add("compacted");
        this.unpavedSurfaceTags.add("earth");
        this.unpavedSurfaceTags.add("fine_gravel");
        this.unpavedSurfaceTags.add("grass_paver");
        this.unpavedSurfaceTags.add("ice");
        this.unpavedSurfaceTags.add("mud");
        this.unpavedSurfaceTags.add("salt");
        this.unpavedSurfaceTags.add("sand");
        this.unpavedSurfaceTags.add("wood");
        this.avoidHighwayTags.add("steps");
        this.avoidHighwayTags.add("motorway");
        this.avoidHighwayTags.add("motorway_link");
        this.avoidHighwayTags.add("bridleway");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.PREFER.getValue());
        this.avoidSpeedLimit = 71;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        String highwayValue = way.getTag("highway");
        Integer priorityFromRelation = this.routeMap.get((Object)this.bikeRouteEnc.getEnum(false, edgeFlags));
        if (highwayValue == null) {
            if (way.hasTag("route", this.ferries)) {
                priorityFromRelation = PriorityCode.SLIGHT_AVOID.getValue();
            } else {
                return;
            }
        }
        double maxSpeed = Math.max(this.avgSpeedEnc.getDecimal(false, edgeFlags), this.avgSpeedEnc.getDecimal(true, edgeFlags));
        this.priorityEnc.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way, maxSpeed, priorityFromRelation)));
    }

    int handlePriority(ReaderWay way, double wayTypeSpeed, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, wayTypeSpeed, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    private PriorityCode convertClassValueToPriority(String tagvalue) {
        int classvalue;
        try {
            classvalue = Integer.parseInt(tagvalue);
        }
        catch (NumberFormatException e) {
            return PriorityCode.UNCHANGED;
        }
        switch (classvalue) {
            case 3: {
                return PriorityCode.BEST;
            }
            case 2: {
                return PriorityCode.VERY_NICE;
            }
            case 1: {
                return PriorityCode.PREFER;
            }
            case 0: {
                return PriorityCode.UNCHANGED;
            }
            case -1: {
                return PriorityCode.SLIGHT_AVOID;
            }
            case -2: {
                return PriorityCode.AVOID;
            }
            case -3: {
                return PriorityCode.AVOID_MORE;
            }
        }
        return PriorityCode.UNCHANGED;
    }

    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, Integer> weightToPrioMap) {
        int lastEntryValue;
        String classBicycleValue;
        String highway = way.getTag("highway");
        if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
            if ("path".equals(highway)) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            }
        }
        if ("cycleway".equals(highway)) {
            if (way.hasTag("foot", this.intendedValues) && !way.hasTag("segregated", (Object)"yes")) {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            }
        }
        double maxSpeed = Math.max(AbstractAverageSpeedParser.getMaxSpeed(way, false), AbstractAverageSpeedParser.getMaxSpeed(way, true));
        if (this.preferHighwayTags.contains(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed <= 30.0) {
            if (!AbstractAverageSpeedParser.isValidSpeed(maxSpeed) || maxSpeed < (double)this.avoidSpeedLimit) {
                weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
                if (way.hasTag("tunnel", this.intendedValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (this.avoidHighwayTags.contains(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed >= (double)this.avoidSpeedLimit && !"track".equals(highway)) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID.getValue());
            if (way.hasTag("tunnel", this.intendedValues) || way.hasTag("hazmat", this.intendedValues)) {
                weightToPrioMap.put(50.0, PriorityCode.BAD.getValue());
            }
        }
        String cycleway = way.getFirstPriorityTag(Arrays.asList("cycleway", "cycleway:left", "cycleway:right"));
        if (Arrays.asList("lane", "shared_lane", "share_busway", "shoulder").contains(cycleway)) {
            weightToPrioMap.put(100.0, PriorityCode.UNCHANGED.getValue());
        } else if ("track".equals(cycleway)) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        if (way.hasTag("bicycle", (Object)"use_sidepath")) {
            weightToPrioMap.put(100.0, PriorityCode.REACH_DESTINATION.getValue());
        }
        if (this.pushingSectionsHighways.contains(highway) || "parking_aisle".equals(way.getTag("service"))) {
            PriorityCode pushingSectionPrio = PriorityCode.SLIGHT_AVOID;
            if (way.hasTag("bicycle", (Object)"yes") || way.hasTag("bicycle", (Object)"permissive")) {
                pushingSectionPrio = PriorityCode.PREFER;
            }
            if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
                pushingSectionPrio = PriorityCode.VERY_NICE;
            }
            if (way.hasTag("foot", (Object)"yes")) {
                pushingSectionPrio = PriorityCode.values()[pushingSectionPrio.ordinal() - 1];
                if (way.hasTag("segregated", (Object)"yes")) {
                    pushingSectionPrio = PriorityCode.values()[pushingSectionPrio.ordinal() + 1];
                }
            }
            weightToPrioMap.put(100.0, pushingSectionPrio.getValue());
        }
        if (way.hasTag("railway", (Object)"tram")) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID_MORE.getValue());
        }
        if (way.hasTag("lcn", (Object)"yes")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        if ((classBicycleValue = way.getTag(this.classBicycleKey)) != null) {
            weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycleValue).getValue());
        } else {
            String classBicycle = way.getTag("class:bicycle");
            if (classBicycle != null) {
                weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycle).getValue());
            }
        }
        if ((way.hasTag("scenic", (Object)"yes") || maxSpeed > 0.0 && maxSpeed <= wayTypeSpeed) && (lastEntryValue = weightToPrioMap.lastEntry().getValue().intValue()) < PriorityCode.BEST.getValue()) {
            int lastEntryIndex = Arrays.stream(PriorityCode.values()).filter(pc -> pc.getValue() == lastEntryValue).findFirst().orElse(PriorityCode.UNCHANGED).ordinal();
            weightToPrioMap.put(110.0, PriorityCode.values()[lastEntryIndex + 1].getValue());
        }
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    void setSpecificClassBicycle(String subkey) {
        this.classBicycleKey = "class:bicycle:" + subkey;
    }

    public final DecimalEncodedValue getPriorityEnc() {
        return this.priorityEnc;
    }
}

