/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CarAccessParser
extends AbstractAccessParser
implements TagParser {
    protected final Set<String> trackTypeValues = new HashSet<String>();
    protected final Set<String> highwayValues = new HashSet<String>();
    protected final BooleanEncodedValue roundaboutEnc;

    public CarAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "car"))), lookup.getBooleanEncodedValue("roundabout"), properties, TransportationMode.CAR);
    }

    public CarAccessParser(BooleanEncodedValue accessEnc, BooleanEncodedValue roundaboutEnc, PMap properties, TransportationMode transportationMode) {
        super(accessEnc, transportationMode);
        this.roundaboutEnc = roundaboutEnc;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("delivery");
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("permissive");
        this.barriers.add("kissing_gate");
        this.barriers.add("fence");
        this.barriers.add("bollard");
        this.barriers.add("stile");
        this.barriers.add("turnstile");
        this.barriers.add("cycle_barrier");
        this.barriers.add("motorcycle_barrier");
        this.barriers.add("block");
        this.barriers.add("bus_trap");
        this.barriers.add("sump_buster");
        this.barriers.add("jersey_barrier");
        this.highwayValues.addAll(Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street", "service", "road", "track"));
        this.trackTypeValues.addAll(Arrays.asList("grade1", "grade2", "grade3", null));
    }

    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return WayAccess.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return WayAccess.FERRY;
                }
            }
            return WayAccess.CAN_SKIP;
        }
        if ("service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return WayAccess.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && !this.trackTypeValues.contains(way.getTag("tracktype"))) {
            return WayAccess.CAN_SKIP;
        }
        if (!this.highwayValues.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return WayAccess.CAN_SKIP;
        }
        boolean permittedWayConditionallyRestricted = this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way);
        boolean restrictedWayConditionallyPermitted = this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
        if (!firstValue.isEmpty()) {
            String[] restrict;
            for (String value : restrict = firstValue.split(";")) {
                if (this.restrictedValues.contains(value) && !restrictedWayConditionallyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value) || permittedWayConditionallyRestricted) continue;
                return WayAccess.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (permittedWayConditionallyRestricted) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (!access.isFerry()) {
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (this.isOneway(way) || isRoundabout) {
                if (this.isForwardOneway(way)) {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
                if (this.isBackwardOneway(way)) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
        Map<String, Object> nodeTags = way.getTag("node_tags", Collections.emptyMap());
        this.handleNodeTags(edgeFlags, nodeTags);
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return !way.hasTag("oneway", (Object)"-1") && !way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isOneway(ReaderWay way) {
        return way.hasTag("oneway", (Collection<String>)this.oneways) || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }
}

