/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CarAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    public static final double CAR_MAX_SPEED = 140.0;
    protected final Map<String, Integer> trackTypeSpeedMap = new HashMap<String, Integer>();
    protected final Set<String> badSurfaceSpeedMap = new HashSet<String>();
    private final int badSurfaceSpeed;
    protected final Map<String, Integer> defaultSpeedMap = new HashMap<String, Integer>();

    public CarAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "car"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "car"))).getNextStorableValue(140.0));
    }

    public CarAverageSpeedParser(DecimalEncodedValue speedEnc, double maxPossibleSpeed) {
        super(speedEnc, maxPossibleSpeed);
        this.badSurfaceSpeedMap.add("cobblestone");
        this.badSurfaceSpeedMap.add("grass_paver");
        this.badSurfaceSpeedMap.add("gravel");
        this.badSurfaceSpeedMap.add("sand");
        this.badSurfaceSpeedMap.add("paving_stones");
        this.badSurfaceSpeedMap.add("dirt");
        this.badSurfaceSpeedMap.add("ground");
        this.badSurfaceSpeedMap.add("grass");
        this.badSurfaceSpeedMap.add("unpaved");
        this.badSurfaceSpeedMap.add("compacted");
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("trunk", 70);
        this.defaultSpeedMap.put("trunk_link", 65);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put(null, this.defaultSpeedMap.get("track"));
        this.badSurfaceSpeed = 30;
    }

    protected double getSpeed(ReaderWay way) {
        Integer tInt;
        String tt;
        String highwayValue = way.getTag("highway");
        Integer speed = this.defaultSpeedMap.get(highwayValue);
        if (speed == null) {
            speed = 10;
        }
        if (highwayValue.equals("track") && !Helper.isEmpty((String)(tt = way.getTag("tracktype"))) && (tInt = this.trackTypeSpeedMap.get(tt)) != null) {
            speed = tInt;
        }
        return speed.intValue();
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
                this.setSpeed(false, edgeFlags, ferrySpeed);
                if (this.avgSpeedEnc.isStoreTwoDirections()) {
                    this.setSpeed(true, edgeFlags, ferrySpeed);
                }
            }
            return;
        }
        double speed = this.getSpeed(way);
        speed = this.applyBadSurfaceSpeed(way, speed);
        this.setSpeed(false, edgeFlags, this.applyMaxSpeed(way, speed, false));
        this.setSpeed(true, edgeFlags, this.applyMaxSpeed(way, speed, true));
    }

    protected double applyMaxSpeed(ReaderWay way, double speed, boolean bwd) {
        double maxSpeed = CarAverageSpeedParser.getMaxSpeed(way, bwd);
        return CarAverageSpeedParser.isValidSpeed(maxSpeed) ? maxSpeed * 0.9 : speed;
    }

    protected double applyBadSurfaceSpeed(ReaderWay way, double speed) {
        if (this.badSurfaceSpeed > 0 && CarAverageSpeedParser.isValidSpeed(speed) && speed > (double)this.badSurfaceSpeed && way.hasTag("surface", this.badSurfaceSpeedMap)) {
            speed = this.badSurfaceSpeed;
        }
        return speed;
    }
}

